function risqueB=bootcompacp(X,mi,mo,c,model);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% bootcompacp                                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     X data
%     ff vector number of components
%     nbboot: number of bootstrap resamplings
%     mod:choice of probabilistic hypothesis
% OUTPUTS
%    varexp:explained variation of the pca models
%    risqueB measures the angle between the subspaces
%       spanned by loadings (see Canonical Analysis)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Residual bootstrap with 2-way data for pca        %
%   with different f    (1 to ff)                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/12/2001   version 1.0                        %
%   Christophe Durville               TOTALFINAELF  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% wic=[0.5029 0.5814 0.6402];
% lbc=[0.9 0.93 0.95];
% frc=[0.3529 0.4314 0.4902];
ff=[1:mi.nbfactors.min];
fmax=max(ff);
cent=mi.sam(1).cen(1);
scale=mi.sam(1).scal(1);
R=size(X);
nbboot=mi.valmethod.replicates;
if isequal(cent,1),% column-centering
   X=X-ones(R(1),1)*mean(X);
end;
if isequal(scale,1),% raw-scaling
   X=X./(sqrt(mean(X.^2,2))*ones(1,R(2)));
end;
coul=couleur(max(ff));
N=length(R);
[U,S,V]=svd(X,0);
risqueB(ff)=0;
if strcmp(model,'r'),
   for f=ff,
      A=U(:,1:f)*S(1:f,1:f);
      B=V(:,1:f);
      W=B*B';
      Xmod=A*B';
      E=X-Xmod;
      [Abootstrap, bootsam]=bootstrpanadon(nbboot,2,'residuelacp',E,A,B);
      somtrace=0;
      for b=1:nbboot,
         Bb=reshape(Abootstrap{2}(b,:),R(2),f);
         Wb=Bb*Bb';
         traceb=trace(Wb*W);
         somtrace=somtrace+traceb;
      end;
      risqueB(f)=f-(1/nbboot)*somtrace;
   end;  %ff
   [mini,ind]=min(risqueB);
elseif strcmp(model,'n'),
   [Abootstrap, bootsam]=bootstrpanadon(nbboot,2,'naifacp',X,fmax);
   somtrace(ff)=0;
   for b=1:nbboot,
      Bbm=reshape(Abootstrap{2}(b,:),R(2),fmax);
      for f=ff,
         %A=U(:,1:f)*S(1:f,1:f);
         B=V(:,1:f);
         W=B*B';
         Bb=Bbm(:,1:f);
         Wb=Bb*Bb';
         traceb=trace(Wb*W);
         somtrace(f)=somtrace(f)+traceb;
      end;
   end;
   for f=ff,
      risqueB(f)=f-(1/nbboot)*somtrace(f);
   end;
end;







%graphiques
hfig=findobj('userdata','Cubatch');
set(0,'currentfigure',hfig);
delete(findobj('tag','cbaxes'));
hhh=axes('parent',hfig,'tag','cbaxes','nextplot','replacechildren');
set(hhh,'position',[0.3,0.11,0.685,0.815]);  
plot(risqueB,'color','r');
ylab=['Bootstrap Estimation of the risk of the model'];
ylabel(ylab);
abci=['Number of PC'];
xlabel(abci);
if strcmp(model,'n')
   title('Naive bootstrap');
else
   title('Residual bootstrap');
end;






