function acpreport(MainFig,ReportStruct,Fil_id)

[mi,mo,c] = getcvdata(MainFig,'Model','Results','Content');

if any(ReportStruct.v_info)   %Validation info
    fwrite(Fil_id,[10 10],'char');
    fwrite(Fil_id,['Validation',10],'char');
    fwrite(Fil_id,['Method              : '],'char');
    fwrite(Fil_id,[mi.valmethod(1).name 10],'char');

end


if any(ReportStruct.v_results); %validation results
    if ~any(ReportStruct.m_results),fwrite(Fil_id,[10 10],'char');end
    fwrite(Fil_id,['Validation Results',10],'char');
    switch mi.valmethod.name
        case {'test','loo'}
        case {'nboo'}
            fwrite(Fil_id,['Naive bootstrap',10],'char');
            fwrite(Fil_id,['Bootstrap estimation of the risk of the model: Rhat =f(W(2), W(3)).'],'char');
            fwrite(Fil_id,[int2str(mo.validation.stats.risk),10],    'char');
        case {'rboo'}
            fwrite(Fil_id,['Residual bootstrap',10],'char');
            fwrite(Fil_id,['Bootstrap estimation of the risk of the model: Rhat =f(W(2), W(3)).'],'char');
            fwrite(Fil_id,[int2str(mo.validation.stats.risk),10],    'char');
        case {'cv'}
            fwrite(Fil_id,['Sum of Squares errors of the crossvalidated objects']);
            fwrite(Fil_id,[int2str(mo.validation.stats.risk),10],    'char'); 
    end
end


if any(ReportStruct.m_info) %model info
    
    %Model info and name
    fwrite(Fil_id,[10 'Model               : PCA' 10],'char');
    fwrite(Fil_id,['Number of factors   : '],                    'char');
    fwrite(Fil_id,[sprintf(' %i',[mi.nbfactors.min]),10 10],'char');
    %Preprocessing. NB the different scalings are not distinguished
    fwrite(Fil_id,[   'Preprocessing'                 10],'char');
    
    if ~isempty(mo.model(1).xpreproc.cen),
        fwrite(Fil_id,[   'Centring            : '   ],        'char');
        a = cellfun('isempty',mo.model(1).xpreproc.cen);
        fwrite(Fil_id,[int2str(~a(:)') 10],'char');
    end;
    if ~isempty(mo.model(1).xpreproc.scal),
        fwrite(Fil_id,[   'Scaling             : '   ],        'char');
        a = cellfun('isempty',mo.model(1).xpreproc.scal);
        fwrite(Fil_id,[int2str(~a(:)') 10 10],'char');
    end;
    
    %Algorithm information
    fwrite(Fil_id,[10,'Algorithm           : ' mi.options.algorithm.name 10],'char');
    
    
    %Convergence criteria
    fwrite(Fil_id,[10,'Convergence criteria: ' 10],                   'char');
    fwrite(Fil_id,[   'Relative fit        : '],                      'char');
    fwrite(Fil_id,[sprintf('%1.0e',mi.options.algorithm.value),10],   'char');
    
    
    %Max iterations
    fwrite(Fil_id,[10,'Max # iterations' 10],                    'char');
    fwrite(Fil_id,[   'Fitting             : '],                 'char');
    fwrite(Fil_id,[int2str(mi.options.algorithm.maxiter(1)),10],        'char');
end



if any(ReportStruct.m_results);
    fwrite(Fil_id,[10 10],'char');
    fwrite(Fil_id,['Model Results',10],'char');
    fwrite(Fil_id,['Number of factors   : '],'char');
    fwrite(Fil_id,[int2str(mi.nbfactors.min),10],    'char');
    fwrite(Fil_id,['Explained variance  : '],'char');
    fwrite(Fil_id,[sprintf('%3.2f%%',sum(mo.model(1).xev(1,:))),10],  'char');
    fwrite(Fil_id,['X RMSE              : '],'char');
    fwrite(Fil_id,[sprintf('%3.2f',mo.model(1).xrmse),10],'char');
    fwrite(Fil_id,['Factors',10],'char');
    for j = 1:length(mo.model(1).xfactors)  
        fwrite(Fil_id,sprintf('Mode [%i] - ',j),'char');
        fwrite(Fil_id,c{1}.modenames{j},'char');
        fwrite(Fil_id,[': ' 10],'char');
        Mat = num2str(mo.model(1).xfactors{j});
        Mat = [Mat,10 * ones(size(Mat,1),1)]';
        fwrite(Fil_id,Mat,'char');
        fwrite(Fil_id,[10 10],'char'); 
    end 
    fwrite(Fil_id,[10 10],'char');
    fwrite(Fil_id,['X modelised :',10],'char');
    Mat = num2str(mo.model(1).xpred);
    Mat = [Mat,10 * ones(size(Mat,1),1)]';
    fwrite(Fil_id,Mat,'char');
end

if any(ReportStruct.p_results);  %projection
    fwrite(Fil_id,char(10));
    fwrite(Fil_id,['Projection Results',10],                          'char');
    fwrite(Fil_id,['Size      :  '],                 'char');
    mo.prediction.data
    fwrite(Fil_id,[sprintf('%i',size(mo.prediction.data.data,1)),10],'char');
    %fwrite(Fil_id,['Explained variance  : '],'char'); 
    fwrite(Fil_id,['Factors',10],'char');
    fwrite(Fil_id,sprintf('Mode [%i] - ',1),'char');
    fwrite(Fil_id,c{1}.modenames{1},'char');
    fwrite(Fil_id,[': ' 10],'char');
    Mat = num2str(mo.prediction.xfactors{1});
    Mat = [Mat,10 * ones(size(Mat,1),1)]';
    fwrite(Fil_id,Mat,'char');
    fwrite(Fil_id,[10 10],'char');
    fwrite(Fil_id,['Projection of new samples :',10],'char');
    Mat = num2str(mo.prediction.xpred);
    Mat = [Mat,10 * ones(size(Mat,1),1)]';
    fwrite(Fil_id,Mat,'char');

end

return