function acpplot(typ,spl,mi,mo,c,d);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% acpplot                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%    typ,spl,mi,mo,c,d
% OUTPUTS
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE
%    acpplotwindow
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   16/12/2002   version 1.1                         %
%   Christophe Durville              TOTALFINAELF    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
guinames;
mainfig=findobj(0,'type','figure','userdata','Cubatch');
R=size(mo.model.xfactors{1});
u=nargin;
if nargin==6,
    X=d{1}.data;
    if ndims(d{1})>2,   %  N-way data
        d{1}=unfoldcbdataset(d{1});
    end;
    X=d{1}.data;
end;
if strcmp(typ,'gra'),
    [mi,mo,spl]= checkp(mi,mo,spl);
    acpplotwindow(spl,mi,mo);
    setcvdata(mainfig,'PlotStr',spl,'Results',mo,'Model',mi);
    h=findobj('tag','pcaplot');
    set(h,'waitstatus','open');
    waitfor(h,'waitstatus','close'); 
else %    (graphiques)
    set(0,'currentfigure',mainfig);
    delete(findobj('tag','cbaxes'));
    hhh=axes('parent',mainfig,'tag','cbaxes','nextplot','replacechildren');
    set(hhh,'position',sizeaxes{1}(1,:));
    set(mainfig,'currentaxes',hhh);
    cop=get(hhh,'colororder');
    [tacop,rr]=size(cop);
    spl=getappdata(mainfig,'PlotStr');
    switch typ  % different kinds of graphics     
        case 'mod'  % 123-D plots
            set(findobj('tag','plo'),'visible','on');
            set(findobj('tag','plo2'),'visible','on');
            g=getappdata(mainfig,'X');
            dim=g{1}.dims;
            N=length(g{1}.dims);
            if N==2,
                labe=c{1}.labels;
                dime=dim(spl.nummode);
            elseif N>2,
                %labels
                a= unfoldlabels(g{1});
                bb=a{1};
                b=a{2};
                labe{1}=bb;
                labe{2}=cellstr(b);    %du a une anomalie ds unfold labels
                dime=length(labe{spl.nummode});
            end;
            dimt=size(mo.prediction.xfactors);
            nt=length(spl.batch);
            coul=3;%couleur(nt);
            A=mo.model.xfactors{spl.nummode}*mo.model.core;
            switch mi.valmethod.bootstrap,
                case 0,   %No bootstrap
                    switch spl.plotdims
                        case 1, %1D plot
                            if  spl.factors(1)< R(2)+1,
                                plot(A(:,spl.factors(1)),'tag','plo','color',spl.color);
                            else
                                plot(A,'tag','plo');
                            end;
                            switch spl.format(1)
                                case 1 %integer
                                    set(findobj('tag','plo'),'marker','none');
                                    if  spl.factors(1)< R(2)+1,
                                        for i=1:dime,
                                            text(i,A(i,spl.factors(1)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                        end;
                                    else, %PCall  
                                        for j=1:R(2),
                                            for i=1:dime,
                                                text(i,A(i,j),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                            end; 
                                        end;
                                    end;
                                case 2,%label
                                    set(findobj('tag','plo'),'marker','none');
                                    if  spl.factors(1)< R(2)+1,
                                        for i=1:dime,
                                            text(i,A(i,spl.factors(1)),labe{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                        end;
                                    else, %PCall  
                                        for j=1:R(2)
                                            for i=1:dime,
                                                text(i,A(i,j),labe{spl.nummode}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                            end; 
                                        end;
                                    end;
                                case 3 %marker
                            end;
                            hold on;  %  projection
                            if ~isempty(mo.prediction.xfactors) & spl.nummode==1 ,
                                aa=size(mo.model.xfactors(1),1);
                                uu=size(mo.prediction.xfactors{1},1);
                                plot(aa+1:aa+uu,mo.prediction.xfactors{1}(:,spl.factors(1)),'*b','tag','proj');
                            end; 
                        case 2, %2D plot
                            if isequal(spl.additional.batchyn,0)|spl.nummode==2,
                                plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'color',spl.color,'tag','plo');
                                switch spl.format(1)
                                    case 1 %integer
                                        set(findobj('tag','plo'),'marker','none');
                                        for i=1:dime,
                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                        end;
                                    case 2,%label
                                        set(findobj('tag','plo'),'marker','none');
                                        for i=1:dime,
                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),labe{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                        end;
                                    case 3 %marker
                                        
                                end; 
                            else %batch data
                                nb=length(mi.file(1).size);
                                a=0;
                                for i=1:nb,
                                    plot(A(a+1:a+mi.file(1).size(i),spl.factors(1)),A(a+1:a+mi.file(1).size(i),spl.factors(2)),'color',cop(mod(i+tacop-1,tacop)+1,:),'tag','plo');
                                    hold on;
                                    switch spl.format(1)
                                        case 1 %integer
                                            set(findobj('tag','plo'),'marker','none');
                                            for j=a+1:a+mi.file(1).size(i),
                                                text(A(j,spl.factors(1)),A(j,spl.factors(2)),int2str(j-a),'fontsize',7,'color',cop(mod(i+tacop-1,tacop)+1,:),'tag','plo2');
                                            end;
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            for j=a+1:a+mi.file(1).size(i),
                                                text(A(j,spl.factors(1)),A(j,spl.factors(2)),labe{spl.nummode}(j),'fontsize',7,'color',cop(mod(i+tacop-1,tacop)+1,:),'tag','plo2');
                                            end;
                                        case 3 %marker
                                    end;
                                    a=a+mi.file(1).size(i);
                                end;
                            end;
                            hold on;   %  projection
                            if ~isempty(mo.prediction.xfactors) & spl.nummode==1 ,
                                plot(mo.prediction.xfactors{1}(:,spl.factors(1)),mo.prediction.xfactors{1}(:,spl.factors(2)),'*b','tag','proj');
                            end; 
                        case 3, %3D plot
                            set(gca,'view',[-37.5 30]);
                            if isequal(spl.additional.batchyn,0)|spl.nummode==2,
                                plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',spl.color,'tag','plo');
                                switch spl.format(1)
                                    case 1 %integer
                                        set(findobj('tag','plo'),'marker','none');
                                        for j=1:dime,
                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                        end;
                                    case 2,%label
                                        set(findobj('tag','plo'),'marker','none');
                                        for j=1:dime,
                                            text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),labe{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                        end;
                                    case 3 %marker
                                        
                                end;
                                
                            else %batch data
                                nb=length(mi.file(1).size);
                                a=0;
                                for i=1:nb,
                                    plot3(A(a+1:a+mi.file(1).size(i),spl.factors(1)),A(a+1:a+mi.file(1).size(i),spl.factors(2)),A(a+1:a+mi.file(1).size(i),spl.factors(3)),'color',cop(mod(i+tacop-1,tacop)+1,:),'tag','plo');
                                    hold on;
                                    switch spl.format(1)
                                        case 1 %integer
                                            set(findobj('tag','plo'),'marker','none');
                                            for j=a+1:a+mi.file(1).size(i),
                                                text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j-a),'fontsize',7,'color',cop(mod(i+tacop-1,tacop)+1,:),'tag','plo2');
                                            end;
                                        case 2,%label
                                            set(findobj('tag','plo'),'marker','none');
                                            for j=a+1:a+mi.file(1).size(i),
                                                text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),labe{spl.nummode}(j),'fontsize',7,'color',cop(mod(i+tacop-1,tacop)+1,:),'tag','plo2');
                                            end;
                                        case 3 %marker
                                    end;
                                    a=a+mi.file(1).size(i);
                                end;
                            end; % end batch data
                            
                            hold on;   %  projection
                            if ~isempty(mo.prediction.xfactors) & spl.nummode==1 ,
                                plot3(mo.prediction.xfactors{1}(:,spl.factors(1)),mo.prediction.xfactors{1}(:,spl.factors(2)),mo.prediction.xfactors{1}(:,spl.factors(3)),'*b','tag','proj');
                            end; 
                            if isequal(spl.additional.shadow, 1),
                                axe=axis;
                                plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),axe(5)*ones(dime,1),'color',[0.7 0.7 0.7],'tag','plo2');
                                plot3(A(:,spl.factors(1)),axe(4)*ones(dime,1),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                plot3(axe(2)*ones(dime,1),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',spl.color,'tag','plo');
                            end;
                            
                    end;
                    if spl.format(1)==3,
                        set(findobj('tag','plo'),'marker',spl.marker);
                    end;
                    set(findobj('tag','plo'),'linestyle',spl.linestyle);
                    
                    switch spl.format(2)
                        case 2 %discrete
                            set(findobj('tag','plo'),'linestyle','none');
                        case 1% continuous
                            %set(findobj('tag','plo'),'marker','none');
                    end;
                    
                    
                case 1,   %Naive bootstrap PCA
                    switch spl.plotdims,
                        case 1, %1D plot
                            spl.plotdims=1;
                            plot(A(:,spl.factors(1)),'tag','plo');
                            hold on;
                            if isequal(spl.nummode,1),
                                for i=1:mi.valmethod.replicates,
                                    uu=mo.validation.segments(:,i);
                                    Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                    if Ab(:,spl.factors(1))'*mo.model.xfactors{spl.nummode}(uu,spl.factors(1))<0
                                        Ab(:,spl.factors(1))=-Ab(:,spl.factors(1));
                                    end;
                                    plot(uu,Ab(:,spl.factors(1)),'+b','tag','plo2');
                                end;
                            elseif isequal(spl.nummode,2),
                                for i=1:mi.valmethod.replicates,                  
                                    Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                    plot(Bb(:,spl.factors(1)),'+b','tag','plo2');
                                end;
                            end;
                            plot(A(:,spl.factors(1)),'tag','plo');
                            set(findobj('tag','plo'),'color',spl.color);
                            
                            if spl.format(1)==3,
                                set(findobj('tag','plo'),'marker',spl.marker);
                            else
                                set(findobj('tag','plo'),'marker','none');
                                if spl.format(1)==2,
                                    for jj=1:c{1}.dims(spl.nummode),
                                        text(jj,A(jj,spl.factors(1)),labe{spl.nummode}(jj),'color',spl.color,'fontsize',7,'tag','plo2');
                                    end;
                                end;
                            end;
                            switch spl.format(2),
                                case 2 %discrete
                                    set(findobj('tag','plo'),'linestyle','none');
                                case 1% continuous
                                    set(findobj('tag','plo'),'linestyle',spl.linestyle);
                            end;  
                        case 2,  %2D plot
                            coul=couleur(c{1}.dims(spl.nummode));
                            spl.plotdims=2;
                            plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                            hold on;
                            if isequal(spl.nummode,1),
                                m(1:c{1}.dims(1))=0;
                                for i=1:mi.valmethod.replicates,
                                    uu=mo.validation.segments(:,i);
                                    Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                    for v=1:mi.nbfactors.min, % changement de signe du mode 1
                                        if Ab(:,v)'*A(uu,v)<0
                                            Ab(:,v)=-Ab(:,v);
                                        end
                                    end;
                                    for j=1:c{1}.dims(1),  %on elimine les points redondants 
                                        rr=uu(j);
                                        if j>1 & mean(uu(j)==uu(1:j-1))>0
                                        else
                                            m(rr)=m(rr)+1;
                                            Abstock{uu(j)}(m(rr),:)=Ab(j,:);
                                        end;
                                    end;
                                end;
                                for jj=1:c{1}.dims(1),   %traage des enveloppes convexes
                                    Abech=Abstock{jj}(:,:);
                                    tai=size(Abech);
                                    if tai(1)>2,
                                        k=convhull(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                        aire{1}(jj)=polyarea(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                        fill(Abech(k,spl.factors(1)),Abech(k,spl.factors(2)),coul(jj,:));
                                        hold on;
                                    end;
                                    if spl.format(1)==1,
                                        text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                    elseif spl.format(1)==2,
                                        text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),labe{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                    elseif spl.format(1)==3,
                                        text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2'); 
                                    end;
                                end;
                                axis equal;
                            elseif isequal(spl.nummode,2),
                                for i=1:mi.valmethod.replicates,
                                    Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                    Bbstock(i,:,:)=Bb(:,:);	
                                end;
                                for jj=1:c{1}.dims(2),   %tracage des enveloppes convexes
                                    Bbech=squeeze(Bbstock(:,jj,:));
                                    tai=size(Bbech);
                                    if tai(1)>2
                                        k=convhull(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                        aire{2}(jj)=polyarea(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                        fill(Bbech(k,spl.factors(1)),Bbech(k,spl.factors(2)),coul(jj,:));
                                        hold on;
                                    end;
                                    if spl.format(1)==1,
                                        text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                    elseif spl.format(1)==2,
                                        text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),labe{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                    elseif spl.format(1)==3,
                                        text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2');                        
                                    end;
                                end;
                                % mettre 
                            end;  %if/elseif nummode
                            plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                            set(findobj('tag','plo'),'marker','none');
                            switch spl.format(2),
                                case 2 %discrete
                                    set(findobj('tag','plo'),'linestyle','none');
                                case 1% continuous
                                    set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                    set(findobj('tag','plo'),'color',spl.color);
                            end;   
                    end; %switch spl.plotdims
                case 2,   %Residual bootstrap plotPCA
                    switch spl.plotdims,
                        case 1, %1D plot
                            spl.plotdims=1;
                            plot(A(:,spl.factors(1)),'tag','plo');
                            hold on;
                            if isequal(spl.nummode,1),
                                for i=1:mi.valmethod.replicates,
                                    Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                    if Ab(:,spl.factors(1))'*A(:,spl.factors(1))<0
                                        Ab(:,spl.factors(1))=-Ab(:,spl.factors(1));
                                    end;
                                    plot(Ab(:,spl.factors(1)),'b','tag','plo2');
                                    hold on;
                                end;
                            elseif isequal(spl.nummode,2),
                                for i=1:mi.valmethod.replicates,                  
                                    Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                    plot(Bb(:,spl.factors(1)),'b','tag','plo2');
                                    hold on;
                                end;
                            end;
                            plot(A(:,spl.factors(1)),'tag','plo');
                            set(findobj('tag','plo'),'color',spl.color);
                            if spl.format(1)==3,
                                set(findobj('tag','plo'),'marker',spl.marker);
                            else
                                set(findobj('tag','plo'),'marker','none');
                                if spl.format(1)==2,
                                    for jj=1:c{1}.dims(spl.nummode),
                                        text(jj,A(jj,spl.factors(1)),labe{spl.nummode}(jj),'color',spl.color,'fontsize',7,'tag','plo2');
                                    end;
                                end;
                            end;
                            switch spl.format(2),
                                case 2 %discrete
                                    set(findobj('tag','plo'),'linestyle','none');
                                case 1% continuous
                                    set(findobj('tag','plo'),'linestyle',spl.linestyle);
                            end;  
                        case 2,  %2D plot
                            coul=couleur(c{1}.dims(spl.nummode));
                            spl.plotdims=2;
                            plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                            hold on;
                            if isequal(spl.nummode,1),
                                m(1:c{1}.dims(1))=0;
                                for i=1:mi.valmethod.replicates,
                                    Ab=mo.validation.xfactors{spl.nummode}(:,:,i);
                                    Abstock(i,:,:)=Ab(:,:);
                                    for v=1:mi.nbfactors.min, % changement de signe du mode 1
                                        if Ab(:,v)'*A(:,v)<0
                                            Ab(:,v)=-Ab(:,v);
                                        end
                                    end;
                                end;
                                for jj=1:c{1}.dims(1),   %traage des enveloppes convexes
                                    Abech=squeeze(Abstock(:,jj,:));
                                    tai=size(Abech);
                                    if tai(1)>2,
                                        k=convhull(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                        aire{1}(jj)=polyarea(Abech(:,spl.factors(1)),Abech(:,spl.factors(2)));
                                        fill(Abech(k,spl.factors(1)),Abech(k,spl.factors(2)),coul(jj,:));
                                        hold on;
                                    end;
                                    if spl.format(1)==1,
                                        text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                    elseif spl.format(1)==2,
                                        text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),labe{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                    elseif spl.format(1)==3,
                                        text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2'); 
                                    end;
                                end;
                                axis equal;
                            elseif isequal(spl.nummode,2),
                                for i=1:mi.valmethod.replicates,
                                    Bb=mo.validation.xfactors{spl.nummode}(:,:,i);
                                    Bbstock(i,:,:)=Bb(:,:);	
                                end;
                                for jj=1:c{1}.dims(2),   %traage des enveloppes convexes
                                    Bbech=squeeze(Bbstock(:,jj,:));
                                    tai=size(Bbech);
                                    if tai(1)>2
                                        k=convhull(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                        aire{2}(jj)=polyarea(Bbech(:,spl.factors(1)),Bbech(:,spl.factors(2)));
                                        fill(Bbech(k,spl.factors(1)),Bbech(k,spl.factors(2)),coul(jj,:));
                                        hold on;
                                    end;
                                    if spl.format(1)==1,
                                        text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),int2str(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                    elseif spl.format(1)==2,
                                        text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),labe{spl.nummode}(jj),'color',1-coul(jj,:),'fontsize',7,'tag','plo2');
                                    elseif spl.format(1)==3,
                                        text(A(jj,spl.factors(1)),A(jj,spl.factors(2)),spl.marker,'color',1-coul(jj,:),'fontsize',7,'tag','plo2'); 
                                    end;
                                end
                            end;  %if/elseif
                            plot(A(:,spl.factors(1)),A(:,spl.factors(2)),'tag','plo');
                            set(findobj('tag','plo'),'marker','none');
                            switch spl.format(2),
                                case 2 %discrete
                                    set(findobj('tag','plo'),'linestyle','none');
                                case 1% continuous
                                    set(findobj('tag','plo'),'linestyle',spl.linestyle);
                                    set(findobj('tag','plo'),'color',spl.color);
                            end; 
                    end; %switch spl.plotdims         
            end; %switch s.bootstrap
            if spl.factors(1)> R(2), % PC all
                xl=['All PC'];
                for i=1:R(2),
                    leg{i}=['PC',int2str(i)];
                end;
                legend(leg{:},0);
            else
                xl=['PC',int2str(spl.factors(1)),':',num2str(mo.model.xev(spl.factors(1))),'%'];
            end;
            xlabel(xl,'tag','xlab');
            if spl.plotdims>1 ,
                yl=['PC',int2str(spl.factors(2)),':',num2str(mo.model.xev(spl.factors(2))),'%'];
                ylabel(yl,'tag','ylab');
                if spl.plotdims>2,
                    zl=['PC',int2str(spl.factors(3)),':',num2str(mo.model.xev(spl.factors(3))),'%'];
                    zlabel(zl,'tag','zlab');
                end;
            end;
            X=getappdata(mainfig,'X');
            lab=X{1}.modenames;
            if length(lab{spl.nummode})>3
                if strcmp(lab{spl.nummode}(1:4),'Mode'),
                    titre=[lab{spl.nummode}];
                else 
                    titre=['Mode ',int2str(spl.nummode),': ',lab{spl.nummode}];
                end;
            else
                titre=[lab{spl.nummode}];
            end;
            title(titre);
            set(gca,'Xgrid',spl.grid,'Ygrid',spl.grid,'Zgrid',spl.grid);
            if spl.additional.potential.exist==1 & spl.plotdims==2,
                %clear figures;  %anti-bug matlab
                axi=axis;
                hold on;
                try
                    potentiel('gra',spl,A,axi);
                catch
                    uiwait(errordlg({'Error during the calculation of the potential function',lasterr}));
                end;
            end;
            if spl.additional.hotelling.exist==1 & (spl.plotdims==2|spl.plotdims==3),  %hotelling ellipsoid
                hold on;
                try
                    hotel('gra',spl,A);
                catch
                    uiwait(errordlg({'Error during the calculation of the Hotelling''s ellipsoid',lasterr}));
                end;
            end;
            set(findobj('tag','plo'),'visible',spl.visible);
            set(findobj('tag','plo2'),'visible',spl.visible);
            hold off;
        case 'xmo',
            surf(mo.model.xfactors{1}*mo.model.core*mo.model.xfactors{2}');
            xlabel(c{1}.modenames{2});
            ylabel(c{1}.modenames{1});
            title('Model of X');
        case 'res',
            Xm=mo.model.xfactors{1}*mo.model.core*mo.model.xfactors{2}';
            surf(X-Xm);
            xlabel(c{1}.modenames{2});
            ylabel(c{1}.modenames{1});
            title('Residuals of X');
        case 'exv' % Explained variance
            barh(mo.model.xev);
            set(gca,'ydir','reverse');
            xlabel('Explained variance (%)');
            ylabel('PC');
        case 'hotel',
            lab=get(gcbo,'label');
            i=eval(lab(6:end));
            if i==1 & ~isempty(mo.prediction.stats.hotelling) & iscell(mo.prediction.stats.expvar)
                a=size(mo.model.stats.hotelling{i},1);
                b=size(mo.prediction.stats.hotelling{i},1);
                bar([mo.model.stats.hotelling{i}; mo.prediction.stats.hotelling{1}]);
                hold on;
                bar([a+1:a+b], mo.prediction.stats.hotelling{1},'r');
                hold off;
            else
                bar([mo.model.stats.hotelling{i}]);
            end;
            X=getappdata(mainfig,'X');
            lab=X{1}.modenames;
            ylabel('T2 Hotelling statistic');
            xlabel('Modalities');
            if length(lab{spl.nummode})>3
                if strcmp(lab{spl.nummode}(1:4),'Mode'),
                    titre=[lab{spl.nummode}];
                else 
                    titre=['Mode ',int2str(spl.nummode),': ',lab{spl.nummode}];
                end;
            else
                titre=[lab{spl.nummode}];
            end;
            title(titre);   
        case 'qual',
            lab=get(gcbo,'label');
            i=eval(lab(6:end));
            if i==1 & ~isempty(mo.prediction.stats.expvar) & iscell(mo.prediction.stats.expvar)
                a=size(mo.model.stats.expvar{i},1);
                b=size(mo.prediction.stats.expvar{i},1);
                bar([mo.model.stats.expvar{i}*100; mo.prediction.stats.expvar{1}*100]);
                hold on;
                bar([a+1:a+b], mo.prediction.stats.expvar{1}*100,'r');
                hold off;
            else
                bar([mo.model.stats.expvar{i}*100]);
            end;
            X=getappdata(mainfig,'X');
            lab=X{1}.modenames;
            ylabel('Exp. Var. (%)');
            xlabel('Modalities');
            lab=X{1}.modenames;
            if length(lab{spl.nummode})>3
                if strcmp(lab{spl.nummode}(1:4),'Mode'),
                    titre=[lab{spl.nummode}];
                else 
                    titre=['Mode ',int2str(spl.nummode),': ',lab{spl.nummode}];
                end;
            else
                titre=[lab{spl.nummode}];
            end;
            title(titre);
        case 'sse',
            lab=get(gcbo,'label');
            i=eval(lab(6:end));
            if i==1 & ~isempty(mo.prediction.stats.quality) & iscell(mo.prediction.stats.expvar)
                a=size(mo.model.stats.quality{i},1);
                b=size(mo.prediction.stats.quality{i},1);
                bar([mo.model.stats.quality{i}; mo.prediction.stats.quality{1}]);
                hold on;
                bar([a+1:a+b], mo.prediction.stats.quality{1},'r');
                hold off;
            else
                bar([mo.model.stats.quality{i}]);
            end;
            X=getappdata(mainfig,'X');
            lab=X{1}.modenames;
            ylabel('RSS');
            xlabel('Modalities');
            lab=X{1}.modenames;
            if length(lab{spl.nummode})>3
                if strcmp(lab{spl.nummode}(1:4),'Mode'),
                    titre=[lab{spl.nummode}];
                else 
                    titre=['Mode ',int2str(spl.nummode),': ',lab{spl.nummode}];
                end;
            else
                titre=[lab{spl.nummode}];
            end;
            title(titre);
    end;  %switch type
    hold off;
    setappdata(mainfig,'PlotStr',spl);
end;  %graphiques