function ress=acpcroval(X,fmax,algo,optio);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% acpcroval                                          %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     X  matrix
%     fmax:max number of components
%     algo: name of the algorithm 'SVD' or 'Nipals'
%     optio:
% OUTPUTS
%     U S V:score and loadings of X.
%     vexp:  explained variation of X.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  cross validation of PCA                          %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/11/2002   version 1.1                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
guinames;
R=size(X);
R1=R(1)-1;
fmax=min([fmax,R1]);
%[U,S,V,vexp,Xm]=acpf(X,fmax,algo,optio);
for i=1:R(1),
    u=X(i,:);
    Xi=X;
    Xi(i,:)=[];
    [Ui,Si,Vi]=acpf(Xi,fmax,algo,optio);
    for f=1:fmax,
        Vii=Vi(:,1:f);
        fu=u*Vii*Vii';
        res(i,f)=sum((u-fu).^2);
    end;
end;
ress=sum(res);

%graphiques
hfig=findobj('userdata','Cubatch');
set(0,'currentfigure',hfig);
delete(findobj('tag','cbaxes'));
hhh=axes('parent',hfig,'tag','cbaxes','nextplot','replacechildren');
set(hhh,'position',sizeaxes{1});  
plot(ress,'color','r');
ylab=['Sum of Squares of the cross-validated objects'];
ylabel(ylab);
abci=['Number of PC'];
xlabel(abci);

