function [mi,mo] = acpapply(mi,mo,spl);


Guinames;
mainfig=findobj('userdata','Cubatch');
X=getappdata(mainfig,'X');
%try
if length(mo.model) ~= 1
    ListProp = {'selectionmode','single','name','Choose model','promptstring','Select the model to apply'};
    ReqTit   = 'Choose model';
    Cont     = cellstr(num2str(cat(1,mo.model.nbfactors)));
    [RankPos,Ok] = listdlg('Liststring',Cont,ListProp{:});
    if ~Ok
        return
    end
end
ListProp          = {'selectionmode','single','name','Load array','promptstring','Select the array to load'};
ReqTit            = 'Load data';
[Xt,Yt,Xfil,Yfil] = deal({});
try
    cd data
    [Xfil{2:-1:1}]    = uigetfile('*.mat',ReqTit);   % chargement des donnes
    cd ..
catch
    [Xfil{2:-1:1}]    = uigetfile('*.mat',ReqTit);   % chargement des donnes
end;
RankPos           = 1;
if Xfil{1} ~= 0
    Cont = who('-file',[Xfil{:}]);
    Ok   = 1;
    Sel  = 1;
    if length(Cont) > 1
        [Sel,Ok] = listdlg('Liststring',Cont,ListProp{:});
    end
    if Ok
        Xt   = load([Xfil{:}],Cont{Sel});
        Xt   = getfield(Xt,Cont{Sel});
        if ~isempty(Xt)

                if iscell(Xt)
                    if ~isa(Xt{1},'cbdataset'),
                        return;
                    else
                        Xn=Xt{1};
                    end;
                else 
                    if isa(Xt,'cbdataset'),
                        Xn=Xt;
                    else
                        Xn=cbdataset(Xt);
                    end;
                end;
                DimX=Xn.dims;
                Nx=length(DimX);
                %--------MODIFICATION BY CD - 29 08 02
                DimM = size(X{1}.data);
                Np=length(DimM);
                if DimX(2:end) ~= DimM(2:end) & ~(Np==Nx-1 & DimX(2:end) == DimM),
                    %if assouplissement de la contrainte  faire 
                    uiwait(errordlg({'2The current model cannot be applied to this data set:','the dimensions are not compatible'}))
                    return
                end
        else
            return
        end
    else 
        return
    end
else
    return
end
mo=getappdata(mainfig,'Results');
if isempty(mo.prediction.data),
    mo.prediction.data = Xn;
    Rpold=0;
else 
    Rpold=mo.prediction.data.dims;
    mo.prediction.data=cat(1,mo.prediction.data,Xn);
end;

% displayinfo
% displayInfo(gcbf,mo.data.dataset);


% calculate the model
Rp=mo.prediction.data.dims;
Np=length(Rp);
dd=mo.prediction.data.data;
if ndims(dd)>2,  %reshape les cubes si besoin
    Rdd=size(dd);
    dd=reshape(dd,Rdd(1),prod(Rdd(2:ndims(dd))));
end;
if sum([mi.sam(1).cen(1),mi.var.cen,mi.sam(1).scal(1),mi.var.scal])>0,
    try
        [dd]=nprocess(dd,[mi.sam(1).cen(1),mi.var(1).cen],[mi.sam(1).scal(1),mi.var(1).scal],mo.model.xpreproc.cen,mo.model.xpreproc.scal,1);
    catch
        uiwait(errordlg({'Error in the preprocessing of the projection part.',lasterr}));
    end;
end;
for i=Rpold(1)+1:Rp(1),
    [xpred,fxpred] = acpproj(squeeze(dd(i,:)),mo.model.xfactors{2});
    mo.prediction.xfactors{1}(i,:)=fxpred;
    mo.prediction.xpred(i,:)=xpred;
end;

try
    % Estimation de la qualit des nouveaux echantillons
    [qual,expv,hotel]=qualitecubepredic(dd,mo.prediction.xpred,mo.model.xfactors{1}*mo.model.core,mo.prediction.xfactors{1});
    mo.prediction.stats.quality=qual;
    mo.prediction.stats.expvar=expv;
    mo.prediction.stats.hotelling=hotel; 
catch
    uiwait(errordlg({'Error in the calculus of quality of projected points',lasterr}));
end;

%provisoire 
setappdata(gcbf,'Results',mo);

% actualize the current plot
%try
spl=getappdata(gcbf,'PlotStr');
if mi.nbfactors.min(spl.nummode)>spl.plotdims-1 & isequal(spl.nummode,1),
    acpplot('mod',spl,mi,mo,getappdata(gcbf,'Content'));
else
    uiwait(warndlg({'No default plot available:','to have some, enter in the menu "Results".'}));
end;

return
