function [U,S,V,vexp,Xm,it]=acpf(X,f,algo,optio);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% acpf
% pca function
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     X  matrix
%     f:number of components
%     algo
%     optio
% OUTPUTS
%     U S V: score and loadings of X.
%     vexp:  explained variation of X.
%     Xm:    model of X
%     it:    number of iterations
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/11/2002   version 1.2                        %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


R=size(X);
it=0;
if ~isnan(sum(X(:))),   
    if strcmp(algo,'SVD'),
        [U S V]=Svd2(X,0);
        Ru=size(U);
        Rv=size(V);
        if f<=Ru(2);
            U=U(:,1:f);
        end;
        if f<=Rv(2),
            S=S(1:f,1:f);
            V=V(:,1:f); 
        end;
    elseif strcmp(algo,'Nipals'),
        [U S V flag]=svds(X,f,'L',optio);
        if flag,
            it=optio.maxit;
        end;
    else
        uiwait(errordlg({'Warning!no algorithm executed!'}))
    end;
else
    [U,S,V,Xm,it]=msvd(X,f,0,optio.tol,optio.maxit);
    S=S(1:f,1:f);
    U=U*inv(S);
end;


vexp=0;
%calcul dez variances expliques par PC
if nargout>3
    for i=1:f,
        try
            Xi=U(:,i)*S(i,i)*V(:,i)';
        catch
            uiwait(errordlg({'Recidivist bug:','please contact christophe with maximum informations',' in order to eradicate it.',lasterr}));
            return;
        end;
        vexp(i)=100-100*misssum((Xi(:)-X(:)).^2)/misssum(X(:).^2);
    end;
end;

Xm=0;
%reconstruction du modele
if nargout>4
    Xm=U*S*V';
end;


