function [ModelIn,ModelOut]=acp(ModelIn);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pca                                                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     ModelIn structure
% OUTPUTS
%     ModelIn structure
%     ModelOut structure
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   07/11/2002    version 1.2                       %
%   Christophe Durville           TOTALFINAELF      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

mainfig=findobj('type','figure','userdata','Cubatch');
guinames;
u=nargin;
h=findobj('tag','pca');
if isempty(h),
    ModelIn.modelname='PCA';
    X=getappdata(mainfig,'X');
    modenames=X{1}.modenames;
    No=ndims(X{1}.data);
    Ro=size(X{1}.data);
    [ModelIn]=check(ModelIn);
    h0 = figure('MenuBar','none', ...
        'Name','PCA', ...
        'userdata','window',...
        'NumberTitle','off', ...
        'Position',[400 300 360 280], ...
        'resize','off',...
        'color',WIC,...
        'Tag','pca',...
        'toolbar','none');
    h1 = uimenu('Parent',h0, ...
        'Label','&Preferences', ...
        'Tag','pref');
    if isempty(ModelIn.options.algorithm.name),
        ModelIn.options.algorithm.name='SVD';
    end;
    if isempty(ModelIn.options.algorithm.maxiter),
        ModelIn.options.algorithm.maxiter=300;
    end;
    if isempty(ModelIn.options.algorithm.value),
        ModelIn.options.algorithm.value=1e-10;
    end;
    h2 = uimenu('Parent',h1, ...
        'Label','&Algorithms', ...
        'Tag','algo');
   
    
    h3 = uimenu('Parent',h2, ...
        'Callback','evalin(''caller'',''ModelIn.options.algorithm.name=''''Nipals'''';set(gcbo,''''checked'''',''''on'''');set(findobj(''''tag'''',''''svd''''),''''checked'''',''''off'''');'');', ...
        'Label','&Nipals', ...
        'Tag','Nipals');
    h3 = uimenu('Parent',h2, ...
        'Callback','evalin(''caller'',''ModelIn.options.algorithm.name=''''SVD'''';set(gcbo,''''checked'''',''''on'''');set(findobj(''''tag'''',''''Nipals''''),''''checked'''',''''off'''');'');', ...
        'Label','&svd', ...
        'Tag','svd');
    
    if strcmp(ModelIn.options.algorithm.name,'Nipals'),
        set(findobj('tag','Nipals'),'checked','on');
        set(findobj('tag','svd'),'checked','off');
    elseif strcmp(ModelIn.options.algorithm.name,'SVD'),
        set(findobj('tag','Nipals'),'checked','off');
        set(findobj('tag','svd'),'checked','on');
    end;
     X=getappdata(mainfig,'X');
     if sum(isnan(X{1}.data(:)));
         set(findobj('tag','svd'),'enable','off');
         ModelIn.options.algorithm.name='Nipals';
         set(findobj('tag','Nipals'),'checked','on');
     end;
    h2 = uimenu('Parent',h1, ...
        'Label','&Constraints', ...
        'Tag','const');
    h3 = uimenu('Parent',h2, ...
        'Callback','', ...
        'Label','No constraint', ...
        'checked','on',...
        'Tag','noconst');
    h2 = uimenu('Parent',h1, ...
        'separator','on',...
        'Label','&Bootstrap');
    h3 = uimenu('Parent',h2, ...
        'Label','Bootstrap PCA');
    h4 = uimenu('Parent',h3, ...
        'Callback','evalin(''caller'',''ModelIn.valmethod.bootstrap=1;'');set(gcbo,''checked'',''on'');set(findobj(''tag'',''rb''),''checked'',''off'');', ...
        'tag','nb',...
        'Label','Naive bootstrap');
    h4 = uimenu('Parent',h3, ...
        'Callback','evalin(''caller'',''ModelIn.valmethod.bootstrap=2;'');set(gcbo,''checked'',''on'');set(findobj(''tag'',''nb''),''checked'',''off'');', ...
        'tag','rb',...
        'Label','Residual bootstrap');
    if isempty(ModelIn.valmethod.bootstrap),
        ModelIn.valmethod.bootstrap=0;
    end;
    if ModelIn.valmethod.bootstrap<2,
        set(findobj('tag','nb'),'checked','on');
        set(findobj('tag','rb'),'checked','off');
    elseif isequal(ModelIn.valmethod.bootstrap,2),
        set(findobj('tag','rb'),'checked','on');
        set(findobj('tag','nb'),'checked','off');
    end;
    if isempty(ModelIn.valmethod.replicates),
        ModelIn.valmethod.replicates=5; %default values
    end;
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''fnbboot(ModelIn.valmethod.replicates);'');',...
        'Label','Bootstrap replications');
    
    h1 = uimenu('Parent',h0, ...
        'Callback','', ...
        'Label','&Help', ...
        'Tag','help');
    
    
    ModelIn.valmethod.name='none';
    h1=uicontrol('parent', h0,...      % Frame validation
        'fontweight','normal',...
        'fontsize',10,...
        'backgroundcolor',FRC,...
        'tooltipstring','Validation window',...
        'position',[10 10 160 130],...
        'style','frame');
    h1=uicontrol('parent', h0,...      % validate
        'string','Validation',...
        'tag','validate',...
        'fontsize',12,...
        'callback','if get(gcbo,''value'')==1,set(findobj(''userdata'',''vm''),''enable'',''on'',''value'',0);set(findobj(''tag'',''boopca''),''enable'',''off'');set(findobj(''tag'',''croval''),''value'',1);evalin(''caller'',''ModelIn.valmethod.name=''''cv'''';'');else set(findobj(''userdata'',''vm''),''enable'',''off'');set(findobj(''tag'',''boopca''),''enable'',''on'');evalin(''caller'',''ModelIn.valmethod.name=''''none'''';'');end;',...
        'backgroundcolor',FRC,...
        'position',[20 110 130 20],...
        'tooltipstring','Check only if You want to do a validation of PCA.',...  
        'style','checkbox');
    h1=uicontrol('parent', h0,...      % Cross Validation
        'string','Cross-Validation',...
        'fontsize',12,...
        'callback','if get(gcbo,''value'')==1,evalin(''caller'',''ModelIn.valmethod.name=''''cv'''';'');set(findobj(''userdata'',''vm''),''value'',0);set(gcbo,''value'',1);else set(gcbo,''value'',1);end;',...
        'tag','croval',...
        'userdata','vm',...
        'value',1,...
        'backgroundcolor',FRC,...
        'enable','off',...
        'position',[35 90 130 20],...
        'tooltipstring','get off one row',...  
        'style','radiobutton');
    h1=uicontrol('parent', h0,...      % bootstrap validation:naive
        'string','Naive bootstrap',...
        'fontsize',12,...
        'userdata','vm',...
        'callback','if get(gcbo,''value'')==1,evalin(''caller'',''ModelIn.valmethod.name=''''nboo'''';'');set(findobj(''userdata'',''vm''),''value'',0);set(gcbo,''value'',1);else set(gcbo,''value'',1);end;',...
        'tag','booval1',...
        'value',0,...
        'backgroundcolor',FRC,...
        'enable','off',...
        'position',[35 70 130 20],...
        'tooltipstring','Resample the rows of X.',...  
        'style','radiobutton');
    h1=uicontrol('parent', h0,...      % bootstrap validation:residual
        'string','Residual bootstrap',...
        'fontsize',12,...
        'callback','if get(gcbo,''value'')==1,evalin(''caller'',''ModelIn.valmethod.name=''''rboo'''';'');set(findobj(''userdata'',''vm''),''value'',0);set(gcbo,''value'',1);else set(gcbo,''value'',1);end;',...
        'tag','booval2',...
        'backgroundcolor',FRC,...
        'userdata','vm',...
        'enable','off',...
        'position',[35 50 134 20],...
        'tooltipstring','Resample the rows of the residuals of PCA(X).',...  
        'style','radiobutton');
    h1=uicontrol('parent', h0,...   %nbPC text
        'string', 'Number of PC',...
        'fontweight','normal',...
        'fontsize',10,...
        'backgroundcolor',WIC,...
        'position',[0 235 110 20],...
        'style','text');
    if isempty(ModelIn.nbfactors.min)|length(ModelIn.nbfactors.min)>1,
        ModelIn.nbfactors.min=6;
    end;
    h1=uicontrol('parent', h0,...     %nbPC
        'string',ModelIn.nbfactors.min,...
        'callback','evalin(''caller'',''ModelIn.nbfactors.min=eval(get(gcbo,''''string''''));'');',...
        'fontweight','normal',...
        'fontsize',12,...
        'tag','npc',...
        'position',[110 235 40 20],...
        'style','edit');
    h1=uicontrol('parent', h0,...      %close button
        'string','Close',...
        'callback','delete(findobj(''userdata'',''window''));',...
        'fontsize',12,...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 10 130 30],...
        'tooltipstring','close "PCA"',...  
        'style','pushbutton');
    h1=uicontrol('parent', h0,...   %  PCA
        'tag','OKpca',...
        'string','OK',... 
        'fontsize',12,...
        'callback','evalin(''caller'',''ModelIn.valmethod.bootstrap=0;[ModelIn,ModelOut]=acp(ModelIn);'')',...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 60 130 30],...
        'tooltipstring','Normal PCA',...  
        'style','pushbutton');
    h1=uicontrol('parent', h0,...   %  bootstrap PCA
        'tooltipstring','Convex hulls,etc...',...  
        'string','Bootstrap',...
        'fontsize',12,...
        'tag','boopca',...
        'callback','evalin(''caller'',''if ModelIn.valmethod.bootstrap==0, ModelIn.valmethod.bootstrap=1;end;[ModelIn,ModelOut]=acp(ModelIn);'')',...
        'backgroundcolor',[0.7 0.7 0.7],...
        'position',[200 95 130 30],...
        'tooltipstring','Bootstrap PCA',...  
        'style','pushbutton');
    
    h1=uicontrol('parent', h0,...      %frame preprocess
        'fontweight','normal',...
        'fontsize',10,...
        'backgroundcolor',FRC,...
        'position',[190 140 160 130],...
        'tooltipstring','Preprocessing window',...
        'style','frame');
    h1=uicontrol('parent', h0,...     %  colum-centering
        'tag','cc',...
        'string','Column-centered',...
        'fontsize',12,...
        'callback','evalin(''caller'',''if get(gcbo,''''value'''')==1,ModelIn.sam(1).cen(1)=1;else ModelIn.sam(1).cen(1)=0;end;'');',...
        'backgroundcolor',FRC,...
        'position',[200 240 130 20],...
        'tooltipstring','substract the mean of each column',...  
        'style','checkbox');
    h1=uicontrol('parent', h0,...    %column-scaling
        'tag','cs',...
        'string','Column-scaled',...
        'fontsize',12,...
        'callback','evalin(''caller'',''if get(gcbo,''''value'''')==1,ModelIn.var(1).scal(1)=1;else ModelIn.var(1).scal(1)=0;end;'');',...
        'backgroundcolor',FRC,...
        'position',[200 220 130 20],...
        'tooltipstring','divide by the norm of each column',...  
        'style','checkbox');
    h1=uicontrol('parent', h0,...     %  row-centering
        'tag','rc',...
        'string','Row-centered',...
        'fontsize',12,...
        'callback','evalin(''caller'',''if get(gcbo,''''value'''')==1,ModelIn.var(1).cen(1)=1;else ModelIn.var(1).cen(1)=0;end;'');',...
        'backgroundcolor',FRC,...
        'position',[200 180 130 20],...
        'tooltipstring','substract the mean of each row',...  
        'style','checkbox');
    h1=uicontrol('parent', h0,...    %row-scaling
        'tag','rs',...
        'string','Row-Scaled',...
        'fontsize',12,...
        'callback','evalin(''caller'',''if get(gcbo,''''value'''')==1,ModelIn.sam(1).scal(1)=1;else ModelIn.sam(1).scal(1)=0;end;'');',...
        'backgroundcolor',FRC,...
        'position',[200 160 130 20],...
        'tooltipstring','divide by the norm of each row',...  
        'style','checkbox');
    if ModelIn.var(1).scal(1)==1,
        set(findobj('tag','cs'),'value',1);
    else
        set(findobj('tag','cs'),'value',0);
    end;
    if ModelIn.sam(1).cen(1)==1,
        set(findobj('tag','cc'),'value',1);
    else
        set(findobj('tag','cc'),'value',0);
    end;
    if ModelIn.sam(1).scal(1)==1,
        set(findobj('tag','rs'),'value',1);
    else
        set(findobj('tag','rs'),'value',0);
    end;
    if ModelIn.var(1).cen(1)==1,
        set(findobj('tag','rc'),'value',1);
    else
        set(findobj('tag','rc'),'value',0);
    end;   
    
else,   %execution PCA
    if strcmp(get(gcbo,'type'),'uimenu'), %verification de doublon
        return;
    end;
    [ModelOut] = DefineModelOut;
    
    mainfig=findobj('userdata','Cubatch');
    [X]=getcvdata(mainfig,'X'); 
    modenames=X{1}.modenames;
    if ndims(X{1})>2,   %  N-way data
        X{1}=unfoldcbdataset(X{1});
    end;
    X=X{1}.data;  
    f=ModelIn.nbfactors.min;
    N=2;
    R=size(X);
    if f>min(R),
        uiwait(errordlg({'Error. The number of components',['has to be inferior to ' int2str(min(R)),'.']}));
        return;
    end;
    options.tol=ModelIn.options.algorithm.value;
    options.maxit=ModelIn.options.algorithm.maxiter;
    algo=ModelIn.options.algorithm.name;    
    if sum([ModelIn.sam(1).cen(1),ModelIn.var.cen,ModelIn.sam(1).scal(1),ModelIn.var.scal])>0,
        try
            [X,ModelOut.model(1).xpreproc.cen,ModelOut.model(1).xpreproc.scal]=nprocess(X,[ModelIn.sam(1).cen(1),ModelIn.var.cen],[ModelIn.sam(1).scal(1),ModelIn.var.scal]);
        catch
            uiwait(errordlg({'Error in the preprocessing part.',lasterr}));
        end;
    end;
    
    if get(findobj('tag','validate'),'value')==1,
        switch ModelIn.valmethod.name
            case 'nboo',     %validation bootstrap naif
                ModelIn.options.species='val';
                ModelOut.validation.stats.risk=bootcompacp(X,ModelIn,getappdata(mainfig,'Results'),getappdata(mainfig,'Content'),'n');
            case 'rboo', %validation bootstrap residuel
                ModelIn.options.species='val';
                ModelOut.validation.stats.risk=bootcompacp(X,ModelIn,getappdata(mainfig,'Results'),getappdata(mainfig,'Content'),'r');
            case 'cv', % cross validation 
                ModelIn.options.species='val';
                sscroval=acpcroval(X,f,algo,options);
        end;    
    else, %execute PCA
            ModelIn.options.species='met';
            [U,S,V,vexp,Xm,it]=Acpf(X,f,algo,options);
            if isnan(sum(X(:))),
                ModelIn.options.algorithm.name='Nipals';
            end;      
            
            %calcul residus
            E=X-Xm;
            
            % calcul des coefficients de qualits
            [qual,expv,hotel]=qualitecube(X,Xm,{U*S,V*S});
            ModelOut.model.stats.quality=qual;
            ModelOut.model.stats.expvar=expv;
            ModelOut.model.stats.hotelling=hotel;
            
            if ModelIn.valmethod.bootstrap>0,  %bootstrap
                set(findobj('tag','plotd3'),'enable','off');
                nbboot=ModelIn.valmethod.replicates;
                A=U*S;
                B=V;
                W=B*B';
                if ModelIn.valmethod.bootstrap==1,   % naive bootstrap
                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    % Bootstrap avec Reechantillonnage sur les lignes des Donnes  %
                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    [Abootstrap, bootsam]=bootstrpanadon(nbboot,3,'naifacp',X,f);
                elseif ModelIn.valmethod.bootstrap==2,  % residual bootstrap
                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    % Bootstrap avec Reechantillonnage sur les lignes des Residus  %
                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    E=X-A*B';
                    [Abootstrap, bootsam]=bootstrpanadon(nbboot,3,'residuelacp',E,A,B);
                end;
                
                
                %changement ventuel du signe des PC bootstraps
                for i=1:nbboot,
                    Ab=reshape(Abootstrap{1}(i,:),R(1),f);
                    Bb=reshape(Abootstrap{2}(i,:),R(2),f);
                    signprodscalA=diag(sign(diag(Ab'*A)));
                    signprodscalB=diag(sign(diag(Bb'*B)));
                    Ab=Ab*signprodscalA;
                    Bb=Bb*signprodscalB;
                    Abootstrap{1}(i,:)=Ab(:)';
                    Abootstrap{2}(i,:)=Bb(:)';
                end;
                
                %  Calculus of the standard deviation (for the modes 2 to N).
                for n=1:N,
                    for nb=1:nbboot,
                        mat{n}(nb,:,:)=reshape(Abootstrap{n}(nb,:),R(n),f);
                    end;
                    stad{n}=squeeze(std(mat{n}));
                end;
                if isequal(ModelIn.valmethod.bootstrap,1),
                    m(1:10*max(R)*nb)=0;
                    for n=1:nb,
                        u=bootsam(:,n);
                        for i=1:R(1),
                            m(u(i))=m(u(i))+1;
                            AAA{u(i)}(:,m(u(i)))=mat{1}(n,i,:);
                        end;
                    end;
                    for i=1:R(1),
                        if ~isequal(size(AAA{i}),[0 0]),
                            stad{1}(i,:)=std(AAA{i}');
                        end;
                    end;
                end;
                
                %  Calcul du risque
                somtrace=0;
                for b=1:nbboot,
                    Bb=reshape(Abootstrap{2}(b,:),R(2),f);
                    Wb=Bb*Bb';
                    traceb=trace(Wb*W);
                    somtrace=somtrace+traceb;
                end;
                risqueB=f-(1/nbboot)*somtrace; 
                
                
                % translation
                for nb=1:nbboot,
                    for i=1:2,
                        ModelOut.validation.xfactors{i}(:,:,nb)=reshape(Abootstrap{i}(nb,:),[R(i),f]);
                    end;
                    ModelOut.validation.core(:,:,nb)=diag(Abootstrap{3}(nb,:));
                end;
                
                
                %other outputs
                ModelOut.validation.segments=bootsam;
                ModelOut.validation.stats.std=stad;
                ModelOut.validation.stats.risk=risqueB;
            end;  %end bootstrap
            
                        
            % ModelOut implementation
            ModelOut.model.xfactors=cell(1,2);
            ModelOut.model.xfactors{1}=U;
            ModelOut.model.xfactors{2}=V;
            ModelOut.model.xpred=Xm;
            ModelOut.model.core=S;
            ModelOut.model.iterations=it;
            ModelOut.model.xev=vexp;
            ModelOut.modelname='PCA';
            
            %       ModelOut.model(1).xpreproc.cen= mcent;
            %       ModelOut.model(1).xpreproc.scal=mscal;
            
            % default plot installation
            defaultplot(ModelIn,ModelOut);
            %delete
            delete(findobj('userdata','window'));
    end;%PCA model (opposite to validation)
    ModelOut.modelname='PCA';
    acpdisplayInfo(mainfig,ModelIn,ModelOut);
end;%pca execution




