function [conc]=unimod(conc,rmod,cmod)
% 
% This m-file appplies unimodality constraint for MCR-ALS
%
% The MATLAB program unimod               
% was written by:
% 
% Roma Tauler and Anna de Juan, 1999 
% Chemometrics and Solution Equilibria group    
% University of Barcelona                       
% Department of Analytical Chemistry            
% Diagonal 647, Barcelona 08028                 
% e-mail roma@quimio.qui.ub.es                 
%
% It is freely available on the internet 
%
% This m-file was slightly modified by Sbastien Gourvnec to fit to the software
% designed in the frame of the NWAYQUAL Project
% Date: 2002


[ns,nc]=size(conc);
nmdf=0;

% 1) look for the maximum

for j=1:nc,
    [y,imax(j)]=max(conc(:,j));
end

% 2) force unimodality shape

for j=1:nc,
    
    rmax=conc(imax(j),j);
    k=imax(j);
    
    % 2a) discard left maxima (tolerance rmod)
    
    while k>1,
        k=k-1;
        
        if conc(k,j)<=rmax,
            rmax=conc(k,j);
        else,
            rmax2=rmax*rmod;
            if conc(k,j)>rmax2,
                
                if cmod==0,conc(k,j)=1.0E-30;end
                if cmod==1,conc(k,j)=conc(k+1,j);end
                if cmod==2,
                    if rmax>0,      
                        conc(k,j)=(conc(k,j)+conc(k+1,j))/2;
                        conc(k+1,j)=conc(k,j);
                        k=k+2;
                    else
                        conc(k,j)=0;
                    end
                end
                
                rmax=conc(k,j);
                nmdf=nmdf+1;
                
            end
            
        end
        
    end
    
    % 2b) discard right maxima (tolerance rmod)
    
    rmax=conc(imax(j),j);
    k=imax(j);
    
    while k<ns-1,
        k=k+1;
        
        if conc(k,j)<=rmax,
            rmax=conc(k,j);
        else,
            rmax2=rmax*rmod;
            if conc(k,j)>rmax2,
                if cmod==0,conc(k,j)=1.0E-30;end
                if cmod==1,conc(k,j)=conc(k-1,j);end
                if cmod==2,
                    if rmax>0,
                        conc(k,j)=(conc(k,j)+conc(k-1,j))/2;
                        conc(k-1,j)=conc(k,j);
                        k=k-2;
                    else
                        conc(k,j)=0;
                    end
                end
                nmdf=nmdf+1;
                rmax=conc(k,j);
            end
        end
        
    end
    
end