function [ModelIn,ModelOut]=initialopa3(ModelIn, ModelOut);
%
% This function allows the user to load initial inputs for OPA3D
%
% Author:   Sbastien GOURVENEC
%           FABI - VUB
%           email: sgourven@vub.ac.be
% Date: 2002

global ModelIn ModelOut

cd data
[Xfil{2:-1:1}] = uigetfile('*.mat','ResultsOPA'); 
cd ..

FileContent = who('-file',[Xfil{:}]);
SessionContent = {'Content','ModelIn','ModelOut','X'};
Vars = intersect(FileContent,SessionContent);
if isempty(Vars)
    if length(FileContent) >1
        [Sel,OK]=listdlg('liststring',FileContent);
        if OK==1
            a=load([Xfil{:}],FileContent{Sel});
            ModelIn.data.initialinput=eval(['a.',FileContent{Sel}]);
        else
            warndlg('Please, load a matrix for initial inputs')
        end
    else
        a=load([Xfil{:}]);
        ModelIn.data.initialinput=eval(['a.',FileContent{:}]);
    end
else
Vars = load([Xfil{:}],Vars{:});
ModelIn.data.initialinput=Vars.ModelOut.model.xfactors{2}
end
Guinames;
Han.initialinputs = uicontrol(gcf,ty,ed,pos,[105 175 130  30],bg,[1 1 1],ari{:},tg,'Initial Inputs',st,'loaded');