function [conc]=closure(conc,iclos,sclos1,iclos1,tclos1,tclos2,sclos2,iclos2,vclos1,vclos2)
% function [conc]=closure(conc,iclos,sclos1,iclos1,tclos1,tclos2,sclos2,iclos2,vclos1,vclos2)
% 
% This m-file appplies closure constraint for MCR-ALS
%
% closure is applied for a single experiment 
% vclos is a vectorial closure of the same size than conc
% closure types
% The MATLAB program closure               
% was written by:
% 
% Roma Tauler and Anna de Juan, 1999 
% Chemometrics and Solution Equilibria group    
% University of Barcelona                       
% Department of Analytical Chemistry            
% Diagonal 647, Barcelona 08028                 
% e-mail roma@quimio.qui.ub.es                 
%
% It is freely available on the internet 
%
% This m-file was slightly modified by Sbastien Gourvnec to fit to the software
% designed in the frame of the NWAYQUAL Project
% Date: 2002

[kfin,nspec]=size(conc);

% calculation of the total sums
summ1=zeros(size(conc,1),1);
summ2=zeros(size(conc,1),1);

for ns=1:nspec,
   if iclos ==1 | iclos==2,
      if sclos1(ns) == 1,
         summ1=summ1+conc(:,ns);
      end
   end
   if iclos==2,
      if sclos2(ns) == 1,
         summ2=summ2+conc(:,ns);
      end
   end
end
% check summ1 and summ2 not to be zero
izero=find(summ1==0);
summ1(izero)=ones(size(izero));
if iclos==2,
   izero=find(summ2==0);
   summ2(izero)=ones(size(izero));
end
maxsum1=max(summ1);
maxsum2=max(summ2);

% aplication of the different closure types

for ns=1:nspec,

% first closure condition

if iclos ==1 
   if iclos1 ==1 & sclos1(ns) == 1 & sclos2(ns) == 0    
      if isempty(vclos1)| vclos1==0
         conc(:,ns)=((conc(:,ns)*tclos1)./summ1);
      else
         conc(:,ns)=((conc(:,ns).*vclos1)./summ1);
      end
   end
   if iclos1 == 2 & sclos1(ns) ==1 & sclos2(ns) == 0
      conc(:,ns)=((conc(:,ns)*tclos1)./maxsum1);
   end  
end

% second closure condition

if iclos == 2
   if sclos1(ns)==1 & sclos2(ns)==1
      error ('One species is included in the two closures')
   end
   if iclos1 ==1 & sclos1(ns) == 0 & sclos2(ns) == 1    
      if isempty(vclos2)| vclos2==0
         conc(:,ns)=((conc(:,ns)*tclos2)./summ2);
      else
         conc(:,ns)=((conc(:,ns).*vclos2)./summ2);
      end
   end
   if iclos1 == 2 & sclos1(ns) ==0 & sclos2(ns) == 1
      conc(:,ns)=((conc(:,ns)*tclos2)./maxsum2);
   end  
end

end