function [ModelIn,ModelOut,PlotStr]= OPA3check(ModelIn,ModelOut,PlotStr);
%
% This function checks some parameters before using OPA3D method
%
% Author:   Sbastien GOURVENEC
%           FABI - VUB
%           email: sgourven@vub.ac.be
% Date: 2002

mainfig=findobj('userdata','Cubatch');

% sweep other windows
delete(findobj('userdata','window'));

% verification of ModelIn
%Default Value
ModelIn.options.algorithm.name = 'OPA 3D';
ModelIn.options.batchesnumbers = [];
%ModelIn.data.initialinput = [];
ModelIn.options.columnwise = 1;
ModelIn.options.rowwise = 0;

%%%% Preliminary calculations and assignations.
[nexp,inutile]=size(ModelIn.file.matrices);
ModelIn.options.nexp = nexp-1;

seb2=[];
for i=1:nexp-1
    seb=[ModelIn.file.matrices(i)];
    seb2=[seb2,seb];
end
machin2=[];truc=[];
for i=1:nexp-1
    machin=['s',num2str(i)];
    [machin]=deal(seb2{i});
    truc=[truc,' ',machin];
    ModelIn.data.var=truc;
end

[A]=deal(ModelIn.file.matrices{nexp});

ModelIn.data.sam=A;

truc2=ModelIn.file.size(nexp);
[truc3,inutile]=size(ModelOut.data.dataset);

ModelIn.data.var=truc;

% Check of PlotStr
spl=getappdata(mainfig,'PlotStr');
if ischar(spl.type) %checks the plot type
    switch spl.type    
        case {'xmo','exv','res','mod'},
        otherwise
            spl.type='mod';
    end;
else
    spl.type='mod'; 
end;
setappdata(mainfig,'PlotStr',spl);

%%%% To be able to make a PCA after this 
X = ModelIn.data.augmentedmatrix;
