function OPA3Report(MainFig,ReportStruct,Fil_id)
%
% This function allows to make a report for an OPA3D model
%
% Author:   Sbastien GOURVENEC
%           FABI - VUB
%           email: sgourven@vub.ac.be
% Date: 2002


ModelOut = getcvdata(MainFig,'Results');
ModelIn  = getcvdata(MainFig,'Model');

if any(ReportStruct.m_info)
    
    %Model info and name
    fwrite(Fil_id,['Model Information'                   10],'char');
    fwrite(Fil_id,['-----------------' 10],'char');
    
    fwrite(Fil_id,[10 'Model               : OPA3D' 10],'char');
    fwrite(Fil_id,['Number of factors   : '],                    'char');
    fwrite(Fil_id,[sprintf(' %i',[size(ModelOut.model.xfactors{1},2)]),10 10],'char');
    %Preprocessing. NB the different scalings are not distinguished
    fwrite(Fil_id,[   'Preprocessing'                 10],'char');
    fwrite(Fil_id,[   'Centering           : '   ],        'char');
    a = isempty(ModelOut.model.xpreproc.cen);
    fwrite(Fil_id,[int2str(~a(:)') 10],'char');
    fwrite(Fil_id,[   'Scaling             : '   ],        'char');
    a = isempty(ModelOut.model.xpreproc.scal);
    fwrite(Fil_id,[int2str(~a(:)') 10 10],'char');
    
    fwrite(Fil_id,['Initial inputs      :'                  ],'char');
    fwrite(Fil_id,[sprintf(' %i',[size(ModelIn.data.initialinput,1)])],'char');
    fwrite(Fil_id,[' x'],'char'); 
    fwrite(Fil_id,[sprintf(' %i',[size(ModelIn.data.initialinput,2)]) 10],'char');
    
    fwrite(Fil_id,['Explained variance  : '],'char');
    fwrite(Fil_id,[sprintf('%3.2f%%',[100*ModelOut.info.r2opt]),10],  'char');
    
    
    %Algorithm information
    
    fwrite(Fil_id,[10,'Algorithm               :  OPA3D-ALS' 10],'char');
    fwrite(Fil_id,['Iterations              : '],                             'char');
    fwrite(Fil_id,[sprintf(' %i',[ModelIn.options.algorithm.maxiter]) 10],'char');
    fwrite(Fil_id,['Convergence criterion   : '],              'char'); 
    fwrite(Fil_id,[sprintf(' %i',[ModelIn.options.algorithm.convcrit]) 10, 10],'char');
    
    %Constraints
    
    fwrite(Fil_id,['Constraints'                   10, 10],'char');
    
    for i=1:length(ModelIn.constraints)
        if ModelIn.constraints(i).value==0
            b='not used here';
        else
            b='used here';
        end
        fwrite(Fil_id,[[[ModelIn.constraints(i).name],'    : ']],'char');
        fwrite(Fil_id,[b 10],'char');
        fwrite(Fil_id,['algorithm   : '],              'char'); 
        fwrite(Fil_id,[[ModelIn.constraints(i).algorithm], 10],'char');
        fwrite(Fil_id,['modes       : '],              'char');
        fwrite(Fil_id,[[ModelIn.constraints(i).modes], 10],'char');
        fwrite(Fil_id,['constants   : '],              'char'); 
        fwrite(Fil_id,[,[ModelIn.constraints(i).constants], 10],'char');
        fwrite(Fil_id,['core        : '],              'char'); 
        fwrite(Fil_id,[[ModelIn.constraints(i).core], 10],'char');
        fwrite(Fil_id,['factors     : '],              'char'); 
        fwrite(Fil_id,[[ModelIn.constraints(i).factors], 10, 10],'char');
    end
    
    
    
    %Model
    fwrite(Fil_id,['Loadings'                   10, 10],'char');            
    %        
    fwrite(Fil_id,['Loadings Mode 1 :'                          10],'char');
    Mat = num2str(ModelOut.model.xfactors{1}(1:10,:));
    Mat = [Mat,10 * ones(size(Mat,1),1)]';
    fwrite(Fil_id,Mat,'char');
    fwrite(Fil_id,[10 10],'char');
    %         
    fwrite(Fil_id,['Loadings Mode 2 :'                          10],'char');
    Mat = num2str(ModelOut.model.xfactors{2}(:,1:10));   
    Mat = [Mat,10 * ones(size(Mat,1),1)]';
    fwrite(Fil_id,Mat,'char');
    fwrite(Fil_id,[10 10],'char');
end
