function [ModelOut,ModelIn] = opa3d3(ModelIn,ModelOut)
%
% This function allows to make an OPA3D model and corresponds to the 3rd
% window
%
% Author:   Sbastien GOURVENEC
%           FABI - VUB
%           email: sgourven@vub.ac.be
% Date: 2002

global ModelIn ModelOut

warning off

GuiNames

bgc=[0.7529 0.7529 0.7529]; % gris

ScSize = get(0,'screensize');
VPos   = fix((ScSize(3)-435)/2);
HPos   = fix((ScSize(4)-700)/2);
Pos    = [VPos HPos 435 700];
h = cenwindow(WIC,'MCR-ALS - Third Window - Constraints',[],435,700);

set(gca,off{:})
Tools = uimenu(la,'&Tools');
Opt   = uimenu(la,'&Preferences');
Help  = uimenu(la,'&Help');
uimenu(Help, la,'&About MCR-ALS',cb,'AboutMCRALS')
uimenu(Help, la,'&Help',tg,'Help')
   
   
uicontrol(ty,fr,pos,[10 45 412 650],bg,WIC,ari{:});

% UNIMODALITY - ModelIn.constraints(6)
%------------------------------------------------------------------------------------------------
% DEFAULT VALUES
%
ModelIn.constraints(6).value = 0;
ModelIn.constraints(6).modes = [0 0 0];
ModelIn.constraints(6).algorithm = [0 0 0];
ModelIn.constraints(6).constants = 0;

Han.unimod = uicontrol(ty,ch,pos,[15 670 150 20],bg,WIC,st,'UNIMODALITY',ari{:},bd{:},cb,'ModelIn.constraints(6).value = get(gcbo,''value'');if get(gcbo,''value'')==1,set([findobj(''tag'',''Unimodality Concentrations''),findobj(''tag'',''Unimodality Conc and spectra''),findobj(''tag'',''Unimodality Spectra''),findobj(''tag'',''Vertical Unimodality''),findobj(''tag'',''Horizontal Unimodality''),findobj(''tag'',''Average Unimodality''),findobj(''tag'',''Unimodality tolerance''),findobj(''tag'',''EditValue'')],''enable'',''on'');else set([findobj(''tag'',''Unimodality Concentrations''),findobj(''tag'',''Unimodality Conc and spectra''),findobj(''tag'',''Unimodality Spectra''),findobj(''tag'',''Vertical Unimodality''),findobj(''tag'',''Horizontal Unimodality''),findobj(''tag'',''Average Unimodality''),findobj(''tag'',''Unimodality tolerance''),findobj(''tag'',''EditValue'')],''enable'',''off'');end',tg,'Unimodality');
Han.unimod.conc = uicontrol(ty,ch,pos,    [30 645 120 15],bg,WIC,'enable','off',st,'Concentrations',ari{:},cb, 'ModelIn.constraints(6).modes(1) = get(gcbo,''value''); ModelIn.constraints(6).modes(2) = 0; ModelIn.constraints(6).modes(3) = 0;',tg,'Unimodality Concentrations');
Han.unimod.concspec = uicontrol(ty,ch,pos,[150 645 187 15],bg,WIC,'enable','off',st,'Concentrations & Spectra',ari{:},cb, 'ModelIn.constraints(6).modes(3) = get(gcbo,''value'');ModelIn.constraints(6).modes(2) = 0;ModelIn.constraints(6).modes(1) = 0;' ,tg,'Unimodality Conc and spectra');
Han.unimod.spec = uicontrol(ty,ch,pos,    [344 645 75 15],bg,WIC,'enable','off',st,'Spectra',ari{:},cb, 'ModelIn.constraints(6).modes(2) = get(gcbo,''value'');ModelIn.constraints(6).modes(1) = 0;ModelIn.constraints(6).modes(3) = 0;',tg,'Unimodality Spectra');
Han.unimod.vert = uicontrol(ty,ch,pos,[30 615 120 20],bg,WIC,'enable','off',st,'Vertical',ari{:},cb,  'ModelIn.constraints(6).algorithm(1) = get(gcbo,''value'');ModelIn.constraints(6).algorithm(2) = 0;ModelIn.constraints(6).algorithm(3) = 0;',tg,'Vertical Unimodality');
Han.unimod.horiz = uicontrol(ty,ch,pos,[150 615 175 20],bg,WIC,'enable','off',st,'Horizontal',ari{:},cb,'ModelIn.constraints(6).algorithm(2) = get(gcbo,''value'');ModelIn.constraints(6).algorithm(1) = 0;ModelIn.constraints(6).algorithm(3) = 0;',tg,'Horizontal Unimodality');
Han.unimod.aver = uicontrol(ty,ch,pos,[344 615 75 20],bg,WIC,'enable','off',st,'Average',ari{:},cb,'ModelIn.constraints(6).algorithm(3) = get(gcbo,''value'');ModelIn.constraints(6).algorithm(1) = 0;ModelIn.constraints(6).algorithm(2) = 0;',tg,'Average Unimodality');
uicontrol(ty,tx,pos,[92 585 110 20],bg,WIC,'enable','off',st','Tolerance limit',ari{:},tg,'Unimodality tolerance');
Han.tol = uicontrol(ty,ed,pos,[29 585 65 20],bg,wh,'enable','off',cb,'ModelIn.constraints(6).constants = sscanf(get(gcbo,''string''),''%g'');',tg,'EditValue');
%------------------------------------------------------------------------------------------------

% CLOSURE - ModelIn.constraints(1)
%------------------------------------------------------------------------------------------------
% DEFAULT VALUES
%
ModelIn.constraints(1).value = 0;
ModelIn.constraints(1).modes = [0 0 0];
ModelIn.constraints(1).constants = 0;

uicontrol(ty,ch,pos,[15 540 110 20],bg,WIC,st,'CLOSURE',ari{:},bd{:},cb,'ModelIn.constraints(1).value = get(gcbo,''value'');if get(gcbo,''value'')==1,set([findobj(''tag'',''Closure Concentrations''),findobj(''tag'',''Closure Spectra''),findobj(''tag'',''Closure Constant''),findobj(''tag'',''EditValue2'')],''enable'',''on'');else set([findobj(''tag'',''Closure Concentrations''),findobj(''tag'',''Closure Spectra''),findobj(''tag'',''Closure Constant''),findobj(''tag'',''EditValue2'')],''enable'',''off'');end',tg,'Closure');
uicontrol(ty,ch,pos,[30 510 120 20],bg,WIC,'enable','off',st,'Concentrations',ari{:},cb,' ModelIn.constraints(1).modes(1) = get(gcbo,''value'');ModelIn.constraints(1).modes(2) = 0;',tg,'Closure Concentrations');
uicontrol(ty,ch,pos,[170 510 120 20],bg,WIC,'enable','off',st,'Spectra',ari{:},cb,  'ModelIn.constraints(1).modes(2) = get(gcbo,''value'');ModelIn.constraints(1).modes(1) = 0;',tg,'Closure Spectra');
uicontrol(ty,tx,pos,[96 480 120 20],bg,WIC,'enable','off',st','Closure constant',ari{:},tg,'Closure Constant');
Han.clo = uicontrol(ty,ed,pos,[29 480 65 20],bg,wh,'enable','off',cb,'ModelIn.constraints(1).constants = sscanf(get(gcbo,''string''),''%g'');',tg,'EditValue2');
%------------------------------------------------------------------------------------------------

% NON NEGATIVITY - ModelIn.constraints(3)
%------------------------------------------------------------------------------------------------
% DEFAULT VALUES
%
ModelIn.constraints(3).value = 0;
ModelIn.constraints(3).modes = [0 0 0];
ModelIn.constraints(3).algorithm = [0 0 0];
ModelIn.constraints(3).constants = 0;

uicontrol(ty,ch,pos,[15 435 200 20],bg,WIC,st,'NON-NEGATIVITY',ari{:},bd{:},cb,'ModelIn.constraints(3).value = get(gcbo,''value'');if get(gcbo,''value'')==1,set([findobj(''tag'',''non_negativity concentrations''),findobj(''tag'',''non_negativity conc and spec''),findobj(''tag'',''non_negativity spectra''),findobj(''tag'',''non_negativity forced to zero''),findobj(''tag'',''non_negativity Nnls''),findobj(''tag'',''non_negativity Fnnls'')],''enable'',''on'');else set([findobj(''tag'',''non_negativity concentrations''),findobj(''tag'',''non_negativity conc and spec''),findobj(''tag'',''non_negativity spectra''),findobj(''tag'',''non_negativity forced to zero''),findobj(''tag'',''non_negativity Nnls''),findobj(''tag'',''non_negativity Fnnls'')],''enable'',''off'');end',tg,'Non_negativity');
uicontrol(ty,ch,pos,[30 405 120 20],bg,WIC,'enable','off',st,'Concentrations',ari{:},cb,'ModelIn.constraints(3).modes(1) = get (gcbo,''value'');ModelIn.constraints(3).modes(3) = 0;ModelIn.constraints(3).modes(2) = 0;',tg,'non_negativity concentrations');
uicontrol(ty,ch,pos,[150 405 187 20],bg,WIC,'enable','off',st,'Concentrations & Spectra',ari{:},cb,'ModelIn.constraints(3).modes(3) = get (gcbo,''value'');ModelIn.constraints(3).modes(1) = 0;ModelIn.constraints(3).modes(2) = 0;',tg,'non_negativity conc and spec');
uicontrol(ty,ch,pos,[344 405 75 20],bg,WIC,'enable','off',st,'Spectra',ari{:},cb,'ModelIn.constraints(3).modes(2) = get (cbo,''value'');ModelIn.constraints(3).modes(1) = 0;ModelIn.constraints(3).modes(3) = 0;',tg,'non_negativity spectra');
uicontrol(ty,ch,pos,[30 375 120 20],bg,WIC,'enable','off',st,'Forced to zero',ari{:},cb,'ModelIn.constraints(3).algorithm(1) = get (gcbo,''value'');ModelIn.constraints(3).algorithm(2) = 0;ModelIn.constraints(3).algorithm(3) = 0;',tg,'non_negativity forced to zero');
uicontrol(ty,ch,pos,[150 375 120 20],bg,WIC,'enable','off',st,'Nnls',ari{:},cb,'ModelIn.constraints(3).algorithm(2) = get (gcbo,''value'');ModelIn.constraints(3).algorithm(1) = 0;ModelIn.constraints(3).algorithm(3) = 0;',tg,'non_negativity Nnls');
uicontrol(ty,ch,pos,[344 375 75 20],bg,WIC,'enable','off',st,'Fnnls',ari{:},cb,'ModelIn.constraints(3).algorithm(3) = get (gcbo,''value'');ModelIn.constraints(3).algorithm(1) = 0;ModelIn.constraints(3).algorithm(2) = 0;',tg,'non_negativity Fnnls');
%------------------------------------------------------------------------------------------------

% EQUALITY - ModelIn.constraints(2)
%------------------------------------------------------------------------------------------------
% DEFAULT VALUES
%
ModelIn.constraints(2).value = 0;
ModelIn.constraints(2).modes = [0 0 0];
ModelIn.constraints(2).constants = [0 0];

Han.csel = uicontrol(ty,ch,pos,[15 330 400 20],bg,WIC,st,'EQUALITY CONSTRAINT IN CONC. PROFILES',ari{:},bd{:},cb,'ModelIn.constraints(2).value = get (gcbo,''value'');if get(gcbo,''value'')==1,set([findobj(''tag'',''Csel''),findobj(''tag'',''Edit Value3'')],''enable'',''on'');else set([findobj(''tag'',''Csel''),findobj(''tag'',''Edit Value3'')],''enable'',''off'');end;ModelIn.constraints(2).modes(1) = ModelIn.constraints(2).value;',tg,'Eq_Constraints_con_profiles');
uicontrol(ty,tx,pos,[92 305 90 20],bg,WIC,'enable','off',st','Csel',ari{:},tg,'Csel');
Han.csel.value = uicontrol(ty,ed,pos,[29 305 65 20],bg,wh,'enable','off',cb,'ModelIn.constraints(2).constants(1) = sscanf(get(gcbo,''string''),''%g'');',tg,'Edit Value3');

Han.ssel = uicontrol(ty,ch,pos,[15 250 400 20],bg,WIC,st,'EQUALITY CONSTRAINT IN SPEC. PROFILES',ari{:},bd{:},cb,'ModelIn.constraints(2).value = get(gcbo,''value'');if get(gcbo,''value'')==1,set([findobj(''tag'',''Ssel''),findobj(''tag'',''Edit Value4'')],''enable'',''on'');else set([findobj(''tag'',''Ssel''),findobj(''tag'',''Edit Value4'')],''enable'',''off'');end;ModelIn.constraints(2).modes(2) = ModelIn.constraints(2).value;',tg,'Eq_Constraints_spec_profiles');
uicontrol(ty,tx,pos,[92 225 90 20],bg,WIC,'enable','off',st','Ssel',ari{:},tg,'Ssel');
Han.ssel.value = uicontrol(ty,ed,pos,[29 225 65 20],bg,wh,'enable','off',cb,'ModelIn.constraints(2).constants(2) = sscanf(get(gcbo,''string''),''%g'');',tg,'Edit Value4');
%------------------------------------------------------------------------------------------------

% THREEWAY - ModelIn.constraints(5)
%------------------------------------------------------------------------------------------------
% DEFAULT VALUES
%
ModelIn.constraints(5).value = 1;
ModelIn.constraints(5).modes = [0 0 0];
ModelIn.constraints(5).algorithm(1) = 0;ModelIn.constraints(5).algorithm(2) = 0;ModelIn.constraints(5).algorithm(3) = 0;ModelIn.constraints(5).algorithm(4) = 0;

uicontrol(ty,ch,pos,[15 175 400 20],bg,WIC,st,'3-WAY DATA STRUCTURE CONSTRAINTS',ari{:},bd{:},tg,'threeway',va,1);
uicontrol(ty,ch,pos,[30 150 380 20],bg,WIC,st,'No trilinear',ari{:},cb,'ModelIn.constraints(5).algorithm(1) = get(gcbo,''value'');if get(gcbo,''value'')==0,set([findobj(''tag'',''trilinear_shape_synchronization_allspecies''),findobj(''tag'',''trilinear_shape__allspecies''),findobj(''tag'',''trilinear_synchronization_some species'')],''enable'',''on'');else set([findobj(''tag'',''trilinear_shape_synchronization_allspecies''),findobj(''tag'',''trilinear_shape__allspecies''),findobj(''tag'',''trilinear_synchronization_some species'')],''enable'',''off'');end',tg,'No_Trilinear',va,1);
uicontrol(ty,ch,pos,[30 125 380 20],bg,WIC,'enable','off',st,'Trilinear, equal shape and synchronization (all species)',ari{:},cb,'ModelIn.constraints(5).algorithm(2) = get(gcbo,''value'');if get(gcbo,''value'')==1,set([findobj(''tag'',''No_Trilinear''),findobj(''tag'',''trilinear_shape__allspecies''),findobj(''tag'',''trilinear_synchronization_some species'')],''enable'',''off'');else set([findobj(''tag'',''No_Trilinear''),findobj(''tag'',''trilinear_shape__allspecies''),findobj(''tag'',''trilinear_synchronization_some species'')],''enable'',''on'');end',tg,'trilinear_shape_synchronization_allspecies');
uicontrol(ty,ch,pos,[30 100 350 20],bg,WIC,'enable','off',st,'Trilinear without synchronization (all species)',ari{:},cb,'ModelIn.constraints(5).algorithm(3) = get(gcbo,''value'');if get(gcbo,''value'')==1,set([findobj(''tag'',''No_Trilinear''),findobj(''tag'',''trilinear_shape_synchronization_allspecies''),findobj(''tag'',''trilinear_synchronization_some species'')],''enable'',''off'');else set([findobj(''tag'',''No_Trilinear''),findobj(''tag'',''trilinear_shape_synchronization_allspecies''),findobj(''tag'',''trilinear_synchronization_some species'')],''enable'',''on'');end',tg,'trilinear_shape__allspecies');
uicontrol(ty,ch,pos,[30 75 350 20],bg,WIC,'enable','off',st,'Trilinear and synchronization for only some species',ari{:},cb,'ModelIn.constraints(5).algorithm(4) = get(gcbo,''value'');if get(gcbo,''value'')==1,set([findobj(''tag'',''No_Trilinear''),findobj(''tag'',''trilinear_shape_synchronization_allspecies''),findobj(''tag'',''trilinear_shape__allspecies'')],''enable'',''off'');else set([findobj(''tag'',''No_Trilinear''),findobj(''tag'',''trilinear_shape_synchronization_allspecies''),findobj(''tag'',''trilinear_shape__allspecies'')],''enable'',''on'');end',tg,'trilinear_synchronization_some species');
uicontrol(ty,ch,pos,[30 50 120 20],bg,WIC,'enable','off',st,'Const. in C',ari{:},cb,'ModelIn.constraints(5).modes(1) = get(gcbo,''value'');ModelIn.constraints(5).modes(2) = 0;ModelIn.constraints(5).modes(3) = 0;',tg,'const_in_C');
uicontrol(ty,ch,pos,[150 50 120 20],bg,WIC,'enable','off',st,'Const. in S',ari{:},cb,'ModelIn.constraints(5).modes(2) = get(gcbo,''value'');ModelIn.constraints(5).modes(1) = 0;ModelIn.constraints(5).modes(3) = 0;',tg,'const_in_S');
uicontrol(ty,ch,pos,[270 50 150 20],bg,WIC,'enable','off',st,'Const. in C & S',ari{:},cb, 'ModelIn.constraints(5).modes(3) = get(gcbo,''value'');ModelIn.constraints(5).modes(2) = 0;ModelIn.constraints(5).modes(1) = 0;',tg,'const_in_C_S');
%------------------------------------------------------------------------------------------------

uicontrol(ty,ps,pos,[295 10 130  30],st,'Close',tg,'Close',  bg,bgc,ari{:},en{:},cb,'close(gcf)');
uicontrol(ty,ps,pos,[10  10 130  30],st,'Continue',tg,'StartBut',bg,bgc,ari{:},cb, 'clc;close(gcf);global ModelOut ModelIn;[ModelOut,ModelIn]=opa3d(ModelIn,ModelOut);');





           
  
   
