function [ModelOut,ModelIn] = opa3d2(ModelIn,ModelOut)
%
% This function allows to make an OPA3D model and corresponds to the 2nd
% window
%
% Author:   Sbastien GOURVENEC
%           FABI - VUB
%           email: sgourven@vub.ac.be
% Date: 2002

global ModelIn ModelOut

warning off

GuiNames

%Default Value
ModelIn.options.algorithm.maxiter = 50;
ModelIn.options.algorithm.convcrit = 0.01;
ModelIn.options.constraints = 0;
ModelIn.constraints(6).value = 0;
ModelIn.constraints(6).modes = [0 0 0];
ModelIn.constraints(6).algorithm = [0 0 0];
ModelIn.constraints(6).constants = 0;
ModelIn.constraints(1).value = 0;
ModelIn.constraints(1).modes = [0 0 0];
ModelIn.constraints(1).constants = 0;
ModelIn.constraints(3).value = 0;
ModelIn.constraints(3).modes = [0 0 0];
ModelIn.constraints(3).algorithm = [0 0 0];
ModelIn.constraints(3).constants = 0;
ModelIn.constraints(2).value = 0;
ModelIn.constraints(2).modes = [0 0 0];
ModelIn.constraints(2).constants = [0 0];
ModelIn.constraints(5).value = 1;
ModelIn.constraints(5).modes = [0 0 0];
ModelIn.constraints(5).algorithm(1) = 0;ModelIn.constraints(5).algorithm(2) = 0;ModelIn.constraints(5).algorithm(3) = 0;ModelIn.constraints(5).algorithm(4) = 0;

bgc=[0.7529 0.7529 0.7529];

ScSize = get(0,'screensize');
VPos   = fix((ScSize(3)-385)/2);
HPos   = fix((ScSize(4)-313)/2);
Pos    = [VPos HPos 385 313];
h = cenwindow(WIC,'MCR-ALS - Second Window - Parameters of ALS',[],380,320);

set(gca,off{:})
Tools = uimenu(la,'&Tools');
Opt   = uimenu(la,'&Preferences');
Help  = uimenu(la,'&Help');
uimenu(Help, la,'&About MCR-ALS',cb,'AboutMCRALS')
uimenu(Help, la,'&Help',tg,'Help',cb,'Help2')

uicontrol(gcf,ty,tx,pos,[15 275 198 25],st,'Maximum number of iterations',ari{:},bg,WIC);
Han.iterations = uicontrol(gcf,ty,ed,pos,[15 255 100 20],bg,wh,cb,'ModelIn.options.algorithm.maxiter = sscanf(get(gcbo,''string''),''%g'');',st,ModelIn.options.algorithm.maxiter,tg,'N_iterations',ari{:});
uicontrol(gcf,ty,tx,pos,[15 220 150 25],st,'Convergence criterion',ari{:},bg,WIC);
Han.conv = uicontrol(gcf,ty,ed,pos,[15 200 100 20],bg,wh,cb,'ModelIn.options.algorithm.convcrit = sscanf(get(gcbo,''string''),''%g'');',st,ModelIn.options.algorithm.convcrit,tg,'Conv_criterion',ari{:});
Han.allspeciespresent = uicontrol(gcf,ty,ch,pos,[15 160 500 25],st,'All species present in all batches',ari{:},cb, 'ModelIn.species.allspecies=get(gcbo,''value'');ModelIn.notallspecies = 0;',tg,'All_Species',va,1,bg,WIC);

Han.notallspeciespresent = uicontrol(gcf,ty,ch,pos,[15 135 500 25],st,'Not all species present in all batches',ari{:},cb, 'ModelIn.species.notallspecies=get(gcbo,''value'');ModelIn.allspecies = 0;',tg,'Not_All_Species',dis{:},bg,WIC);
uicontrol(gcf,ty,tx,pos,[112 100 275 25],st,'Enter species present for different runs',ari{:},dis{:},bg,WIC);
uicontrol(gcf,ty,ed,pos,[15 105 100 20],bg,wh);

Han.constraints = uicontrol(gcf,ty,ch,pos,[15 60 500 25],st,'Do you want to use some constraints ?',ari{:},cb,'ModelIn.options.constraints = get(gcbo,''value'');',tg,'Constraints',bg,WIC);

uicontrol(ty,ps,pos,[245 10 130  30],st,'Close',cb,'close(gcf)',tg,'Samples',  bg,bgc,ari{:},en{:});
uicontrol(ty,ps,pos,[ 10  10 130  30],st,'Continue ',cb, 'close(gcf);global ModelIn ModelOut;if ModelIn.options.constraints==1;[ModelOut,ModelIn]=opa3d3(ModelIn,ModelOut);else [ModelOut,ModelIn]=opa3d(ModelIn,ModelOut);end',tg,'StartBut', bg,bgc,ari{:});
   
  	   
	
       
  
      
 	