function [ModelOut,ModelIn] = opa3d1(ModelIn,ModelOut)
%
% This function allows to make an OPA3D model and corresponds to the 1st
% window
%
% Author:   Sbastien GOURVENEC
%           FABI - VUB
%           email: sgourven@vub.ac.be
% Date: 2002

warning off

global ModelIn ModelOut

GuiNames

PlotStr=getappdata(findobj('type','figure','userdata','Cubatch'),'PlotStr');

[ModelIn,ModelOut,PlotStr]= OPA3check(ModelIn,ModelOut,PlotStr);

bgc=[0.7529 0.7529 0.7529]; % gris

ScSize = get(0,'screensize');
VPos   = fix((ScSize(3)-385)/2);
HPos   = fix((ScSize(4)-313)/2);
Pos    = [VPos HPos 385 313];
h = cenwindow(WIC,'MCR-ALS - First Window - Data Inputs',[],385,313);

set(gca,off{:})
Tools = uimenu(la,'&Tools');
Opt   = uimenu(la,'&Preferences');
Help  = uimenu(la,'&Help');
uimenu(Help, la,'&About MCR-ALS',cb,'AboutMCRALS')
uimenu(Help, la,'&Help',tg,'Help',cb,'Help1')

uicontrol(ty,tx,pos,[10 265  80  25],st,'Method',bg,WIC,ari{:});
uicontrol(ty,ed,pos,[105 267 130  30],st,'MCR-ALS',bg,wh,ari{:});
uicontrol(ty,tx,pos,[-5 200  100  50],st,'Batches numbers',bg,WIC,ari{:});
uicontrol(ty,tx,pos,[-5 170  115  25],st,'Initial Inputs',bg,WIC,ari{:});
uicontrol(ty,ps,pos,[245 268 130  30],st,'X variables',tg,'Varsin',bg,bgc,ari{:},dis{:});
uicontrol(ty,ps,pos,[245 175 130  30],st,'Initial Inputs',cb,'global ModelIn ModelOut;[ModelIn,ModelOut]=initialopa3(ModelIn, ModelOut);',tg,'Samples',bg,bgc,ari{:},en{:});
Han.batchesnumbers  = uicontrol(gcf,ty,ed,pos,[105 222 130  30],bg,wh,ari{:},tg,'Batches numbers',st,[ModelIn.data.var ' ' ModelIn.data.sam]);
Han.columnwise = uicontrol(gcf,ty,ch,pos,[25 115 500 25],st,'Column-wise augmented matrix',ari{:},cb,'ModelIn.options.columnwise = get(gcbo,''value'');if get(gcbo,''value'')==0,set([findobj(''tag'',''Row_wise'')],''enable'',''on'');else set([findobj(''tag'',''Row_wise'')],''enable'',''off'');end;ModelIn.options.rowwise = 0;',tg,'Column_wise',bg,WIC,va,1);
uicontrol(gcf,ty,ch,pos,[25 90 500 25],'enable','off',st,'Row-wise augmented matrix',ari{:},cb,'ModelIn.options.rowwise = get(gcbo,''value'');if get(gcbo,''value'')==0,set([findobj(''tag'',''Column_wise'')],''enable'',''on'');else set([findobj(''tag'',''Column_wise'')],''enable'',''off'');end;ModelIn.options.columnwise = 0;',tg,'Row_wise',bg,WIC);

uicontrol(ty,ps,pos,[ 10  10 130  30],st,'Continue ',cb,'close(gcf);global ModelIn ModelOut;[ModelOut,ModelIn] = opa3d2(ModelIn,ModelOut);',tg,'StartBut', bg,bgc,ari{:});
uicontrol(ty,ps,pos,[245 10 130  30],st,'Close', cb,'close',tg,' close(gcf)',  bg,bgc,ari{:},en{:});
uicontrol(ty,ps,pos,[245 232 130  30],st,'Y variables',tg,'Varsout',  bg,bgc,ari{:},dis{:});

