function [ModelOut,ModelIn] = opa3d(ModelIn,ModelOut)
%
% This function allows to make an OPA3D model
%
% Author:   Sbastien GOURVENEC
%           FABI - VUB
%           email: sgourven@vub.ac.be
% Date: 2002

global ModelIn ModelOut

chose3=unique(ModelIn.file.size);

if size(chose3,1)~=1
    uiwait(warndlg({' ','ONLY FOR INFORMATION',' ','The Datamatrix can not be reshaped and resized','because of different numbers of rows',' ','The OPA3D will performed anyway'}));
    
    [nexp,inutile]=size(ModelIn.file.matrices);
    truc2=ModelIn.file.size(nexp);
    [truc3,inutile]=size(ModelOut.data.dataset);
    
    ModelIn.data.augmentedmatrix=ModelOut.data.dataset;
    ModelIn.data.sizes = ModelIn.file.size(1:nexp,:);
    
else
    
    Data =  reshape(ModelOut.data.dataset',[size(ModelOut.data.dataset,2) ModelIn.file.size(1) size(ModelOut.data.dataset,1)/ModelIn.file.size(1)]);
    %produce a 3 way array with batches in the 1st mode, spectra in the 2nd and time in the 3rd
    Data = permute(Data,[2 1 3]); 
    
    if ModelIn.options.columnwise ==1
        
        Augmat = nshape(Data,2);
        ModelIn.data.augmentedmatrix = Augmat';
        ModelIn.data.sizes = ModelIn.file.size;
        
    end
    
    if ModelIn.options.rowwise ==1
        
        Augmat = nshape(Data,1);
        ModelIn.data.augmentedmatrix = Augmat;
        ModelIn.data.sizes = ModelIn.file.size;
    end
end

ModelOut.model.dataset{1}.data=ModelIn.data.augmentedmatrix;

set(ModelIn.xpointer,'waitstatus','close');   

ModelOut.modelname='OPA3D';

global ModelIn ModelOut

[ModelOut.model.xfactors{1},ModelOut.model.xfactors{2},ModelOut.info.sdopt,ModelOut.info.ropt,ModelOut.info.areaopt,ModelOut.info.rtopt,ModelOut.info.r2opt]=alslight(ModelIn.data.augmentedmatrix,...
    ModelIn.data.initialinput,1,...
    ModelIn.options.nexp,...
    ModelIn.options.algorithm.maxiter,...
    ModelIn.options.algorithm.convcrit,...
    ModelIn.data.sizes,...
    ModelIn.options.columnwise,...
    ModelIn.options.rowwise,...
    ModelIn.constraints(3).value,ModelIn.constraints(3).modes(1),ModelIn.constraints(3).modes(3),ModelIn.constraints(3).modes(2), ModelIn.constraints(3).algorithm(1),ModelIn.constraints(3).algorithm(2),ModelIn.constraints(3).algorithm(3),...
    ModelIn.constraints(6).value,ModelIn.constraints(6).modes(1),ModelIn.constraints(6).modes(2),ModelIn.constraints(6).modes(3), ModelIn.constraints(6).algorithm(1),ModelIn.constraints(6).algorithm(2),ModelIn.constraints(6).algorithm(3),ModelIn.constraints(6).constants,...
    ModelIn.constraints(1).value,ModelIn.constraints(1).modes(1),ModelIn.constraints(1).modes(2),ModelIn.constraints(1).constants,...
    ModelIn.constraints(2).value,ModelIn.constraints(2).value,ModelIn.constraints(2).constants(1),ModelIn.constraints(2).constants(2),...
    ModelIn.constraints(5).value,ModelIn.constraints(5).modes(1),ModelIn.constraints(5).modes(2),ModelIn.constraints(5).modes(3),...
    ModelIn.constraints(5).algorithm(1),ModelIn.constraints(5).algorithm(2),ModelIn.constraints(5).algorithm(3),ModelIn.constraints(5).algorithm(4),...
    ModelIn,ModelOut);

ModelOut.validation = [];
ModelOut.prediction.data = [];









