function ModelOut  = OPA3pply(ModelOut);
%
% This function allows to apply an OPA3D model to new batch(es)
%
% Author:   Sbastien GOURVENEC
%           FABI - VUB
%           email: sgourven@vub.ac.be
% Date: 2002

warning off

global ModelIn ModelOut X

Guinames

if length(ModelOut.model) ~= 1
    ListProp = {'selectionmode','single','name','Choose model','promptstring','Select the model to apply'};
    ReqTit   = 'Choose model';
    Cont     = cellstr(num2str(cat(1,ModelOut.model.nbfactors)));
    [RankPos,Ok] = listdlg('Liststring',Cont,ListProp{:});
    if ~Ok
        return
    end
end
ListProp          = {'selectionmode','single','name','Load array','promptstring','Select the array to load'};
ReqTit            = 'Load data';
[Xt,Yt,Xfil,Yfil] = deal({});
try
    cd data
    [Xfil{2:-1:1}]    = uigetfile('*.mat',ReqTit);
    cd ..
catch
    [Xfil{2:-1:1}]    = uigetfile('*.mat',ReqTit);
end
RankPos           = 1;
if Xfil{1} ~= 0
    Cont = who('-file',[Xfil{:}]);
    Ok   = 1;
    Sel  = 1;
    if length(Cont) > 1
        [Sel,Ok] = listdlg('Liststring',Cont,ListProp{:});
    end
    if Ok
        Xt   = load([Xfil{:}],Cont{Sel});
        Xt   = getfield(Xt,Cont{Sel});
        if ~isempty(Xt)
            if iscell(Xt)
                if ~isa(Xt{1},'cbdataset'),
                    return;
                else
                    Xn=Xt{1};
                end
            else
                if isa(Xt,'cbdataset'),
                    Xn=Xt;
                else
                    Xn=cbdataset(Xt);
                end;
            end;
            if ndims(Xn) ~= length(ModelOut.model(RankPos).xfactors)
                errordlg({'The current model cannot be applied to this data set:','the dimensions are not compatible'})
                return
            else 
                DimX = size(Xn);
                DimM = size(ModelOut.data.dataset);
                if DimX(2:end) ~= DimM(2:end)
                    errordlg({'The current model cannot be applied to this data set:','the dimensions are not compatible'})
                    return
                end
            end
        else
            return
        end
    else 
        return
    end
    
    % Temp modif
    %    if ~isa(Xt,'cbdataset')
    %        Ans = questdlg('Batch labels','Batches labels','Load','Default','Cancel','Load');
    %        if strcmp(Ans,'Load')
    %           [Lafil{2:-1:1}] = uigetfile('*.mat','Load Y data');
    %           Cont = who('-file',[Lafil{:}]);
    %           Ok   = 1;
    %           Sel  = 1;
    %           if length(Cont) > 1
    %              [Sel,Ok] = listdlg('Liststring',Cont,ListProp{:});
    %           end
    %           if Ok
    %              Lat  = load([Lafil{:}],Cont{Sel});
    %              Lat  = getfield(Lat,Cont{Sel});
    %           else 
    %              return
    %           end
    %        elseif strcmp(Ans,'Cancel')
    %          return
    %        else
    %           Lat = [];
    %        end
    %        try
    %           Xt = cbdataset(Xt,'labels',[{Lat},ModelOut.data.dataset.labobj(2:end)]);
    %        catch
    %           errordlg(lasterr)
    %        end
    %     end
    %  else
    %     return
    %  end
    % End Temp modif
    
    ModelOut.prediction.data = Xn;
    clear Xn
    
    if ~isa(ModelOut.data.dataset,'cbdataset')
        bidule{1}=cbdataset(ModelOut.data.dataset);
        ModelOut.data.dataset=bidule;
    end
    
    
    DisplayInfo(gcbf,ModelOut.data.dataset);
    delete(findobj('tag','cbaxes'))
    OPA3DisplayInfo(gcbf,ModelOut);
    [ModelIn,ModelOut]=opa3activateplots(ModelIn,ModelOut,X);
    
    ModelOut = OPA3ApplyModel(ModelOut);
    
end

warning on

return
