%function [copt,sopt,sdopt,ropt,areaopt,rtopt]=alslight(d,x0,nexp,nit,tolsigma,isp,csel,ssel,vclos1,vclos2);
%
% This m-file allows to resolve severla matrices using MCR-ALS
%
% The MATLAB program MCR-ALS: multivariate curve resolution (MCR)-alternating least squares (ALS)               
% was written by:
% 
% Roma Tauler and Anna de Juan, 1999 
% Chemometrics and Solution Equilibria group    
% University of Barcelona                       
% Department of Analytical Chemistry            
% Diagonal 647, Barcelona 08028                 
% e-mail roma@quimio.qui.ub.es                 
%
% It is freely available on the internet 
%
% This m-file was slightly modified by Sbastien Gourvnec to fit to the software
% designed in the frame of the NWAYQUAL Project
% Date: 2002
%

function [copt,sopt,sdopt,ropt,areaopt,rtopt,r2opt]=alslight(d,x0,ils,...
    nexp,nit,tolsigma,sizes,columnwise,rowwise,...
    nonnegativityvalue, nonnegativityconcentrations,nonnegativityconcspectra,nonnegativityspectra, nonnegativityforcedtozero,nonnegativitynnls,nonnegativityfnnls,...
    unimodalityvalue,unimodalityconcentrations,unimodalityspectra,unimodalityconcspec,unimodalityvertical,unimodalityhorizontal,unimodalityaverage,unimodalitytolerance,...
    closurevalue,closureconcentrations,closurespectra,closureconstant,...
    eqconstconcvalue,eqconstspecvalue,eqconstconccsel,eqconstspecssel,...
    threewayvalue,threewayconstC,threewayconstS,threewayconstCS,threewaynotrilinear,threewaytrilinearshapesynchallspecies,threewaytrilinearshapeallspecies,threewaytrilinearsynchsomespecies,...
    ModelIn,ModelOut);

global ModelIn ModelOut X

Guinames

warning off

% A) DATA PREPARATION AND INPUT
ils == 1;

[nrow,ncol]=size(d);

if isa(x0,'cbdataset')
    x0=x0.data;
end

[nrow2,ncol2]=size(x0);
if nrow2==nrow, nsign=ncol2; ils=1;end
if ncol2==nrow, nsign=nrow2; x0=x0'; ils=1; end 
if ncol2==ncol, nsign=nrow2; ils=2;end
if nrow2==ncol, nsign=ncol2; x0=x0'; ils=2; end

if ils==1,
    conc=x0;
    [nrow,nsign]=size(conc);
    abss=conc\d;
end
if ils==2,
    abss=x0;
    [nsign,ncol]=size(abss);
    conc=d/abss;
end
% ********************
% INITIAL ESTIMATIONS 
% ********************

% INITIALIZATIONS - DEFAULT VALUES
if nexp==1,
    ncinic(nexp)=1;
    ncfin(nexp)=ncol;
    nrinic(nexp)=1;
    nrfin(nexp)=nrow;
end
scons='y'; % all the spectra matrices the same constraints
ccons='y'; % all the concentration matrices the same constraints
niter=0;% iterations counter
idev=0;% divergence counter
idevmax=10;% maximum number of diverging iterations
ans='n'; % default answer
ineg=0;% used for non-negativity constraints
imod=0;% used for unimodality constraints
iclos0=0;% used for closure constraints
iassim=0;% used for shape constraints
datamod=99;% in three-way type of matrix augmentation (1=row,2=column)
matr=1;% one matrix
matc=1;% one matrix
vclos1n=0;% used for closure constraints
vclos2n=0;% used for closure constraints
inorm=0;% no normalizatio (when closure is applied)

%***************************
% DEFINITION OF THE DATA SET
%***************************
totalconc(1:nsign,1:nexp)=ones(nsign,nexp);
% IN SIMULTANEOUS ANALYSIS OF SEVERAL SAMPLES ENTER NUMBER OF SPECTRA

if nexp > 1,
    if columnwise == 1 
        matr = 1;
        ncinic(1)=1;
        ncfin(1)=ncol;
        matc = nexp;         
        nrinic(1)=1;
        for i=1:matc,
            temp = sizes(i,:);
            nrsol(i)=temp(1);
            nrfin(1)=nrsol(1);
            if i>1, nrinic(i)=nrfin(i-1)+1;
                nrfin(i)=nrinic(i)+nrsol(i)-1;
            end
            ncinic(i)=1;
            ncfin(i)=ncol;
        end
    end
    
    if rowwise == 1
        matc = 1;
        nrinic(1)=1;
        nrfin(1)=nrow;
        matr = nexp;
        ncinic(1) = 1;
        for i=1:matr,
            temp = sizes(i,:);
            nrsol(i)=temp(2);
            ncfin(1)=ncsol(1);
            if i>1, ncinic(i)=ncfin(i-1)+1;
                ncfin(i)=ncinic(i)+ncsol(i)-1;
            end
        end
    end     
    
else
    
    % WHEN ONLY ONE EXPERIMENT IS PRESENT EVERYTHING IS CLEAR
    nrsol(1)=nrow;
    nrinic(1)=1;
    nrfin(1)=nrsol(1);
    nesp(1)=nsign;
    matr = 1;
    matc = 1;
    isp(1,1:nsign)=ones(1,nsign);
    ishape=0;
end

if columnwise ==1			%for columnwise
    isp=ones(matc,nsign);
else if rowwise ==1 		%for rowwise
        isp=ones(matr,nsign);
    end
end

% *************************
% INPUT TYPE OF CONSTRAINTS
% *************************
if matc>1
    ccons = 'y';
end
if matr>1
    scons = 'n';
end

% ***************************
% B) SELECTION OF CONSTRAINTS
% ***************************
% **************************
% NON-NEGATIVITY CONSTRAINTS
% **************************************************************************************************************************************************************************************
c1 = nonnegativityvalue;

if c1 == 1 
    if nonnegativityconcentrations == 1
        ineg = 1
    else
        if nonnegativityconcspectra == 1
            ineg = 2
        else
            if nonnegativityspectra == 1
                ineg = 3
            end
        end
    end
    
    if ineg==3|ineg ==2
        if nonnegativityforcedtozero == 1
            ialgs = 0
        else
            if nonnegativitynnls == 1
                ialgs = 1
            else 
                if nonnegativityfnnls == 1
                    ialgs = 2
                end
            end
        end
    end
    
    if scons=='y' | nexp == 1
        if ialgs == 0
            nspneg = nsign;
            spneg = ones(nsign,matr);
        end
    end
    
    if ineg==1|ineg ==2 
        if nonnegativityforcedtozero == 1
            ialg = 0
        else
            if nonnegativitynnls == 1
                ialg = 1
            else 
                if nonnegativityfnnls == 1
                    ialg = 2
                end
            end
        end
    end  
    
    if ccons=='y' | nexp == 1
        ncneg = nsign;
        cneg = ones(matc,nsign);
    end
else
    cneg=zeros(matc,nsign);
    spneg = zeros(nsign,matr);
    ialg = 99;
    ialgs = 99;
end

% **********************
% UNIMODALITY CONSTRAINT
% **********************************************************************************************************************************************************************************

c2 = unimodalityvalue;

if c2 == 1
    if unimodalityconcentrations == 1
        imod = 1;
    else
        if unimodalityspectra == 1
            imod = 2
        else if unimodalityconcspec == 1
                imod = 3
            end
        end
    end
    
    if imod==2|imod==3,
        if nexp == 1|scons == 'y'|scons == 'Y'
            nsmod=nsign;
            spsmod=ones(1,nsign); 
        end
        
        smod = unimodalitytolerance;
        
        if smod==1;
            smod=1.0001;
        end
    end
    
    if imod==1|imod==3,
        if nexp==1 | ccons=='y' | ccons=='Y'
            nmod=nsign;
            spmod=ones(1,nsign);
            spmod = ones(matc,1)*spmod;
            
        end
        
        rmod = unimodalitytolerance;
        if rmod==1,
            rmod=1.0001;
        end
    end
    
    if unimodalityvertical == 1
        cmod = 0;
    else 
        if unimodalityhorizontal == 1
            cmod = 1;
        else if unimodalityaverage == 1
                cmod = 2;
            end 
        end
    end
end


% ******************
% CLOSURE CONSTRAINT
% ************************************************************************************************************************************************************************************

c3 = closurevalue;

if c3 == 1 
    if closureconcentrations == 1
        dc =1;
    else if closurespectra == 1
            dc = 2;
        end
    end
    %********************
    % closure for spectra
    % *******************
    if dc == 2
        tclos1(1:matr)=zeros(1,matr);
        tclos2(1:matr)=zeros(1,matr);
        sclos1(1:matr,1:nsign)=ones(matr,nsign);
        sclos2(1:matr,1:nsign)=zeros(matr,nsign);
        iclos(1:matr)=zeros(1,matr);
        iclos1(1:matr)=zeros(1,matr);
        iclos2(1:matr)=zeros(1,matr);
        
        for i= 1:matr
            iclos(i)= 1;
            if iclos(i)==1 | iclos(i)==2,
                tclos1(i)=closureconstant;
                iclos1(i)=2;
            end
        end
    end
    %***************************
    % closure for concentrations
    % **************************
    
    if dc == 1
        tclos1(1:matc)=zeros(1,matc);
        tclos2(1:matc)=zeros(1,matc);
        sclos1(1:matc,1:nsign)=ones(matc,nsign);
        sclos2(1:matc,1:nsign)=zeros(matc,nsign);
        iclos(1:matc)=zeros(1,matc);
        iclos1(1:matc)=zeros(1,matc);
        iclos2(1:matc)=zeros(1,matc);
        
        for i=1:matc,
            iclos(i)= 1;
            if iclos(i)==1 | iclos(i)==2,
                tclos1(i)=closureconstant;
                iclos1(i)=2;
            end
        end
    end
    
end

% *************************************
% EQUALITY CONSTRAINTS IN CONC PROFILES
% *****************************************************************************************************************************************************************************************
c4 = eqconstconcvalue;
if c4 == 1
    if isempty(eqconstconccsel),
        disp(' ');disp(' ');disp(' ')
        disp('conc equality constraints matrix csel was not input'),
        return
    else
        disp(' ');disp(' ');disp(' ')
        disp('CONC EQUALITY CONSTRAINTS WILL BE APPLIED !!!!'),
        iisel=find(finite(eqconstconccsel));
        conc(iisel)=eqconstconccsel(iisel);
    end
end
% *****************************************
% EQUALITY CONSTRAINTS IN SPECTRA PROFILES
% ********************************************************************************************************************************************************************************
c5 = eqconstspecvalue;
if c5 == 1
    if eqconstspecssel==[],
        disp(' ');disp(' ');disp(' ')
        disp('spectra equality constraints matrix ssel was not input'),
        return
    else
        disp(' ');disp(' ');disp(' ')
        disp('SPECTRA EQUALITY CONSTRAINTS WILL BE APPLIED !!!!'),
        jjsel=find(finite(eqconstspecssel));
        abss(jjsel)=eqconstspecssel(jjsel);
    end
end
% *******************
% THREE-WAY STRUCTURE
% *************************************************************************************************************************************************************************************************************************************************************************

c7 = threewayvalue;
if c7 == 1 | nexp > 1
    if threewaynotrilinear == 0 % this has to be checked...before it was if threewaynotrilinear == 1
        ishape = 0;
    else 
        if threewaytrilinearshapesynchallspecies == 1
            ishape = 1;
        else
            if threewaytrilinearshapeallspecies == 1
                ishape = 2;
            else 
                if threewaytrilinearsynchsomespecies == 1
                    ishape = 3;
                end
            end
        end
    end
    
    trildir=99;
    spetric=zeros(1,nsign);
    spetris=zeros(1,nsign);
    
    if ishape==1|ishape==2|ishape==3
        if datamod==3
            if threewayconstC == 1
                trildir = 1;
            else 
                if threewayconstS == 1
                    trildir = 2;
                else
                    if threewayconstCS == 1
                        trildir = 3;
                    end
                end
            end
            
        end
        
        
        if datamod==2
            trildir=2;
        elseif datamod ==1
            trildir=1;
        end
    end
end

% This end comes from the initial while
% *******************************************************************************************************************************************************************************************
end


% ***********************************************************
% C) REPRODUCTION OF THE ORIGINAL DATA MATRIX BY PCA
% *****************************************************************************************************************************************

nsign;
dn=d;
[u,s,v,d,sd]=pcarep(dn,nsign);
clc
sstn=sum(sum(dn.*dn));
sst=sum(sum(d.*d));
sigma2=sqrt(sstn);

% ************************************************************
% D) STARTING ALTERNATING CONSTRAINED LEAST SQUARES OPTIMIZATION
% ******************************************************************************************************************************************

r2cum=[];

while niter < nit
    niter=niter+1;
    % ***************************************
    % E) ESTIMATE CONCENTRATIONS (ALS solutions)
    % *********************************************************************************************************************
    conc=d/abss;
    % ******************************************
    % CONSTRAIN APPROPRIATELY THE CONCENTRATIONS
    % ************************************************************************************************************************
    % ****************
    % non-negativity
    % ****************
    
    if c1 == 1
        
        for i =1:matc
            
            kinic=nrinic(i);
            kfin=nrfin(i);
            conc2=conc(kinic:kfin,:);
            
            if ialg==0
                for k=1:nsign,
                    if cneg(i,k) ==1
                        for j=1:kfin+1-kinic,
                            if conc2(j,k)<0.0,
                                conc2(j,k)=0.0;
                            end
                        end
                    end
                end
            end
            
            if ialg==1
                for j=kinic:kfin
                    if cneg(i,:) == ones(1,size(isp,2))
                        x=nnls(abss',d(j,:)');
                        conc2(j-kinic+1,:)=x';
                    end
                end
            end
            
            if ialg==2  
                for j=kinic:kfin
                    if cneg(i,:) == ones(1,size(isp,2)) 
                        x=fnnls(abss*abss',abss*d(j,:)');
                        conc2(j-kinic+1,:)=x';
                    end
                end
            end
            
            conc(kinic:kfin,:) = conc2;
        end
    end
    % ************
    % trilinearity
    % **********************************************************************************************************************************************
    if ishape>=1
        if trildir==1|trildir==3
            for j=1:nsign,
                if spetric(j)==1,
                    [conc(:,j),t]=trilin(conc(:,j),matc,ishape);
                    totalconc(j,1:matc)=t;
                    rt(j,1:matc)=totalconc(j,1:matc)./totalconc(j,1);
                end
            end
        end
    end
    % **************************
    % zero concentration species
    % ************************************************************************************************************************************************************
    if matc>1
        for i=1:matc,
            for j=1:nsign,
                if isp(i,j)==0,
                    conc(nrinic(i):nrfin(i),j)=zeros(nrsol(i),1);
                end
            end
        end
    end
    % ***********
    % unimodality
    % ***********************************************************************************************************************************************************************
    for i = 1:matc
        kinic=nrinic(i);
        kfin=nrfin(i);
        conc2=conc(kinic:kfin,:);
        if imod==1|imod==3,
            for ii=1:nsign,
                if spmod(i,ii)==1,
                    conc2(:,ii)=unimod(conc2(:,ii),rmod,cmod);
                end
            end
        end
        conc(kinic:kfin,:)=conc2;
    end
    
    % ****************************
    % EQUALITY CONSTRAINTS IN CONC
    % **************************************************************************************************************************************************************
    
    if c4==1
        conc(iisel)=csel(iisel);
    end
    
    % ********
    % closure
    % ********************************************************************************************************************************************************************
    
    if c3==1
        if dc == 1
            for i = 1:matc
                kinic=nrinic(i);
                kfin=nrfin(i);
                conc2=conc(kinic:kfin,:);
                if iclos(i)==1 | iclos(i)==2,
                    if tclos1(i) == 0 
                        vclos1n=vclos1(kinic:kfin,1);
                    end
                    if iclos(i) ==2 & tclos2(i)==0
                        vclos2n=vclos2(kinic:kfin,1);
                    end
                    [conc2]=closure(conc2,iclos(i),sclos1(i,:),iclos1(i),tclos1(i),tclos2(i),sclos2(i,:),iclos2(i),vclos1n,vclos2n);
                end
                conc(kinic:kfin,:)=conc2;
            end
        end
    end
    % ************************************************
    % QUANTITATIVE INFORMATION FOR THREE-WAY DATA SETS
    % ******************************************************************************************************************************
    % recalculation of total and ratio concentrations if ishape=0 and niter=1
    if ishape==0 | niter==1,
        for j=1:nsign,
            for inexp=1:matc,
                totalconc(j,inexp)=sum(conc(nrinic(inexp):nrfin(inexp),j));
            end
            rt(j,1:inexp)=totalconc(j,1:matc)./totalconc(j,1);
        end
    end
    % areas under concentration profiles
    area=totalconc;
    % ********************************
    % ESTIMATE SPECTRA (ALS solution)
    % **************************************************************************************************************
    abss=conc\d;
    % ********************
    % non-negative spectra
    % ****************************************************************************************************************************
    if ineg ==2 |ineg==3,
        for i = 1:matr
            kinic = ncinic(i);
            kfin = ncfin(i);
            abss2 = abss(:,kinic:kfin);
            if ialgs==0,
                for k=1:nsign,
                    if spneg(k,i)==1
                        for j=1:kfin+1-kinic,
                            if abss2(k,j)<0.0,
                                abss2(k,j)=0.0;
                            end
                        end
                    end
                end
            end
            if ialgs==1,
                for j=kinic:kfin,
                    if spneg(:,i)== ones(size(isp,2),1)
                        abss2(:,j-kinic+1)=nnls(conc,d(:,j));
                    end
                end
            end
            if ialgs==2, 
                for j=kinic:kfin,
                    if spneg(:,i)== ones(size(isp,2),1)                     
                        abss2(:,j-kinic+1)=fnnls(conc'*conc,conc'*d(:,j));
                    end                     
                end
            end
            abss(:,kinic:kfin)=abss2;
        end
    end
    % ************
    % trilinearity
    % ************************************************************************************************************************************************************************
    if ishape>=1,
        if trildir==2|trildir==3
            for j=1:nsign,
                if spetris(j)==1,
                    [absst,t]=trilin(abss(j,:)',matr,ishape);
                    abss(j,:)=absst';
                end
            end
        end
    end
    % ************************************
    % constrain the unimodality of spectra
    % **********************************************************************************************************************************************************************
    for i = 1:matr
        kinic = ncinic(i);
        kfin = ncfin(i);
        abss2 = abss(:,kinic:kfin);
        if imod==2|imod==3,
            for j=1:nsign
                if spsmod(i,j)==1
                    dummy=unimod(abss2(j,:)',smod,cmod);
                    abss2(j,:)=dummy';
                end
            end
        end
        abss(:,kinic:kfin)=abss2;
    end
    % ********************************
    % EQUALITY CONSTRAINTS FOR SPECTRA
    % ******************************************************************************************************************************************************************
    if c5==1
        abss(jjsel)=ssel(jjsel);
    end
    % *******************************************************
    % closure in spectra (in case of inverted analysis D'=SC)
    % *****************************************************************************************************************************************************************************************
    if c3==1
        if dc==2,
            for i = 1:matr
                kinic = ncinic(i);
                kfin = ncfin(i);
                abss2 = abss(:,kinic:kfin);
                if iclos(i)==1 | iclos(i)==2,
                    if tclos1(i) == 0 
                        vclos1n=vclos1(kinic:kfin,1);
                    end
                    if iclos(i) ==2 & tclos2(i)==0
                        vclos2n=vclos2(kinic:kfin,1);
                    end
                    abst = closure(abss2',iclos(i),sclos1(i,:),iclos1(i),tclos1(i),tclos2(i),sclos2(i,:),iclos2(i),vclos1n,vclos2n);
                    abss2=abst';
                end
                abss(:,kinic:kfin) = abss2;
            end
        end
    end
    % *******************
    % CALCULATE RESIDUALS
    % *************************************************************************************************
    res=d-conc*abss;
    resn=dn-conc*abss;
    % ********************
    % OPTIMIZATION RESULTS
    % **************************************************************************************************
    u=sum(sum(res.*res));
    un=sum(sum(resn.*resn));
    sigma=sqrt(u/(nrow*ncol));
    sigman=sqrt(un/(nrow*ncol));
    change=((sigma2-sigma)/sigma);
    if change < 0.0,
        idev=idev+1;
    else,
        idev=0;
    end
    change=change*100;
    sstd(1)=sqrt(u/sst)*100;
    sstd(2)=sqrt(un/sstn)*100;
    r2=(sstn-un)/sstn;
    r2cum=[r2cum;r2];
    
    % *************************************************************
    % If change is positive, the optimization is working correctly
    % *****************************************************************************************************************
    if change>0 | niter==1,
        sigma2=sigma;
        copt=conc;
        sopt=abss;
        sdopt=sstd;
        ropt=res;
        rtopt=rt';
        itopt=niter;
        areaopt=area;
    end
    % ******************************************************************
    % test for convergence within maximum number of iterations allowed
    % **********************************************************************************************************************
    %     if abs(change) < tolsigma,
    %         %disp('CONVERGENCE IS ACHIEVED !!!!')
    %         %return% 1st return (end of the optimization, convergence)
    %     end
    % finish the iterative optimization if divergence occurs 20 times consecutively
    %     if idev > 20,
    %         %disp('Divergence 20 times consecutively, stop!!!')
    %         %disp(['Fitting error (%) at the optimum = ', num2str(sdopt(1,1)),'(PCA) ', num2str(sdopt(1,2)), '(exp)']);
    %         %disp('Relative concentrations respect matrix (sample) 1'),disp(rt)
    %         %disp(['Results given in output are at optimum in the iteration ', num2str(itopt)]);
    %         % subplot(2,1,1);plot(copt);title('conc profile in optimal iteration');
    %         % subplot(2,1,2);plot(sopt');title('pure spectra in optimal iteration');
    %         %return% 2nd return (end of optimization, divergence)      
    %     end
end   % finish the iterative optimization if maximum number of allowed iterations is exceeded

r2opt=r2cum(itopt);
[ModelIn,ModelOut]=opa3activateplots(ModelIn,ModelOut,X);

warning on