%
%   ############################################################
%    Function called from resol.m
%
%    function [C,A]=resol1
%
%
%    Author: Paqui Cuesta
%    Address: ChemoAC, V.U.B. , Laarbeeklaan 103,
%             B-1090  Brussel  Belgium
%    Date: 4.12.95
%    
%	  Modified by Sbastien Gourvnec to fit to the software
%	  designed in the frame of the NWAYQUAL Project
%	  Date: 25.07.02
%
%   ############################################################

function [C,A] = resol1

GuiNames

global ModelOut ModelIn X

global da1 x0 method ed_nit ed_tol sp_neg obj var

nit=eval(get(ed_nit,'string'));
ModelIn.options.algorithm.maxiter=nit;
tolsigma=eval(get(ed_tol,'string'));
ModelOut.model.info.tolsigma=tolsigma;
spneg=get(sp_neg,'value');
ModelOut.model.info.spneg=spneg;

if method == 1
  
   global ch_uni ed_tuni ch_clo ed_bac
   cuni=get(ch_uni,'value');
   ModelOut.model.info.cuni=cuni;
   tluni=eval(get(ed_tuni,'string'));
   ModelOut.model.info.tluni=tluni;
   tluni=tluni-1;
   cclo=get(ch_clo,'value');
   ModelOut.model.info.cclo=cclo;
   mback=eval(get(ed_bac,'string'));
   ModelOut.model.info.mback=mback;

elseif method == 2

   global lmax stand tcte model
   if model == 1, par=[lmax;stand];end
   if model == 2 | model == 3,par=[lmax;stand;tcte];end

end


[nrow,ncol]=size(da1);
[m,ncomp]=size(x0);

%
changetot=[];sigtot=[];
iter = 0; c2 = x0;
sst=trace(da1*da1');
resold=sst;
change=100;

div=0;
while abs(change) > tolsigma & iter < nit;

  iter = iter + 1;

  if method == 1
  
     c2=c2./(ones(nrow,1)*max(c2));
     c2=c2.*(c2 > mback);
     c2(c2==0)=c2(c2==0)+mback;

     if cuni
       [maxi,imax]=max(c2);
       for k=1:ncomp
          rmax=maxi(k);
          for j=imax(k):-1:1
            limit=rmax+tluni*abs(rmax);
            if c2(j,k) > limit,c2(j,k)=limit;end
            rmax=c2(j,k);
          end
          rmax=maxi(k);
          for j=imax(k):nrow
            limit=rmax+tluni*abs(rmax);
            if c2(j,k) > limit,c2(j,k)=limit;end
            rmax=c2(j,k);
          end
        end
     end

%
  elseif method == 2
  
     for ij=1:ncomp
       c2(:,ij)=c2(:,ij).*(c2(:,ij)>0);
       c2(:,ij)=c2(:,ij)./sum(c2(:,ij));
       [par(:,ij),sigma,cormat,status,c2(:,ij)] = nlr (obj,c2(:,ij),'fit_fun',par(:,ij),[],[],model);

     end
  end

  if cclo
     tsi=sum(c2')';tsi=tsi+1e-30;c2=c2./(tsi*ones(1,ncomp));
  end

  C=c2;
  A = c2 \ da1;
  if spneg==1;A=A.*(A > 0);end

    res=da1-c2*A;  % Residuals
    resnew=sqrt(trace(res*res')/(nrow*ncol));
    change=100*((resold-resnew)/resnew);
    if change < 0, div=div+1;elseif change > 0,div=0;end
    if div == 10;
         clc
         close
         %disp('  The process is divergence !!!')
         clear global
         clear l_obj ic
         return         
    end

    sigtot=[sigtot,resnew];
    changetot=[changetot,change];

    %disp(' ')
    %disp(['Iteration: ',int2str(iter)])
    %disp(['SSQD = ',num2str(resnew)])
    %disp(['Change (%) = ',num2str(change)])

    resold=resnew; 
    c2 = da1 / A;

end;

% If the system is not closed the spectra are normalized to equal area

if cclo == 0 | isempty(cclo)
  tsi=sum(abs(A'));A=A./(tsi'*ones(1,ncol));
  C=C*diag(tsi);c2=c2*diag(tsi);
end
%
% Goodness of fit
%
gfit=100*sqrt(sum(sum(res.^2))/sst);
%disp(['Goodness of fit (%) = ',num2str(gfit)])

clear l_obj ic
 
 [ModelIn,ModelOut]=opaactivateplots(ModelIn,ModelOut,X);
 
 ModelOut.validation = [];
 ModelOut.prediction.data = [];

