%
%   ############################################################
%    Resolution of a bilinear data matrix by
%    an Alternating Least Squares approach
%     
%    Function called from opa.m & simpus.m
% 
%    function resol(method,model);
%
%
%    Author: Paqui Cuesta
%    Address: ChemoAC, V.U.B. , Laarbeeklaan 103,
%             B-1090  Brussel  Belgium
%    Date: 4.12.95
%    
%	  Modified by Sbastien Gourvnec to fit to the software
%	  designed in the frame of the NWAYQUAL Project
%	  Date: 25.07.02
%
%   ############################################################
%
%

function [C,A,pursp,objsel] = resol(method,model);

[C,A,pursp,objsel] = deal([]);

warning off

global ModelOut ModelIn

global da1 objsel pursp x0 method ed_nit ed_tol sp_neg model obj var
objsel=sort(objsel);
if pursp == 1, x0=da1/da1(objsel,:);
elseif pursp == 2,
    da1=da1';lrow=obj;obj=var;var=lrow;x0=da1(:,objsel);
end

close
nit=50;        % Maximum number of iterations
tolsigma=0.1;  % Convergence criterium
spneg=0;       % Non-negative spectra

h = cenwindow([0.5029 0.5814 0.6402],'Resolution of the data matrix',[],470,370);

uicontrol(gcf,'style','frame','backgroundcolor',[0.3529 0.4314 0.4902],'position',[40 285 395 65]);

uicontrol(gcf,'style','text','backgroundcolor',[0.3529 0.4314 0.4902],'position',[100 320 210 20],...
    'string','Maximum number of iterations','fontname','Helvetica','fontsize',10);
ed_nit=uicontrol(gcf,'style','edit','position',[315 320 60 20],...
    'string',int2str(nit),'backgroundcolor',[1 1 1],'fontname','Helvetica','fontsize',10);
uicontrol(gcf,'style','text','backgroundcolor',[0.3529 0.4314 0.4902],'position',[119 295 160 20],...
    'string','Convergence criterion (%)','fontname','Helvetica','fontsize',10);
ed_tol=uicontrol(gcf,'style','edit','position',[315 295 60 20],...
    'string',num2str(tolsigma),...
    'backgroundcolor',[1 1 1],'fontname','Helvetica','fontsize',10);

uicontrol(gcf,'style','frame','backgroundcolor',[0.3529 0.4314 0.4902],'position',[40 115 395 160]);

if method ==1
    
    global ch_uni ed_tuni ch_clo ed_bac
    
    cuni=1;  % Concentration unimodality
    tluni=1;  % Tolerance limit for unimodality
    cclo=0;   % Concentration closure
    mback=0;   % Mean background
    
    uicontrol(gcf,'style','text','backgroundcolor',[0.3529 0.4314 0.4902],'position',[115 244 150 20],...
        'string','Concentration profiles','fontname','Helvetica','fontsize',10,'fontweight','bold');
    
    ch_uni=uicontrol(gcf,'style','checkbox','backgroundcolor',[0.3529 0.4314 0.4902],'position',[120 214 100 20],...
        'string','Unimodality','value',cuni,'fontname','Helvetica','fontsize',10);
    
    uicontrol(gcf,'style','text','backgroundcolor',[0.3529 0.4314 0.4902],'position',[140 185 105 20],...
        'string','Tolerance limit','fontname','Helvetica','fontsize',10);
    ed_tuni=uicontrol(gcf,'style','edit','position',[255 185 60 20],...
        'backgroundcolor',[1 1 1],'string',num2str(tluni),'fontname','Helvetica','fontsize',10);
    
    ch_clo=uicontrol(gcf,'style','checkbox','backgroundcolor',[0.3529 0.4314 0.4902],'position',[120 160 100 20],...
        'string','Closure','value',cclo,'fontname','Helvetica','fontsize',10);
    
    uicontrol(gcf,'style','text','backgroundcolor',[0.3529 0.4314 0.4902],'position',[140 130 120 20],...
        'string','Mean background','fontname','Helvetica','fontsize',10);
    ed_bac=uicontrol(gcf,'style','edit','position',[255 130 60 20],...
        'backgroundcolor',[1 1 1],'string',num2str(mback),'fontname','Helvetica','fontsize',10);
    
elseif method == 2
    
    global tx1 ed_max ed_st ed_ct sl
    global lmax stand tcte
    
    ncomp=length(objsel);
    ic=1;
    [ro,co]=size(obj);if ro==1,obj=obj';end
    [maxi,imaxi]=max(x0);
    lmax=obj(imaxi)';
    stand=3*ones(1,ncomp);
    if model<=2;tcte=ones(1,ncomp);end
    if model == 3,tcte=.3*ones(1,ncomp);end
    
    uimenu(gcf,'label','View','callback','resol2')
    
    uicontrol(gcf,'style','text','position',[60 245 230 20],...
        'string','Concentration profile of compound :'); 
    tx1=uicontrol(gcf,'style','text','position',[300 245 50 20],...
        'string',int2str(ic));
    
    uicontrol(gcf,'style','text','position',[60 215 170 20],...
        'string','Position of the maximum');
    ed_max=uicontrol(gcf,'style','edit','position',[300 215 50 20],...
        'backgroundcolor',[1 1 1],'string',num2str(lmax(ic)),...
        'callback',['global ed_max lmax sl,ic=round(get(sl,''value''));' ...
            'lmax(ic)=eval(get(ed_max,''string''));'],'fontsize',10);
    
    uicontrol(gcf,'style','text','position',[60 185 130 20],...
        'string','Standard deviation');
    ed_st=uicontrol(gcf,'style','edit','position',[300 185 50 20],...
        'backgroundcolor',[1 1 1],'string',num2str(stand(ic)),...
        'callback',['global ed_st stand sl,ic=round(get(sl,''value''));' ...
            'stand(ic)=eval(get(ed_st,''string''));']);
    
    if model > 1
        
        uicontrol(gcf,'style','text','position',[60 155 100 20],...
            'string','Time constant');
        ed_ct=uicontrol(gcf,'style','edit','position',[300 155 50 20],...
            'backgroundcolor',[1 1 1],'string',num2str(tcte(ic)),...
            'callback',['global ed_ct tcte sl,ic=round(get(sl,''value''));' ...
                'tcte(ic)=eval(get(ed_ct,''string''));']);
    end
    
    uicontrol(gcf,'style','text','position',[380 117 25 20],...
        'string','1');
    uicontrol(gcf,'style','text','position',[380 250 25 20],...
        'string',int2str(ncomp));
    sl=uicontrol(gcf,'style','slider','position',[380 137 25 113],...
        'min',1,'max',ncomp,'value',ic,...
        'callback',['global tx1 sl ed_max ed_st ed_ct lmax stand tcte,' ...
            'ic=round(get(sl,''value''));set(tx1,''string'',int2str(ic)),' ...
            'set(ed_max,''string'',num2str(lmax(ic))),' ...
            'set(ed_st,''string'',num2str(stand(ic))),' ...
            'set(ed_ct,''string'',num2str(tcte(ic)))']);
    
end

%  Spectral profiles
uicontrol(gcf,'style','frame','backgroundcolor',[0.3529 0.4314 0.4902],'position',[40 20 230 85]);
uicontrol(gcf,'style','text','backgroundcolor',[0.3529 0.4314 0.4902],'position',[115 70 120 20],...
    'string','Spectral profiles','fontname','Helvetica','fontsize',10,'fontweight','bold');
sp_neg=uicontrol(gcf,'style','checkbox','backgroundcolor',[0.3529 0.4314 0.4902],'position',[120 40 120 20],...
    'string','Non-negativity','value',spneg,'fontname','Helvetica','fontsize',10);
uicontrol(gcf,'style','frame','backgroundcolor',[0.3529 0.4314 0.4902],'position',[290 20 145 85]);

uicontrol(gcf,'style','pushbutton','position',[315 68 100 27],...
    'string','OK','callback','global ModelOut ModelIn; [ModelOut.model.xfactors{1},ModelOut.model.xfactors{2}] = resol1;ModelOut.info.direction=pursp;,ModelOut.info.objsel=objsel;set(findobj(''type'',''figure'',''userdata'',''Cubatch''),''waitstatus'',''close'');delete(gcbf);return;','fontname','Helvetica','fontsize',10);
uicontrol(gcf,'style','pushbutton','position',[315 31 100 27],...
    'string','Quit','callback',['delete(gcbf),clear global ed_tuni;global ModelOut;ModelOut = [];clear l_obj ic;set(findobj(''type'',''figure'',''userdata'',''Cubatch''),''waitstatus'',''close'')'],'fontname','Helvetica','fontsize',10);



