function opasplot(typ,spl,mi,mo,c,d);
% typ: 'gra','mod','exv','res','xmo'
%  spl for PlotStr structure
%  mi for ModelIn structure
%  mo for ModelOut structure
%  c for content object
%  d is the CBdataset object

Guinames

global ModelIn ModelOut

truc=getappdata(findobj('type','figure','userdata','Cubatch'),'X');

if isempty(ModelOut.prediction.data)
    
    
    if nargin==6,
        X=d{1}.data;
    end;
    wic=[0.5029 0.5814 0.6402];
    lbc=[0.9 0.93 0.95];
    frc=[0.3529 0.4314 0.4902];
    
    ModelIn.nbfactors.min(1)=size(ModelOut.info.objsel,2);
    ModelIn.nbfactors.min(2)=size(ModelOut.info.objsel,2);
    ModelIn.nbfactors.min(3)=size(ModelOut.info.objsel,2);
    
    if typ=='gra',
        h=findobj('tag','opasplot');%verification of non-existing tag
        if ~isempty(h),  
            delete(h);
        end;
        wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',spl)'');opasplot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
        if length(spl.nummode)>1,
            nom=['Modes ', int2str(spl.nummode(1)),'x', int2str(spl.nummode(2)),' - ',int2str(spl.plotdims),'D plots'];
            for i=1:mi.nbfactors.min(spl.nummode(1))*mi.nbfactors.min(spl.nummode(2)),
                st{i}=['CP',int2str(i)];
            end;
        else,
            nom=['Mode ', int2str(spl.nummode),' - ',int2str(spl.plotdims),'D plots'];
            st={};
            for i=1:ModelIn.nbfactors.min,
                st{i}=['CP',int2str(i)];
            end;
            st{ModelIn.nbfactors.min(spl.nummode)+1}='All';
        end;
        
        h0 = figure('MenuBar','none', 'Name',nom, 'MenuBar','none', 'NumberTitle','off', 'Position',[400 300 320 320], 'color',wic,'Tag','opasplot','toolbar','none');
        h1 = uimenu('Parent',h0,'Label','&Tools','Tag','toolp');
        h2 = uimenu('Parent',h1,'Label','&Process control');
        h3 = uimenu('Parent',h2,'Label','&Hotelling''s T2');
        h3 = uimenu('Parent',h2,'Label','&Potential functions');
        h1 = uimenu('Parent',h0,'Label','&Preferences','Tag','prefp');
        h2 = uimenu('Parent',h1,'Label','&Color');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''b'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','b','Label','&Blue');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''r'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','r','Label','&Red');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''g'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','g','Label','&Green');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''m'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','m','Label','&Magenta');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''c'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','c','Label','&Cyan');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''k'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','k','Label','&Black');
        set(findobj('tag',spl.color),'checked','on');
        h2 = uimenu('Parent',h1,'Label','&Marker');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''^'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','^','Label','Triangle');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''p'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','p','Label','Pentagram');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''d'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','d','Label','Diamond');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''*'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','*','Label','Star (*)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''o'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','o','Label','Circle (o)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','.','Label','Point (.)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''+'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','+','Label','Plus (+)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''none'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','none','Label','None');
        set(findobj('tag',spl.marker),'checked','on');
        h2 = uimenu('Parent',h1,'Label','&Line style');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''-'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','-','Label','Solid (-)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle='''':'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag',':','Label','Dotted (:)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''-.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','-.','Label','Dashdotted (-.)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''--'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','--','Label','Dashed (--)');
        set(findobj('tag',spl.linestyle),'checked','on');
        h2 = uimenu('Parent',h1,'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.grid=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.grid=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')','tag','grid','separator','on','Label','&Grid');
        if strcmp(spl.grid,'on'),
            set(findobj('tag','grid'),'checked','on');
        end;
        if isequal(spl.plotdims,3),
            h2 = uimenu('Parent',h1,'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.additional.shadow=1;set(gcbo,''''checked'''',''''on'''');else spl.additional.shadow=0;set(gcbo,''''checked'''',''''off'''');end;'')','tag','shadow','Label','&Shadow');
            if isequal(spl.additional.shadow,1),
                set(findobj('tag','shadow'),'checked','on');
            end;
        end;
        h2 = uimenu('Parent',h1,'Label','&Visible','callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.visible=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.visible=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')','Tag','vispca');
        if strcmp(spl.visible,'on'),
            set(findobj('tag','vispca'),'checked','on');
        end;
        
        if spl.nummode==2
            
            cb0='evalin(''caller'',''spl.additional.batch=get(gcbo,''''value'''');'')';
            
            h1=uimenu('Parent',h0,'Label','&Help','Tag','helpopasplot');
            h1=uicontrol('parent', h0,'tag','clo','string','Close','callback','close(gcf);','fontsize',12,'backgroundcolor',[0.7 0.7 0.7],'position',[170 30 130 30],'tooltipstring','close ','style','pushbutton');  
            h1=uicontrol('parent', h0,'tag','sta','string','OK','fontsize',12,'callback',wp,'backgroundcolor',[0.7 0.7 0.7],'position',[10 30 130 30],'tooltipstring','','style','pushbutton');
            h1=uicontrol('Parent',h0,'style','text','backgroundcolor',wic,'Position',[0 247 290 41]);
            h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 160 240 66],'style','frame');
            h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 110 240 30],'style','frame');
            h1=uicontrol('parent', h0,'string','Format:','fontsize',12,'backgroundcolor',frc,'position',[25 114 60 20],'style','text');
            h1=uicontrol('parent', h0,'tag','aster','string',{'Integer','Label','Marker'},'fontsize',12,'value',spl.format(1),'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[85 117 70 20],'tooltipstring','','style','popupmenu');
            h1=uicontrol('parent', h0,'tag','condis','string',{'Continuous','Discrete'},'value',spl.format(2),'fontsize',12,'callback','evalin(''caller'',''spl.format(2)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[160 117 90 20],'tooltipstring','','style','popupmenu');
        else
            h1=uimenu('Parent',h0,'Label','&Help','Tag','helpopasplot');
            h1=uicontrol('parent', h0,'tag','clo','string','Close','callback','close(gcf);','fontsize',12,'backgroundcolor',[0.7 0.7 0.7],'position',[170 30 130 30],'tooltipstring','close ','style','pushbutton');  
            h1=uicontrol('parent', h0,'tag','sta','string','OK','fontsize',12,'callback',wp,'backgroundcolor',[0.7 0.7 0.7],'position',[10 30 130 30],'tooltipstring','','style','pushbutton');
            h1=uicontrol('Parent',h0,'style','text','backgroundcolor',wic,'Position',[0 247 290 41]);
            h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 160 240 66],'style','frame');
            h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 110 240 30],'style','frame');
            h1=uicontrol('parent', h0,'string','Format:','fontsize',12,'backgroundcolor',frc,'position',[25 114 60 20],'style','text');
            h1=uicontrol('parent', h0,'tag','aster','string',{'Integer','Label','Marker'},'fontsize',12,'value',spl.format(1),'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[85 117 70 20],'tooltipstring','','style','popupmenu');
            h1=uicontrol('parent', h0,'tag','condis','string',{'Continuous','Discrete'},'value',spl.format(2),'fontsize',12,'callback','evalin(''caller'',''spl.format(2)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[160 117 90 20],'tooltipstring','','style','popupmenu');
        end;
        cb1='evalin(''caller'',''spl.factors(1)=get(gcbo,''''value'''');'')';
        cb2='evalin(''caller'',''spl.factors(2)=get(gcbo,''''value'''');'')';
        cb3='evalin(''caller'',''spl.factors(3)=get(gcbo,''''value'''');'')';
        mini=min(ModelIn.nbfactors.min);
        if spl.factors(1)>mini,
            spl.factors(1)=1;
        end;
        if spl.factors(2)>mini,
            spl.factors(2)=2;
        end;
        if spl.factors(3)>mini,
            spl.factors(3)=3;
        end;
        switch spl.plotdims,
            case 1
                h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb1,'Position',[120 230 50 50],'backgroundcolor',lbc,'value',spl.factors(1),'string',st,'Tag','1d1');
            case 2,     
                h1 = uicontrol('Parent',h0,'style','popupmenu','Position',[70 230 50 50],'callback',cb1,'value',spl.factors(1),'backgroundcolor',lbc,'string',st,'Tag','2d1');
                h1 = uicontrol('Parent',h0,'style','popupmenu','Position',[170 230 50 50],'value',spl.factors(2),'callback',cb2,'backgroundcolor',lbc,'string',st,'Tag','2d2');
                h1 = uicontrol('Parent',h0,'style','text','Position',[120 258 50 19],'backgroundcolor',wic,'Tag','tool');
            case 3,
                h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb1,'Position',[30 230 50 50],'value',spl.factors(1),'backgroundcolor',lbc,'string',st,'Tag','3d1');
                h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb2,'Position',[130 230 50 50],'backgroundcolor',lbc,'string',st,'Tag','3d2');
                h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb3,'Position',[230 230 50 50],'backgroundcolor',lbc,'value',spl.factors(3),'string',st,'Tag','3d3');
                h1 = uicontrol('Parent',h0,'style','text','Position',[80 258 50 19],'string','versus','backgroundcolor',wic,'Tag','tool');
                h1 = uicontrol('Parent',h0, 'style','text','Position',[180 258 50 19],'backgroundcolor',wic,'string','versus','Tag','tool');
        end;
        
        h=findobj('tag','opasplot');
        set(h,'waitstatus','open');
        waitfor(h,'waitstatus','close');
    else %    (graphiques)
        if ~isempty(spl),
            setcvdata(1,'PlotStr',spl);
        end;
        h=findobj('tag','opasplot');
        delete(findobj('tag','textfig'));
        cc=struct(c{1});
        hfig=1;
        set(0,'currentfigure',hfig);
        
        delete(gca);
        delete(findobj('tag','cbaxes'));
        
        hhh=axes('parent',1);
        cop=get(gca,'colororder');
        [tacop,rr]=size(cop);
        set(hhh,'position',[0.3,0.11,0.685,0.815]);
        Xi=ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2};
        
        vexp=100*sum(Xi(:).^2)/sum(sum(ModelOut.data.dataset{1}.data(:).^2));
        
        ModelOut.model.xev=vexp;
        cen='Centering:[';
        sca='Scaling:[';
        
        switch typ  % different kinds of graphics
            
            case 'mod'  % 123-D plots
                dim=cc.dims;
                dimt=[0 0 0 0 0 0 0 0 0 0 0 0]; 
                nt=length(spl.batch);
                coul=3;%color(nt);
                A=ModelOut.model.xfactors{spl.nummode};
                [a,b]=size(A);
                mi.valmethod.bootstrap=0;
                
                switch mi.valmethod.bootstrap,
                    case 0,   %No bootstrap
                        switch spl.plotdims
                            case 1,
                                if spl.nummode==1
                                    if  spl.factors(1)< b+1,
                                        plot(A(:,spl.factors(1)),'tag','plo','color',spl.color);
                                        set(gca,'Xlim',[1,size(A(:,spl.factors(1)),1)])
                                    else
                                        plot(A,'tag','plo');
                                        set(gca,'Xlim',[1,size(A,1)])
                                    end
                                else
                                    if  spl.factors(1)< a+1
                                        plot(A(spl.factors(1),:),'color',spl.color,'tag','plo');
                                        set(gca,'Xlim',[1,size(A(spl.factors(1),:),2)])
                                    else
                                        plot(A','tag','plo')
                                        set(gca,'Xlim',[1,size(A,2)])
                                    end;
                                end;
                                switch spl.format(1),
                                    case 1 %integer
                                        set(findobj('tag','plo'),'marker','none');
                                        if spl.nummode==1
                                            if  spl.factors(1)< b+1,
                                                for i=1:a,
                                                    text(i,A(i,spl.factors(1)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                end;
                                            else
                                                for j=1:b
                                                    for i=1:a,
                                                        text(i,A(i,j),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;
                                            end;
                                        else
                                            if  spl.factors(1)< a+1,
                                                for i=1:b,
                                                    text(i,A(spl.factors(1),i),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                end;
                                            else
                                                for j=1:a
                                                    for i=1:b,
                                                        text(i,A(j,i),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;
                                            end;
                                        end;
                                        %%%%%NEW LABELS
                                    case 2 %labels
                                        set(findobj('tag','plo'),'marker','none');
                                        if spl.nummode==1
                                            if  spl.factors(1)< b+1,
                                                for i=1:a,
                                                    text(i,A(i,spl.factors(1)),c{1}.labels{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                end;
                                            else
                                                for j=1:b
                                                    for i=1:a,
                                                        text(i,A(i,j),c{1}.labels{spl.nummode}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;
                                            end;
                                        else
                                            if  spl.factors(1)< a+1,
                                                for i=1:b,
                                                    text(i,A(spl.factors(1),i),c{1}.labels{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                end;
                                            else
                                                for j=1:a
                                                    for i=1:b,
                                                        text(i,A(j,i),c{1}.labels{spl.nummode}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                    end; 
                                                end;
                                            end;
                                        end;
                                    case 3 %marker
                                end;
                                hold on;
                                if dimt(spl.nummode)>0,
                                    plot(dim(spl.nummode)+1:dim(spl.nummode)+dimt(spl.nummode),s.Fproj{spl.nummode}(:,spl.factors(1)),'r*');
                                end;
                                hold off;
                            case 2,
                                if length(spl.nummode)<2,
                                    plot(A(spl.factors(1),:),A(spl.factors(2),:),'color',spl.color,'tag','plo');
                                    set(gca,'Xlim',[1,size(A(spl.factors(1),:),2)])
                                    grid on
                                else
                                    for j=1:a1,
                                        plot(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                                        set(gca,'Xlim',[1,size(A((j-1)*a2+1:j*a2,spl.factors(1)),2)])
                                        hold on;
                                    end;
                                end;
                                switch spl.format(1)
                                    case 1 %integer
                                        if length(spl.nummode)<2,
                                            if spl.nummode == 3,
                                                for i=1:a,
                                                    text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                end;
                                            else
                                                if spl.nummode == 2
                                                    for i=1:size(A,2),
                                                        text(A(spl.factors(1),i),A(spl.factors(2),i),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                    
                                                else
                                                    for i=1:dim(spl.nummode),
                                                        text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                end;
                                            end;
                                        else %mixed modes
                                            for i=1:a2
                                                for j=1:a1,
                                                    text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                end; 
                                            end;               
                                        end;
                                    case 2,%label
                                        set(findobj('tag','plo'),'marker','none');
                                        if length(spl.nummode)<2
                                            for i=1:dim(spl.nummode),
                                                if spl.nummode == 3,
                                                    for i=1:a,
                                                        text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    if spl.nummode == 2
                                                        for i=1:size(A,2),
                                                            text(A(spl.factors(1),i),A(spl.factors(2),i),c{1}.labels{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    else
                                                        for i=1:dim(spl.nummode+1),
                                                            text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                        end;
                                                    end;
                                                end;
                                            end;
                                        end;
                                    case 3 %marker
                                        
                                end;
                                
                                hold on;
                                if dimt(spl.nummode)>0,
                                    plot(s.Fproj{spl.nummode}(:,spl.factors(1)),mo.prediction.xfactors{spl.nummode}(:,spl.factors(2)),'r*');
                                end;   
                                hold off;
                            case 3,
                                if length(spl.nummode)<2,
                                    plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',spl.color,'tag','plo');
                                else,
                                    for j=1:a1,
                                        plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                                        hold on;
                                    end;
                                end;
                                switch spl.format(1)
                                    case 1 %integer
                                        set(findobj('tag','plo'),'marker','none');
                                        if length(spl.nummode)<2,
                                            if spl.nummode == 3,
                                                for j=1:a,
                                                    text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                end;
                                            else
                                                if spl.nummode == 2
                                                    for j=1:size(A,1),
                                                        text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    for j=1:dim(spl.nummode+1),
                                                        text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),int2str(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                end;
                                            end;
                                        else
                                            for i=1:a2
                                                for j=1:a1,
                                                    text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),A((j-1)*a2+i,spl.factors(3)),int2str(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                end; 
                                            end;                  
                                        end;                 
                                    case 2,%label
                                        set(findobj('tag','plo'),'marker','none');
                                        if length(spl.nummode)<2,
                                            if spl.nummode == 3,
                                                for j=1:a,
                                                    text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),c{1}.labels{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                end;
                                            else
                                                if spl.nummode == 2
                                                    for j=1:size(A,1),
                                                        text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),c{1}.labels{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                else
                                                    for j=1:dim(spl.nummode+1),
                                                        text(A(j,spl.factors(1)),A(j,spl.factors(2)),A(j,spl.factors(3)),c{1}.labels{spl.nummode}(j),'fontsize',7,'color',spl.color,'tag','plo2');
                                                    end;
                                                end;
                                            end;
                                        else
                                            for i=1:a2
                                                for j=1:a1,
                                                    text(A((j-1)*a2+i,spl.factors(1)),A((j-1)*a2+i,spl.factors(2)),A((j-1)*a2+i,spl.factors(3)),c{1}.labels{spl.nummode(2)}(i),'fontsize',7,'color',cop(mod(j+tacop-1,tacop)+1,:),'tag','plo2');
                                                end; 
                                            end;                  
                                        end;
                                    case 3 %marker
                                        
                                end;
                                
                                
                                hold on;
                                if dimt(spl.nummode)>0,
                                    plot3(s.Fproj{spl.nummode}(:,spl.factors(1)),s.Fproj{spl.nummode}(:,spl.factors(2)),s.Fproj{spl.nummode}(:,spl.factors(3)),'r*');
                                end;
                                if isequal(spl.additional.shadow, 1),
                                    axe=axis;
                                    if length(spl.nummode)<2,
                                        plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),axe(5)*ones(dim(spl.nummode),1),'color',[0.7 0.7 0.7],'tag','plo2');
                                        plot3(A(:,spl.factors(1)),axe(4)*ones(dim(spl.nummode),1),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                        plot3(axe(2)*ones(dim(spl.nummode),1),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                        plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',spl.color,'tag','plo');
                                    else
                                        for j=1:a1,
                                            plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),axe(5)*ones(dim(spl.nummode(2)),1),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),axe(4)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(axe(2)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                                            plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                                        end;
                                    end;
                                end;
                                
                                hold off;
                        end;
                        if spl.format(1)==3,
                            set(findobj('tag','plo'),'marker',spl.marker);
                        end;
                        set(findobj('tag','plo'),'linestyle',spl.linestyle);
                        
                        switch spl.format(2)
                            case 2 %discrete
                                set(findobj('tag','plo'),'linestyle','none');
                            case 1% continuous
                        end;
                        
                    case 1,   %Naive bootstrap
                        % Not implemented in OPA
                    case 2,   %Residual bootstrap opasplot
                        % Not implemented in OPA
                end; %switch s.bootstrap
                if length(spl.nummode)>1 |spl.factors(1)> b,
                    xl=['PC',int2str(spl.factors(1))];
                    if spl.factors(1)> b,
                        xl=[truc{1}.modenames{spl.nummode},' - All PC'];
                    end;
                else
                    xl=[truc{1}.modenames{spl.nummode},' - PC',int2str(spl.factors(1))];
                    
                end;
                xlabel(xl,'tag','xlab');
                if spl.nummode==1
                    ylabel('Relative concentrations','tag','ylab');
                else
                    ylabel('Absorbances','tag','ylab');
                end
                
                if spl.plotdims>1
                    if length(spl.nummode)>1|spl.factors(1)> b,
                        yl=['PC',int2str(spl.factors(2))];
                    else
                        yl=['PC',int2str(spl.factors(2))];
                    end;
                    ylabel(yl,'tag','ylab');
                    if spl.plotdims>2,
                        if length(spl.nummode)>1|spl.factors(1)> b,
                            zl=['PC',int2str(spl.factors(3))];
                        else
                            zl=['PC',int2str(spl.factors(3))];
                        end;
                        zlabel(zl,'tag','zlab');
                    end;
                end;
                if length(spl.nummode)<2,
                    titre=['Mode ',int2str(spl.nummode)];
                else,
                    titre=['Modes ',int2str(spl.nummode(1)),'x',int2str(spl.nummode(2))];
                end;
                title(titre);
                hold off;
                set(gca,'Xgrid',spl.grid,'Ygrid',spl.grid,'Zgrid',spl.grid);
                set(findobj('tag','plo'),'visible',spl.visible);
                set(findobj('tag','plo2'),'visible',spl.visible);
            case 'mea'
                X=getappdata(findobj('type','figure','userdata','Cubatch'),'X');
                seb=X{1}.data;
                plot(mean(seb))
                set(gca,'Xlim',[1,size(seb,2)])
                title('Mean Spectrum of X')
                xlabel(truc{1}.modenames{2});
                ylabel('Absorbance');
                grid on;
            case 'res',
                X=getappdata(findobj('type','figure','userdata','Cubatch'),'X');
                seb=X{1}.data;
                [sel,ok]=listdlg('liststring',mi.samlabs.labels,'name',['Residuals'],...
                    'selectionmode','single','promptstring',['Choose between ',mi.samlabs.name]);
                if ok==1,
                    Res=(seb-(ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2}));
                    plot(Res(sel,:)');
                    set(gca,'Xlim',[1,size(Res(sel,:),2)])
                    grid on;
                    title(['Residuals for ',mi.samlabs.labels{sel}]);
                    xlabel(truc{1}.modenames{2});
                else
                    Res=(seb-(ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2}));
                    surf(Res');
                    title('Residuals for all samples');
                    xlabel(truc{1}.modenames{1});
                    ylabel(truc{1}.modenames{2});
                end;
                
            case 'all',
                X=getappdata(findobj('type','figure','userdata','Cubatch'),'X');
                seb=X{1}.data;
                Res=(seb-(ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2}));
                surf(Res');
                title('Residuals for all samples');
                xlabel(truc{1}.modenames{1});
                ylabel(truc{1}.modenames{2});         
            case 'xmo',
                X=getappdata(findobj('type','figure','userdata','Cubatch'),'X');
                seb=X{1}.data;
                [sel,ok]=listdlg('liststring',mi.samlabs.labels,'name',['Model'],...
                    'selectionmode','single','promptstring',['Choose between ',mi.samlabs.name]);
                if ok==1,
                    mod=(ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2});
                    plot(mod(sel,:)');
                    set(gca,'Xlim',[1,size(mod(sel,:),2)])
                    grid on;
                    title(['Model for ',mi.samlabs.labels{sel}]);
                    xlabel(truc{1}.modenames{2});
                else
                    mod=(ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2});
                    surf(mod');
                    title('Model for all samples');
                    xlabel(truc{1}.modenames{1});
                    ylabel(truc{1}.modenames{2});
                end;
            case 'alm',
                mod=(ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2});
                surf(mod');
                title('Model for all samples');
                xlabel(truc{1}.modenames{1});
                ylabel(truc{1}.modenames{2});
            case 'exv' % Explained variation
                barh(mo.model.xev);
                set(gca,'ydir','reverse');
                xlabel('Explained Variation (%)');
                ylabel('PC');
        end;  %switch type
        hold off;
        
        set(gca,tg,'cbaxes');
        OPADisplayInfo(gcbf,ModelOut)
        
    end;  %graphiques
    
else
    %truc=[];
    truc=getappdata(findobj('type','figure','userdata','Cubatch'),'X');
    delete(gca);
    delete(findobj('tag','cbaxes'));
    hhh=axes('parent',1);
    cop=get(gca,'colororder');
    [tacop,rr]=size(cop);
    set(hhh,'position',[0.3,0.11,0.685,0.815]);
    plot(1,1,'tag','plo');
    text(0.10,1.75,'It is recommended to apply OPA 3D to make a model','fontsize',14,'color','red');
    text(0.10,1.60,'if the aim is to predict concentration profiles.','fontsize',14,'color','red');
    text(0.10,1.20,'Coefficients would be more representative and more robust','fontsize',14);
    text(0.10,1.00,'if coming from several batches.','fontsize',14);
    text(0.10,0.60,'You can anyway view some projections.','fontsize',14,'color','red');
    set(gca,tg,'cbaxes');
    
    
    wic=[0.5029 0.5814 0.6402];
    lbc=[0.9 0.93 0.95];
    frc=[0.3529 0.4314 0.4902];
    
    
    if typ=='gra',
        h=findobj('tag','opasplot');%verification de non doublure
        if ~isempty(h),  
            delete(h);
        end;
        wp=['evalin(''caller'',''setappdata(1,''''PlotStr'''',spl)'');opasplot(''mod'',getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''PlotStr''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Model''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Results''),getappdata(findobj(''type'',''figure'',''userdata'',''Cubatch''),''Content''));'];
        if length(spl.nummode)>1,
            nom=['Modes ', int2str(spl.nummode(1)),'x', int2str(spl.nummode(2)),' - ',int2str(spl.plotdims),'D plots'];
            for i=1:mi.nbfactors.min(spl.nummode(1))*mi.nbfactors.min(spl.nummode(2)),
                st{i}=['CP',int2str(i)];
            end;
        else,
            nom=['Mode ', int2str(spl.nummode),' - ',int2str(spl.plotdims),'D plots'];
            st={};
            for i=1:ModelIn.nbfactors.min,
                st{i}=['CP',int2str(i)];
            end;
            if length(ModelIn.nbfactors.min)==1
                st{ModelIn.nbfactors.min+1}='All';
            else
                st{ModelIn.nbfactors.min(spl.nummode)+1}='All';
            end;
        end;
        
        h0 = figure('MenuBar','none', 'Name',nom, 'MenuBar','none', 'NumberTitle','off', 'Position',[400 300 320 320], 'color',wic,'Tag','opasplot','toolbar','none');
        h1 = uimenu('Parent',h0,'Label','&Tools','Tag','toolp');
        h2 = uimenu('Parent',h1,'Label','&Process control');
        h3 = uimenu('Parent',h2,'Label','&Hotelling''s T2');
        h3 = uimenu('Parent',h2,'Label','&Potential functions');
        h1 = uimenu('Parent',h0,'Label','&Preferences','Tag','prefp');
        h2 = uimenu('Parent',h1,'Label','&Color');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''b'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','b','Label','&Blue');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''r'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','r','Label','&Red');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''g'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','g','Label','&Green');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''m'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','m','Label','&Magenta');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''c'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','c','Label','&Cyan');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.color=''''k'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','k','Label','&Black');
        set(findobj('tag',spl.color),'checked','on');
        h2 = uimenu('Parent',h1,'Label','&Marker');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''^'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','^','Label','Triangle');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''p'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','p','Label','Pentagram');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''d'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','d','Label','Diamond');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''*'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','*','Label','Star (*)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''o'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','o','Label','Circle (o)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','.','Label','Point (.)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''+'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','+','Label','Plus (+)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.marker=''''none'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','none','Label','None');
        set(findobj('tag',spl.marker),'checked','on');
        h2 = uimenu('Parent',h1,'Label','&Line style');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''-'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','-','Label','Solid (-)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle='''':'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag',':','Label','Dotted (:)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''-.'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','-.','Label','Dashdotted (-.)');
        h3 = uimenu('Parent',h2,'callback','evalin(''caller'',''spl.linestyle=''''--'''';'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');','tag','--','Label','Dashed (--)');
        set(findobj('tag',spl.linestyle),'checked','on');
        h2 = uimenu('Parent',h1,'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.grid=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.grid=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')','tag','grid','separator','on','Label','&Grid');
        if strcmp(spl.grid,'on'),
            set(findobj('tag','grid'),'checked','on');
        end;
        h2 = uimenu('Parent',h1,'Label','&Visible','callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.visible=''''on'''';set(gcbo,''''checked'''',''''on'''');else spl.visible=''''off'''';set(gcbo,''''checked'''',''''off'''');end;'')','Tag','vispca');
        if strcmp(spl.visible,'on'),
            set(findobj('tag','vispca'),'checked','on');
        end;
        
        if spl.nummode==2
            
            cb0='evalin(''caller'',''spl.additional.batch=get(gcbo,''''value'''');'')';
            h1=uimenu('Parent',h0,'Label','&Help','Tag','helpopasplot');
            h1=uicontrol('parent', h0,'tag','clo','string','Close','callback','close(gcf);','fontsize',12,'backgroundcolor',[0.7 0.7 0.7],'position',[170 30 130 30],'tooltipstring','close ','style','pushbutton');  
            h1=uicontrol('parent', h0,'tag','sta','string','OK','fontsize',12,'callback',wp,'backgroundcolor',[0.7 0.7 0.7],'position',[10 30 130 30],'tooltipstring','','style','pushbutton');
            h1=uicontrol('Parent',h0,'style','text','backgroundcolor',wic,'Position',[0 247 290 41]);
            h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 160 240 66],'style','frame');
            h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 110 240 30],'style','frame');
            h1=uicontrol('parent', h0,'string','Format:','fontsize',12,'backgroundcolor',frc,'position',[25 114 60 20],'style','text');
            h1=uicontrol('parent', h0,'tag','aster','string',{'Integer','Label','Marker'},'fontsize',12,'value',spl.format(1),'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[85 117 70 20],'tooltipstring','','style','popupmenu');
            h1=uicontrol('parent', h0,'tag','condis','string',{'Continuous','Discrete'},'value',spl.format(2),'fontsize',12,'callback','evalin(''caller'',''spl.format(2)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[160 117 90 20],'tooltipstring','','style','popupmenu');
        else
            h1=uimenu('Parent',h0,'Label','&Help','Tag','helpopasplot');
            h1=uicontrol('parent', h0,'tag','clo','string','Close','callback','close(gcf);','fontsize',12,'backgroundcolor',[0.7 0.7 0.7],'position',[170 30 130 30],'tooltipstring','close ','style','pushbutton');  
            h1=uicontrol('parent', h0,'tag','sta','string','OK','fontsize',12,'callback',wp,'backgroundcolor',[0.7 0.7 0.7],'position',[10 30 130 30],'tooltipstring','','style','pushbutton');
            h1=uicontrol('Parent',h0,'style','text','backgroundcolor',wic,'Position',[0 247 290 41]);
            h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 160 240 66],'style','frame');
            h1=uicontrol('parent', h0,'backgroundcolor',frc,'position',[20 110 240 30],'style','frame');
            h1=uicontrol('parent', h0,'string','Format:','fontsize',12,'backgroundcolor',frc,'position',[25 114 60 20],'style','text');
            h1=uicontrol('parent', h0,'tag','aster','string',{'Integer','Label','Marker'},'fontsize',12,'value',spl.format(1),'callback','evalin(''caller'',''spl.format(1)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[85 117 70 20],'tooltipstring','','style','popupmenu');
            h1=uicontrol('parent', h0,'tag','condis','string',{'Continuous','Discrete'},'value',spl.format(2),'fontsize',12,'callback','evalin(''caller'',''spl.format(2)=get(gcbo,''''value'''');'');','backgroundcolor',lbc,'position',[160 117 90 20],'tooltipstring','','style','popupmenu');
        end;
        cb1='evalin(''caller'',''spl.factors(1)=get(gcbo,''''value'''');'')';
        cb2='evalin(''caller'',''spl.factors(2)=get(gcbo,''''value'''');'')';
        cb3='evalin(''caller'',''spl.factors(3)=get(gcbo,''''value'''');'')';
        mini=min(ModelIn.nbfactors.min);
        if spl.factors(1)>mini,
            spl.factors(1)=1;
        end;
        if spl.factors(2)>mini,
            spl.factors(2)=2;
        end;
        if spl.factors(3)>mini,
            spl.factors(3)=3;
        end;
        switch spl.plotdims,
            case 1
                h1 = uicontrol('Parent',h0,'style','popupmenu','callback',cb1,'Position',[120 230 50 50],'backgroundcolor',lbc,'value',spl.factors(1),'string',st,'Tag','1d1');
            case 2,     
                h1 = uicontrol('Parent',h0,'style','popupmenu','Position',[70 230 50 50],'callback',cb1,'value',spl.factors(1),'backgroundcolor',lbc,'string',st,'Tag','2d1');
                h1 = uicontrol('Parent',h0,'style','popupmenu','Position',[170 230 50 50],'value',spl.factors(2),'callback',cb2,'backgroundcolor',lbc,'string',st,'Tag','2d2');
                h1 = uicontrol('Parent',h0,'style','text','Position',[120 258 50 19],'backgroundcolor',wic,'Tag','tool');
        end;
        
        h=findobj('tag','opasplot');
        set(h,'waitstatus','open');
        waitfor(h,'waitstatus','close');
    else %    (graphiques)
        if ~isempty(spl),
            setcvdata(1,'PlotStr',spl);
        end;
        h=findobj('tag','opasplot');
        delete(findobj('tag','textfig'));
        cc=struct(c{1});
        hfig=1;
        set(0,'currentfigure',hfig);
        
        delete(gca);
        delete(findobj('tag','cbaxes'));
        
        hhh=axes('parent',1);
        cop=get(gca,'colororder');
        [tacop,rr]=size(cop);
        set(hhh,'position',[0.3,0.11,0.685,0.815]);
        Xi=ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2};
        
        ModelOut.model.xev=100*sum(Xi(:).^2)/sum(sum(ModelOut.data.dataset{1}.data(:).^2));
        
        cen='Centering:[';
        sca='Scaling:[';
        
        switch typ  % different kinds of graphics
            
            case 'mod'  % 123-D plots
                
                dim=cc.dims;
                dimt=[0 0 0 0 0 0 0 0 0 0 0 0];
                nt=length(spl.batch);
                coul=3;%color(nt);
                
                A=ModelOut.model.xfactors{2};
                B=ModelOut.prediction.xpred{1};
                C=ModelOut.model.xpred{2};
                [a,b]=size(A);
                [e,d]=size(B);
                [f,g]=size(C);
                switch spl.plotdims
                    
                    case 1
                        if spl.nummode == 1
                            if spl.factors(1)==ModelIn.nbfactors.min+1
                                for i=1:ModelIn.nbfactors.min(1)
                                    plot(B(:,i),'color','red','tag','plo');
                                    set(gca,'Xlim',[1,size(B(:,i),1)])
                                    hold on
                                end
                            else
                                plot(B(:,spl.factors(1)),'color','red','tag','plo');
                                set(gca,'Xlim',[1,size(B(:,spl.factors(1)),1)])
                            end
                        else
                            if (spl.factors(1)~=a+1)
                                plot(A(spl.factors(1),:),'color','blue','tag','plo');
                                set(gca,'Xlim',[1,size(A(spl.factors(1),:),2)])
                            else
                                plot(A','color','blue','tag','plo');
                                set(gca,'Xlim',[1,size(A',1)])
                            end
                        end
                    case 2,
                        if spl.nummode == 1
                            if (spl.factors(1)~=g+1) & (spl.factors(2)~=g+1)
                                plot(C(:,spl.factors(1)),C(:,spl.factors(2)),'color','blue','tag','plo');
                                hold on
                                plot(B(:,spl.factors(1)),B(:,spl.factors(2)),'color','red','tag','plo');
                                hold off
                            else
                                h=findobj('tag','opasplot');
                                delete(h);
                                truc=warndlg({'It is not possible to plot the projection of new spectra','on all pure spectra at the same time.',' ','Interpretation would be useless'},'Not possible');
                            end
                        else
                        end
                end
                
                switch spl.format(1)
                    case 1 %integer
                        if length(spl.nummode)<2,
                            if spl.nummode == 3,
                                for i=1:a,
                                    text(A(i,spl.factors(1)),A(i,spl.factors(2)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                end;
                            else
                                if spl.nummode == 2
                                    if (spl.factors(1)~=g+1)
                                        for i=1:b
                                            text(i,A(spl.factors(1),i),int2str(i),'fontsize',7,'color','blue','tag','plo2');
                                        end
                                    else
                                        for j=1:a
                                            for i=1:b
                                                text(i,A(j,i),int2str(i),'fontsize',7,'color','blue','tag','plo2');
                                            end
                                        end
                                    end
                                else
                                    if spl.plotdims==1
                                        if spl.factors(1)~=ModelIn.nbfactors.min+1
                                            for i=1:e 
                                                text(i,B(i,spl.factors(1)),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                            end;
                                        else
                                            for j=1:ModelIn.nbfactors.min(1)
                                                for i=1:e 
                                                    text(i,B(i,j),int2str(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                end
                                            end
                                        end
                                    else
                                        if (spl.factors(1)~=ModelIn.nbfactors.min+1) & (spl.factors(2)~=ModelIn.nbfactors.min+1)
                                            for i=1:f
                                                text(C(i,spl.factors(1)),C(i,spl.factors(2)),int2str(i),'fontsize',7,'color','blue','tag','plo2');
                                                hold on
                                            end
                                            for i=1:e
                                                text(B(i,spl.factors(1)),B(i,spl.factors(2)),int2str(i),'fontsize',7,'color','red','tag','plo2');
                                            end
                                            hold off
                                        else
                                            h=findobj('tag','opasplot');
                                            delete(h);
                                            truc=warndlg({'It is not possible to plot the projection of new spectra','on all pure spectra at the same time.',' ','Interpretation would be useless'},'Not possible');
                                        end
                                    end
                                end
                                
                            end;
                        end;
                    case 2,%label
                        set(findobj('tag','plo'),'marker','none');
                        if length(spl.nummode)<2,
                            if spl.nummode == 3,
                                for i=1:a,
                                    text(A(i,spl.factors(1)),A(i,spl.factors(2)),c{1}.labels{spl.nummode-1}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                end;
                            else
                                if spl.nummode == 2
                                    if (spl.factors(1)~=g+1)
                                        for i=1:b
                                            text(i,A(spl.factors(1),i),c{1}.labels{spl.nummode}(i),'fontsize',7,'color','blue','tag','plo2');
                                        end
                                    else
                                        for j=1:a
                                            for i=1:b
                                                text(i,A(j,i),c{1}.labels{spl.nummode}(i),'fontsize',7,'color','blue','tag','plo2');
                                            end
                                        end
                                    end
                                else
                                    if spl.plotdims==1
                                        if spl.factors(1)~=ModelIn.nbfactors.min+1
                                            for i=1:e 
                                                text(i,B(i,spl.factors(1)),ModelOut.prediction.data.labels{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                            end;
                                        else
                                            for j=1:ModelIn.nbfactors.min(1)
                                                for i=1:e 
                                                    text(i,B(i,j),ModelOut.prediction.data.labels{spl.nummode}(i),'fontsize',7,'color',spl.color,'tag','plo2');
                                                end
                                            end
                                        end
                                    else
                                        if (spl.factors(1)~=ModelIn.nbfactors.min+1) & (spl.factors(2)~=ModelIn.nbfactors.min+1)
                                            for i=1:f
                                                text(C(i,spl.factors(1)),C(i,spl.factors(2)),c{1}.labels{spl.nummode}(i),'fontsize',7,'color','blue','tag','plo2');
                                                hold on
                                            end
                                            for i=1:e
                                                text(B(i,spl.factors(1)),B(i,spl.factors(2)),ModelOut.prediction.data.labels{spl.nummode}(i),'fontsize',7,'color','red','tag','plo2');
                                            end
                                            hold off
                                        else
                                            h=findobj('tag','opasplot');
                                            delete(h);
                                            truc=warndlg({'It is not possible to plot the projection of new spectra','on all pure spectra at the same time.',' ','Interpretation would be useless'},'Not possible');
                                        end
                                    end
                                end
                                
                            end;
                        end;
                    case 3 %marker
                        
                end;
                
                hold on;
                if dimt(spl.nummode)>0,
                    plot(s.Fproj{spl.nummode}(:,spl.factors(1)),mo.prediction.xfactors{spl.nummode}(:,spl.factors(2)),'r*');
                end;   
                hold off;
                hold on;
                if dimt(spl.nummode)>0,
                    plot3(s.Fproj{spl.nummode}(:,spl.factors(1)),s.Fproj{spl.nummode}(:,spl.factors(2)),s.Fproj{spl.nummode}(:,spl.factors(3)),'r*');
                end;
                if isequal(spl.additional.shadow, 1),
                    axe=axis;
                    if length(spl.nummode)<2,
                        plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),axe(5)*ones(dim(spl.nummode),1),'color',[0.7 0.7 0.7],'tag','plo2');
                        plot3(A(:,spl.factors(1)),axe(4)*ones(dim(spl.nummode),1),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                        plot3(axe(2)*ones(dim(spl.nummode),1),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                        plot3(A(:,spl.factors(1)),A(:,spl.factors(2)),A(:,spl.factors(3)),'color',spl.color,'tag','plo');
                    else
                        for j=1:a1,
                            plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),axe(5)*ones(dim(spl.nummode(2)),1),'color',[0.7 0.7 0.7],'tag','plo2');
                            plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),axe(4)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                            plot3(axe(2)*ones(dim(spl.nummode(2)),1),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'color',[0.7 0.7 0.7],'tag','plo2');
                            plot3(A((j-1)*a2+1:j*a2,spl.factors(1)),A((j-1)*a2+1:j*a2,spl.factors(2)),A((j-1)*a2+1:j*a2,spl.factors(3)),'tag','plo','color',cop(mod(j+tacop-1,tacop)+1,:));
                        end;
                    end;
                end;
                
                hold off;
                %end;
                if spl.format(1)==3,
                    set(findobj('tag','plo'),'marker',spl.marker);
                end;
                set(findobj('tag','plo'),'linestyle',spl.linestyle);
                
                switch spl.format(2)
                    case 2 %discrete
                        set(findobj('tag','plo'),'linestyle','none');
                    case 1% continuous
                end;
                
                xl=[truc{1}.modenames{spl.nummode},' - PC',int2str(spl.factors(1))];
                
                xlabel(xl,'tag','xlab');
                
                if spl.plotdims>1
                    if length(spl.nummode)>1|spl.factors(1)> b,
                        yl=['PC',int2str(spl.factors(2))];
                    else
                        yl=['PC',int2str(spl.factors(2))];
                    end;
                    ylabel(yl,'tag','ylab');
                    if spl.plotdims>2,
                        if length(spl.nummode)>1|spl.factors(1)> b,
                            zl=['PC',int2str(spl.factors(3))];
                        else
                            zl=['PC',int2str(spl.factors(3))];
                        end;
                        zlabel(zl,'tag','zlab');
                    end;
                end;
                titre=[{['Mode ',int2str(spl.nummode)],'X (model) in blue and X (new data) in red'}];
                title(titre);
                hold off;
                set(gca,'Xgrid',spl.grid,'Ygrid',spl.grid,'Zgrid',spl.grid);
                set(findobj('tag','plo'),'visible',spl.visible);
                set(findobj('tag','plo2'),'visible',spl.visible);
                
            case 'mea'
                X=getappdata(findobj('type','figure','userdata','Cubatch'),'X');
                seb=X{1}.data;
                plot(mean(seb),'b')
                set(gca,'Xlim',[1,size(seb,2)])
                hold on
                plot(mean(ModelOut.prediction.data.data),'r')
                title('Mean Spectrum of X (Model) in blue and Mean spectrum of X (New) in red')
                xlabel('Wavelengths');
                ylabel('Absorbance');
                grid on;
            case 'res',
                X=getappdata(findobj('type','figure','userdata','Cubatch'),'X');
                seb=X{1}.data;
                [sel,ok]=listdlg('liststring',mi.samlabs.labels,'name',['Residuals'],...
                    'selectionmode','single','promptstring',['Choose between ',mi.samlabs.name]);
                if ok==1,
                    Res=(seb-(ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2}));
                    plot(Res(sel,:)');
                    set(gca,'Xlim',[1,size(Res(sel,:),2)])
                    grid on;
                    title(['Residuals for ',mi.samlabs.labels{sel}]);
                else
                    Res=(seb-(ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2}));
                    surf(Res');
                    title('Residuals for all samples');
                end;
                
            case 'all',
                X=getappdata(findobj('type','figure','userdata','Cubatch'),'X');
                seb=X{1}.data;
                Res=(seb-(ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2}));
                surf(Res');
                title('Residuals for all samples');
            case 'xmo',
                X=getappdata(findobj('type','figure','userdata','Cubatch'),'X');
                seb=X{1}.data;
                [sel,ok]=listdlg('liststring',mi.samlabs.labels,'name',['Model'],...
                    'selectionmode','single','promptstring',['Choose between ',mi.samlabs.name]);
                if ok==1,
                    mod=(ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2});
                    plot(mod(sel,:)');
                    set(gca,'Xlim',[1,size(mod(sel,:),2)])
                    grid on;
                    title(['Model for ',mi.samlabs.labels{sel}]);
                else
                    mod=(ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2});
                    surf(mod');
                    title('Model for all samples');
                end;
            case 'alm',
                mod=(ModelOut.model.xfactors{1}*ModelOut.model.xfactors{2});
                surf(mod');
                title('Model for all samples');
        end;  %switch type
        hold off;
        
        set(gca,tg,'cbaxes');
        %if isempty(truc)
        OPADisplayInfo(gcbf,ModelOut)
        %end
        
    end;  %graphiques
    
    
    %-----------------------------------
end

