function OPAReport(MainFig,ReportStruct,Fil_id)
ModelOut = getcvdata(MainFig,'Results');
ModelIn  = getcvdata(MainFig,'Model');

if any(ReportStruct.m_info)
    
    %Model info and name
    fwrite(Fil_id,[10 'Model               : OPA' 10],'char');
    fwrite(Fil_id,['Number of factors   : '],                    'char');
    fwrite(Fil_id,[sprintf(' %i',[size(ModelOut.model.xfactors{1},2)]),10 10],'char');
    %Preprocessing. NB the different scalings are not distinguished
    fwrite(Fil_id,[   'Preprocessing'                 10],'char');
    fwrite(Fil_id,[   'Centring            : '   ],        'char');
    a = isempty(ModelOut.model.xpreproc.cen);
    fwrite(Fil_id,[int2str(~a(:)') 10],'char');
    fwrite(Fil_id,[   'Scaling             : '   ],        'char');
    a = isempty(ModelOut.model.xpreproc.scal);
    fwrite(Fil_id,[int2str(~a(:)') 10 10],'char');
    
    %Algorithm information
    
    fwrite(Fil_id,[10,'Algorithm (OPA-ALS)' 10],'char');
    fwrite(Fil_id,['Iterations              : '],                             'char');
    fwrite(Fil_id,[sprintf(' %i',[ModelIn.options.algorithm.maxiter]), 10],'char');
    fwrite(Fil_id,['Convergence criterion   : '],              'char'),     
    fwrite(Fil_id,[sprintf(' %i',[ModelOut.model.info.tolsigma]), 10, 10],'char');
    
    %Constraints
    
    fwrite(Fil_id,['Constraints'                   10],'char');
    fwrite(Fil_id,['Unimodality for concentrations profiles   :'                  ],'char');
    a = isempty(ModelOut.model.info.cuni);
    fwrite(Fil_id,[int2str(~a(:)') 10],'char');
    fwrite(Fil_id,['Tolerance limit                           :'                  ],'char');
    fwrite(Fil_id,[sprintf('%i',[ModelOut.model.info.tluni]), 10],'char');
    fwrite(Fil_id,['Closure for concentrations profiles       :'                  ],'char');
    a = isempty( ModelOut.model.info.cclo);
    fwrite(Fil_id,[int2str(~a(:)') 10],'char');
    fwrite(Fil_id,['Mean background                           :'                 ],'char');
    fwrite(Fil_id,[sprintf('%i',[ModelOut.model.info.mback]), 10],'char');
    fwrite(Fil_id,['Non negativity for spectral profiles      :'                 ],'char');
    a = isempty( ModelOut.model.info.spneg);
    fwrite(Fil_id,[int2str(~a(:)') 10],'char');
    
    %Model
    fwrite(Fil_id,[10,'Model (OPA)' 10],'char');
    
    fwrite(Fil_id,['Explained variance  : '],'char');
    fwrite(Fil_id,[sprintf('%3.2f%%',ModelOut.model.xev),10],  'char');
    
    fwrite(Fil_id,['Loadings Mode 1 :'                          10],'char');
    Mat = num2str(ModelOut.model.xfactors{1}(1:10,:));
    Mat = [Mat,10 * ones(size(Mat,1),1)]';
    fwrite(Fil_id,Mat,'char');
    fwrite(Fil_id,[10 10],'char');
    
    fwrite(Fil_id,['Loadings Mode 2 :'                          10],'char');
    Mat = num2str(ModelOut.model.xfactors{2}(:,1:10));   
    Mat = [Mat,10 * ones(size(Mat,1),1)]';
    fwrite(Fil_id,Mat,'char');
    fwrite(Fil_id,[10 10],'char');
       
end
