function ModelOut  = OPApply(ModelOut);

global ModelIn ModelOut X
Guinames

if length(ModelOut.model) ~= 1
    ListProp = {'selectionmode','single','name','Choose model','promptstring','Select the model to apply'};
    ReqTit   = 'Choose model';
    Cont     = cellstr(num2str(cat(1,ModelOut.model.nbfactors)));
    [RankPos,Ok] = listdlg('Liststring',Cont,ListProp{:});
    if ~Ok
        return
    end
end
ListProp          = {'selectionmode','single','name','Load array','promptstring','Select the array to load'};
ReqTit            = 'Load data';
try
    cd data
    [Xfil{2:-1:1}]    = uigetfile('*.mat',ReqTit);
    cd ..
catch
    [Xfil{2:-1:1}]    = uigetfile('*.mat',ReqTit);
end
RankPos           = 1;

if Xfil{1} ~= 0
    Cont = who('-file',[Xfil{:}]);
    Ok   = 1;
    Sel  = 1;
    if length(Cont) > 1
        [Sel,Ok] = listdlg('Liststring',Cont,ListProp{:});
    end
    if Ok
        Xt   = load([Xfil{:}],Cont{Sel});
        Xt   = getfield(Xt,Cont{Sel});
        
        if ~isempty(Xt)
            if iscell(Xt)
                if ~isa(Xt{1},'cbdataset'),
                    return;
                else
                    Xn=Xt{1};
                end
            else
                if isa(Xt,'cbdataset'),
                    Xn=Xt;
                else
                    Xn=cbdataset(Xt);
                end;
            end;
            
            if ndims(Xn) ~= length(ModelOut.model(RankPos).xfactors)
                errordlg({'The current model cannot be applied to this data set:','the dimensions are not compatible'})
                return
            else 
                DimX = size(Xn);
                DimM = size(ModelOut.data.dataset{1}.data);
                if DimX(2:end) ~= DimM(2:end)
                    errordlg({'The current model cannot be applied to this data set:','the dimensions are not compatible'})
                    return
                end
            end
        else
            return
        end
    else 
        return
    end
    ModelOut.prediction.data = Xn;
    clear Xn
    
    if ~isa(ModelOut.data.dataset{1},'cbdataset')
        bidule{1}=cbdataset(ModelOut.data.dataset);
        ModelOut.data.dataset=bidule;
    end
    
    DisplayInfo(gcbf,ModelOut.data.dataset);
    OPADisplayInfo(gcbf,ModelOut);
    [ModelIn,ModelOut]=opaactivateplots(ModelIn,ModelOut,X);
    
    ModelOut = OPAApplyModel(ModelOut);
    
end
return
