%
%   ############################################################
%    Function called from opa.m
% 
%    function opa3(da1,obj,var,iobj,objsel,pursp)
%
%
%    Author: Paqui Cuesta
%    Address: ChemoAC, V.U.B. , Laarbeeklaan 103,
%             B-1090  Brussel  Belgium
%    Date: 4.12.95
%    
%	  Modified by Sbastien Gourvnec to fit to the software
%	  designed in the frame of the NWAYQUAL Project
%	  Date: 25.07.02
%
%   ############################################################

function opa3(da1,obj,var,iobj,objsel,pursp)

global ModelIn ModelOut

col=length(var);
figure(2)

if pursp==1
    xlabel1='Wavelength';
    title1=['Spectrum at time ',num2str(obj(iobj))];
elseif pursp==2
    xlabel1='Time';
    title1=['Variable ',num2str(obj(iobj))];
end
subplot(221)
plot(var,da1(iobj,:))
ylabel('Absorbance')
xlabel(xlabel1)
title(title1)
mini=min(da1(iobj,:));
axis([var(1) var(col) mini-0.3*abs(mini) 1.1*max(da1(iobj,:))])
%
if ~isempty(objsel)
    tsi=sum(da1);
    coeff=tsi/da1(objsel,:);
    lsq=coeff*da1(objsel,:);
    res=sum((tsi-lsq).^2);
    rssq=sqrt(res/sum(tsi.^2));
    subplot(222)
    plot(var,tsi,'-g',var,lsq,'--r')
    xlabel(xlabel1)
    ylabel('Absorbance')
    title('tsi:___   ,  lsq approx: - - -')
    mini=min([tsi,lsq]);
    axis([var(1) var(col) mini-0.3*abs(mini) 1.1*max([tsi,lsq])])
    %
    lobjsel=length(objsel);
    uicontrol(gcf,'style','text','position',[280 140 100 20],...
        'string','Relative rssq :');
    uicontrol(gcf,'style','text','position',[380 140 80 20],...
        'string',num2str(rssq),'backgroundcolor',[0 .5 .5]);
    for ij=1:lobjsel
        uicontrol(gcf,'style','text','position',[280 120-ij*20 60 20],...
            'string',num2str(obj(objsel(ij))),...
            'backgroundcolor',[0 .5 .5]);
        uicontrol(gcf,'style','text','position',[340 120-ij*20 80 20],...
            'string',num2str(coeff(ij)));
    end
    
end
ginput(1);
close
