%
%   ############################################################
%    Orthogonal Projection Approach (OPA)
%    ref. F. Cuesta, Anal. Chem., in press
%
%    function opa(X,lrow,lcol)
%
%    Input:
%      X : data matrix, the rows contain the spectra
%      OPTIONAL
%      lrow : labels for the objects
%      lcol : labels for the variables
%  
%    Output:
%      C : concentration profiles
%      A : pure compund spectra
%
%    Author: Paqui Cuesta
%    Address: ChemoAC, V.U.B. , Laarbeeklaan 103,
%             B-1090  Brussel  Belgium
%    Date: 4.12.95
%    
%	  Modified by Sbastien Gourvnec to fit to the software
%	  designed in the frame of the NWAYQUAL Project
%	  Date: 25.07.02
%
%   ############################################################
%
%
function [C,A,pursp,objsel] = opa(X,lrow,lcol)

warning off

truc=getappdata(findobj('type','figure','userdata','Cubatch'),'X');

[C,A,pursp,objsel] = deal([]);

global da1 obj var means stds base weight stds2 iobj objsel pursp

da1=[]; obj=[];var=[];means=[];stds=[];base=[];weight=[];stds2=[];iobj=[];objsel=[];pursp=[];

global ModelOut ModelIn

ScSize = ScreenSize;
cbf = 'delete(gcbf)';
GUINames
VPos   = fix(.5*(ScSize(3) - 150));
HPos   = fix(.5*(ScSize(4) - 86));
Pos    = [VPos HPos 220 86]; %150 86
h      = figure('menubar','none','resize','off','unit','pixel','tag','window','numbertitle','off','name','Selection of','color',[0.5029 0.5814 0.6402],crf,cbf);
set(h,pos,Pos);

uicontrol(h,'style','pushbutton','position',[10 10 200 30],'string',['Pure modalities of:" ',truc{1}.modenames{2},' "'],'fontname','Helvetica','fontsize',10,'callback','pursp=2;set(gcbf,''waitstatus'',''close'')');
uicontrol(h,'style','pushbutton','position',[10 46 200 30],'string',['Pure modalities of:"',truc{1}.modenames{1},' "'],'fontname','Helvetica','fontsize',10,'callback','pursp=1;set(gcbf,''waitstatus'',''close'')');
waitfor(h,'waitstatus','close');
delete(h);

pursp=evalin('base','pursp');


if pursp == 1;da1=X;
elseif pursp == 2;da1=X;
end

[nrow,ncol]=size(da1);
if nargin == 1, 
    obj=[1:nrow]';var=[1:ncol];
end
if nargin == 2 
    if length(lrow) == nrow,obj=lrow;var=[1:ncol];
    elseif length(lrow) == ncol,obj=[1:nrow]';var=lrow;end
end
if nargin == 3 
    if pursp == 1, obj=lrow;var=lcol;
    elseif pursp == 2, obj=lcol;var=lrow;end
end

clear X lrow lcol

global da1 obj var means stds base weight stds2 iobj objsel pursp

if pursp==1
    str1='Mean and STD chromatogram';
    str2='Dissimilarity and corrected STD chromatogram';
    str3='Pure spectrum selected';
elseif pursp==2
    str1='Mean and STD spectrum';
    str2='Dissimilarity and corrected STD spectrum';
    str3='Pure variable selected';
end

h = cenwindow([0.5029 0.5814 0.6402],'Orthogonal Projection Approach (OPA)',[],560,500);

set(gca,'Position',[ 0.130357142857143 0.19 0.775 0.734 ]);

uimenu(gcf,'label','Reset',...
    'callback',['global objsel,l_obj=length(objsel);' ...
        'objsel=objsel(1:(l_obj-1));opa1']);

uicontrol('fontname','Helvetica','fontsize',10,'position',[74  18 200  30],'string',...
    'Select the maximum','callback',['global objsel iobj,' ...
        'objsel=[objsel,iobj];opa1']);
uicontrol('fontname','Helvetica','fontsize',10,'position',[308  18 200  30],'string',...
    'Resolve the data matrix','callback','global ModelOut ModelIn; [ModelOut.model.xfactors{1},ModelOut.model.xfactors{2},ModelOut.info.direction,ModelOut.info.objsel] = resol(1,0);');
objsel=[];
means=(mean(da1'))';
stds=(std(da1')*sqrt((ncol-1)/ncol))';
base=mean(da1);
ModelOut.modelname='OPA';
opa1

warning on