function ExportData(ModelIn)
% function ExportData (ModelIn);
% 
% Description:
% Exports a subset or the whole (the choice is made through a standard questdlg requester) of the
% current X data structure to a .mat file. The data are exported as cbdataset objects. The name of the
% variable within the saved file depends on the position of the original data array within the X data
% structure: it is 'X' if it was stored (even if the saved object is a subset) in X{1}; and 'Y'
% otherwise.
% 
% 
% Inputs: 
% ModelIn: ModelIn structure. The selections on both samples/batches and variables made in the main
%          section are not used here.
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% CuBatch
% 
% Subroutines:
% Internal: None
% External: cenwindow, definearray, selectsamples, selectvariables
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 26-Oct-2002 23:47:50
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 

X   = getappdata(ModelIn.xpointer,'X');
%Select all variables
for i = 1:length(X)
   for j = 1:ndims(X{i}) - 1
      ModelIn.var(i).sel{j}.sel = i;
   end
end
%Deselect all samples/batches
ModelIn.sam(1).sel.desel = [1,2];
Sel                      = 1:length(X);
Ok                       = 1;
if length(X) > 1
   for i = 1:length(X)
      List{i,1} = X{i}.name;
   end
   [Sel,Ok] = listdlg('liststring',List,'selectionmode','multiple','name','Select data',...
      'promptstring','Select the array(s) you want to save');
end   
if Ok
   Ans = questdlg('Do you want to export:','Export','Whole set','Sub set','Cancel','Whole set');
   switch Ans
      case 'Sub set'
         Dim = 1;
         while Dim
            h = cenwindow([0.5029 0.5814 0.6402],'Choose subset','set(gcbf,''waitstatus'',''close'',''userdata'',0)',170,40*(length(Sel) + 2)+10);
            set(h,'userdata',0,'toolbar','none')
            if length(Sel) == 1
               uicontrol('position',[10  90 150 30],'string','Samples',                 'callback',sprintf('set(%i,''waitstatus'',''close'',''userdata'',1)',h))
               uicontrol('position',[10  50 150 30],'string',[X{Sel}.name ' Variables'],'callback',sprintf('set(%i,''waitstatus'',''close'',''userdata'',%i)',h,Sel + 1))
            else
               uicontrol('position',[10 130 150 30],'string','Samples',               'callback',sprintf('set(%i,''waitstatus'',''close'',''userdata'',1)',h))
               uicontrol('position',[10  90 150 30],'string',[X{1}.name ' Variables'],'callback',sprintf('set(%i,''waitstatus'',''close'',''userdata'',2)',h))
               uicontrol('position',[10  50 150 30],'string',[X{2}.name ' Variables'],'callback',sprintf('set(%i,''waitstatus'',''close'',''userdata'',3)',h))
            end
            uicontrol('position',[10 10 150 30],'string','Proceed','callback',sprintf('set(%i,''waitstatus'',''close'',''userdata'',0)',h))
            waitfor(h,'waitstatus','close')
            Dim = get(h,'userdata');
            delete(h)
            if Dim == 1
               Model1 = SelectSamples(ModelIn,0);
            elseif Dim == 2 | Dim == 3
               
               Model1.var = ModelIn.var(Dim - 1);
               if Dim == 2
                  Model1 = SelectVariables(Model1,'In');
               else
                  Model1 = SelectVariables(Model1,'Out');
               end
               
            end
            if isempty(Model1);
               return
            else
               if Dim > 1
                  ModelIn.var(Dim - 1) = Model1.var;
               elseif Dim == 1
                  ModelIn.sam = Model1.sam;
               end
            end
         end
         Data = {};
         if ~sum(ModelIn.sam(1).sel.dims)
            ModelIn.sam(1).sel.sel = 1;
         end
         for i = 1:Sel
            Data(Sel(i)) = DefineArray(ModelIn,Sel(i),0,1);
         end
         
      case 'Cancel'
         return
         
      otherwise
         Data = X(Sel);
         
   end
   try
      CDir = cd;
      Dir  = which('Cubatch.m');
      Dir  = Dir(1:max(find(Dir == '\')));
      cd([Dir,'Data'])             
      [Xfil{2:-1:1}] = uiputfile('*.mat','Save data set as');
      cd(CDir)
   catch
      [Xfil{2:-1:1}] = uiputfile('*.mat','Save data set as');
   end;
   if Xfil{1} ~= 0
      File = [Xfil{:}];
      X = Data{1};
      if length(Data) == 2
         Y = Data{2};
         if isempty(X)
            save(File,'Y')
         else
            save(File,'X','Y')
         end
      else
         save(File,'X')
      end
   end
end  