function Cont = EditLabels(Content)
% function Cont = EditLabels (Content);
% 
% Description:
% Opens a window to edit the additional information about the array (either single or multiple set)
% associated to Content  and handles the corresponding events. The following application-defined data
% are assigned to the figure 
% Handles: structure with the handles to the menus 
% Content: interim Content
% 
% Inputs: 
% Content: it can be Content object or NaN. In the former case it is the data structure that is to be
         % edited. In the latter, the function operates as a callback function and the code to execute is
%          determined by the 'tag' of the callback object.
% 
% Outputs:
% Cont: Insert description
% 
% 
% Called by:
% CuBatch
% 
% Subroutines:
% Internal: MakeLab, DefMenus
% External: cenwindow, ctag, getcvdata, guinames, setcvdata
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 21-Oct-2002 05:05:22
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
% 

GuiNames
cbf = 'EditLabels(NaN);';
wic = [0.5029 0.5814 0.6402];
if nargin == 0
   Labels = [];
   return;
end
if isa(Content,'content')
  
   %Open window and set it as modal
   h   = cenwindow(wic,'Data set editor',cbf,310,370);
   set(h,'toolbar','none')
   %Define controls
   Han = DefMenues(h,Content);
   %Handle labels button
   setcvdata(h,'Handles',Han,'Content',Content)
   waitfor(h,'waitstatus','close')
   Cont = getcvdata(h,'Content');
   delete(h)      
   
else
   
   [Han,Content] = getcvdata(gcbf,'Handles','Content');
   van           = get(Han.ls,va);
   mon           = get(Han.mod,va);
   
   switch ctag       
   case 'Help'
      a   = lower(which('CuBatch'));
      a   = strrep(a,'cubatch.m','Help\user\edit.html#LabelsInfo');
      stat=web(['file:///' a],'-browser');
      
   case 'renlab'
      if isempty(van)
         return
      end
      if isempty(Content.measunits{mon})
         
         DefAns   = {char(Content.labels{mon}(van))};
         Answer   = inputdlg('Insert new names','Rename',length(van),DefAns);
         if ~isempty(Answer)
            Labs2            = label(Answer{1});
            try
               Content.labels{mon}(van) = Labs2;
            catch
               errordlg(lasterr)
            end
         end
         
      end
      
   case 'modlab'
      set(Han.ls,st,Content.labels{mon})
      set(Han.nummeas,dis{:})
      
   case 'varlab'
      if length(van) == length(get(gcbo,st))
         set(Han.nummeas,en{:})
      else
         set(Han.nummeas,dis{:})
      end
      return
      
   case {'&Prefix + Number','&Number + Meas. Unit','Default'}
      Prompts = {'Prefix (Es. Site, Compound., etc)'
         'Values (Es. 1 4 6)'
         'Measurment unit (Es. nm, bar, etc)'};
      DefAns  = {'Prefix',[num2str(length(van)),' Numbers'],'Measurement unit'};
      switch ctag 
      case '&Number + Meas. Unit'
         DefAs = 1;
      case '&Prefix + Number'
         DefAs = 2;
      case 'Default'
         DefAs = 3;
      otherwise
         DefAs = get(Han.dpu,va);
      end
      if isempty(van) | (length(van) ~= length(get(Han.ls,st)) & DefAs == 1)
         van = [1:length(get(Han.ls,st))];
      end
      switch DefAs
      case 1 %Num. + Meas. unit  
         Answer  = inputdlg(Prompts([2,3]),'Define as Number + meas unit',1,DefAns([2,3]));
         if isempty(Answer)
            return
         else
            Numbs  = str2num(Answer{1});
            if length(Numbs) == length(van)
               Lab2  = label([],'Var.',Numbs,Content.axislabels{mon},Content.modenames{mon},Answer{2});
            else
               return
            end
         end
         
      case 2 %Prefix + Num.
         Answer   = inputdlg(Prompts([2,1]),'Define as Prefix + Number',1,DefAns([2,1]));
         if isempty(Answer)
            return
         else
            Numbs  = str2num(Answer{1});
            if length(Numbs) == length(van)
               Lab2  = label(Numbs,Answer{2},Content.scalars{mon}(van),Content.axislabels{mon},Content.modenames{mon},Content.measunits{mon});
            else
               return
            end
         end
         
      case 3 %Default' Labels = label(Lab,DefLab,Scalars,AxisLabels,Name,MeasUn)
         Lab2 = label(van,Content.labobj{mon}.deflab,[],[],sprintf('Mode %i',mon));
      end
      Content.labels{mon}(van) = Lab2;
      set(Han.mod,st,Content.modenames)

      
   case 'alllab'
      set(Han.ls,va,[1:length(get(Han.ls,st))])
      set(Han.nummeas,en{:})
      return
      
   case {'implabmat','implabtxt'}
      if ~length(van)
         uiwait(warndlg('No labels have been selected'))
         return
      end
      Asc = 0;
      if strcmp(ctag,'implabmat')
         Nam = '*.mat';
      else   
         Nam = '.txt';
         Asc  = 1;
      end
      [Fil{2:-1:1}] = uigetfile(Nam,'Import labels');
      if Fil{1} ~= 0
         
         if ~Asc
         
            Cont = who('-file',[Fil{:}]);
            Ok   = 1;
            Sel  = 1;
            if length(Cont) > 1
               [Sel,Ok] = listdlg('Liststring',Cont,'selectionmode','single','name','Import labels','promptstring','Select the variable to load');
            end
            if Ok
               Lab = load([Fil{:}],Cont{Sel});
               Lab = getfield(Lab,Cont{Sel});
            else
               return
            end
            
         else
            
            fid = fopen([Fil{:}],'r');
            Lab = fread(fid,inf,'uchar');
            Lab = MakeLab(Lab);
            fclose(fid);
            
         end
         
      else
         return;
      end
      if isempty(Lab)
         return
      elseif isa(Lab,'char') | isa(Lab,'label') | isa(Lab,'cell')
         Lab = label(Lab);
      elseif isa(Lab,'double')
      
         if length(Lab) ~= length(van)
            ErrMsg = {'The length of the scalar vector and the number';'of selected variables must be the same'};
            uiwait(errordlg(ErrMsg))
            return;
         end
         Answer  = inputdlg({['Imported as numbers.',char(10),'Define measurment unit (Es. nm, bar, etc)']},'Define Measurement Unit',1,Content.measunits(mon));%
         Lab = label([],'Var.',Lab,Content.axislabels{mon},Content.modenames{mon},Answer{1});
         
      else
         uiwait(msgbox({'Inadequate format for labels'}));
      end
      if length(Lab)>length(van)
         
         EndLess  = 1;
         Text     = {'Select the variables'' labels to assign','',''}; 
         while EndLess
            
            [sel,ok] = listdlg('uh',30,'Liststring',Lab.labels,'Name',['Mode: ',Content.modenames{mon}],...
               'ListSize',[190,350],'PromptString',Text);
            if ok == 1
               
               if length(sel) == length(van)
                  Content.labels{mon}(van) = Lab(sel);
                  EndLess = 0;
               else
                  uiwait(msgbox({'The number of selected items do not','correspond to the number of labels'}))
               end
               
            else
               return
            end
            
         end
         
      elseif length(Lab)<length(van)
         uiwait(msgbox('The file does not contain enough labels'));
         return
      else
         Content.labels{mon}(van) = Lab;
      end
      
   case 'renmodlab'
      DefAns = {char(Content.modenames{mon}),char(Content.axislabels{mon}),char(Content.deflab{mon})};
      Prompt = {'Name','Axis labels','Default label'};
      Answer = inputdlg(Prompt,'Edit axis name and label',[1 2 1]',DefAns);
      if ~isempty(Answer)
         
         Content.labels{mon}.name       = Answer{1};
         Content.labels{mon}.axislabels = Answer{2};
         Content.labels{mon}.deflab     = Answer{3};
         a(mon) = Answer(1);
         set(Han.mod,st,Content.modenames,va,mon)
         
      end
      
   case 'Array Name'
      Answer   = inputdlg({'Enter array name'},'Array name',1,{Content.name});
      if ~isempty(Answer)
         Content.name = Answer{1};
      end
      set(Han.nam,st,Content.name)
      
   case 'DescView'
      Desc = Content.description;
      if ~isempty(Desc)
         Desc = textwrap(Content.description,60);
      else
         Desc = 'No description available';
      end
      uiwait(msgbox(Desc,'Description'));
      
   case 'Description'
      Answer = inputdlg('Insert description','Description editor',[20 60],{char(Content.description)},'on');
      if ~isempty(Answer)
         Content.description = Answer{1};
      end
      
   case 'AuthorView'
      Auth = Content.author;
      if ~isempty(Auth)
         Auth = textwrap(Content.author,60);
      else
         Auth = 'No information available';
      end
      uiwait(msgbox(Auth,'Author'));
      
   case 'Author'
      Answer = inputdlg('Insert author information','Author editor',[8 60],{char(Content.author)},'on');
      if ~isempty(Answer)
         Content.author = Answer{1};
      end
      
   case 'alllab'
      set(Han.ls,va,[1:length(List)])
      return
      
   case {'window','cancel'}
      setappdata(gcbf,'Content',[])
      set(gcbf,'waitstatus','close')
      return
      
   case 'ok'
      set(gcbf,'waitstatus','close')
      return
      
   end
   set(Han.ls,st,Content.labels{mon},va,[])
   if length(van) == 0
      set(Han.nummeas,dis{:})
   end
   setappdata(gcbf,'Content',Content);
   return
   
end


%------------------------------------------------------------------------------------------------------

function Labs = MakeLab(Content)
% 
% File: EditLabels.m
% 
% function Labs = DefMenus(Content)
% 
% Description: 
% Creates a cell array of chars out of the raw (from an ASCII file) content of a file.
% Each row corresponds to an element of the final cell vector of chars.
% It is used when the "import from .txt" menu is applied.
% 
% Inputs: 
% Content: raw content (as chars) of a loaded file. 
% 
% Outputs: 
% Labs: Cell vector of chars containing the strings
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 21 Oct. 2002 
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 
try
   if isempty(Content)
      Labs = [];
      return
   end
   pos = [find(Content == char(10));length(Content)];
   init = 1;
   for i = 1:length(pos)
      Labs{i} = char(Content(init:pos(i))');
      id = find(Labs{i} == char(10) | Labs{i} == char(13));
      if ~isempty(id)
         Labs{i}(id) = [];
      end
      init = pos(i)+1;
   end
   Labs = label(Labs);
catch
   Labs = [];
end

%-------------------------------------------------------------------------------------------------------

function Han = DefMenues(h,Content)
% File: EditLabels.m
% 
% function Han = DefMenus(h,Content)
% 
% Description: 
% Creates EditLabels-windows' menus.
% 
% Inputs: 
% h: EditLabels window handle
% Content: Content object passed as a parameter to EditLabels. 
% 
% Outputs: 
% Han: Handles to the menus in the EditLabels window
% 
% Subroutines: 
% Internal:    None    
% External:    GUINames
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 21 Oct. 2002 
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 
figure(h)
cbf = 'EditLabels(NaN);';
lbg = [0.9 0.93 0.95];
frc = [0.3529 0.4314 0.4902];
wic = [0.5647 0.6902 0.7843];

GuiNames

%Editor menues
Files = uimenu(la,'&Files');
Edit  = uimenu(la,'&Edit');
Vi    = uimenu(la,'&View');
Help  = uimenu(la,'&Help');

%Files menu
l = uimenu(Files,la,'Import');
uimenu(Files,la,'&Close editor',   cb,cbf,tg,'ok',sep{:},acc,'Q')
uimenu(l,la,'from .&mat',cb,cbf,tg,'implabmat');
uimenu(l,la,'from .&txt',cb,cbf,tg,'implabtxt');

%Edit menu
uimenu(Edit,la,'Rename D&ata set', cb,cbf,tg,'Array Name')
uimenu(Edit,la,'Rename &Mode',     cb,cbf,tg,'renmodlab')
uimenu(Edit,la,'Rename &Variables',cb,cbf,tg,'renlab')
df = uimenu(Edit,la,'&Define variables as',sep{:});
uimenu(Edit,la,'D&efault names',    cb,cbf,tg,'Default')
uimenu(Edit,la,'A&uthor',           cb,cbf,tg,'Author',sep{:});
uimenu(Edit,la,'D&escription',      cb,cbf,tg,'Description')
uimenu(df,la,'&Prefix + Number',    cb,cbf,tg,'&Prefix + Number');
Han.nummeas(1) = uimenu(df,la,'&Number + Meas. Unit',cb,cbf,tg,'&Number + Meas. Unit',dis{:});
Help = uimenu(la,'&Help');
uimenu(Help,la,'&About CuBatch',   cb,'AboutCuBatch')
uimenu(Help,la,'&Help',            cb,cbf,tg,'Help')

%View menu
uimenu(Vi,la,'&Author',     cb,cbf,tg,'AuthorView')
uimenu(Vi,la,'&Description',cb,cbf,tg,'DescView')

cm2      = uicontextmenu;
uimenu(cm2,la,'&Default names',cb,cbf,tg,'Default');
uimenu(cm2,la,'&Rename',       cb,cbf,tg,'renlab');
cm_4     = uimenu(cm2,la,'Define as:');
cm_1     = uimenu(cm2,la,'Import',sep{:});
uimenu(cm2,la,'Select all',   cb,cbf,tg,'alllab',sep{:});

uimenu(cm_1,la,'from .&mat',cb,cbf,tg,'implabmat');
uimenu(cm_1,la,'from .&txt',cb,cbf,tg,'implabtxt');
uimenu(cm_4,la,'&Prefix + Number',cb,cbf,tg,'&Prefix + Number');
Han.nummeas(2) = uimenu(cm_4,la,'&Number + Meas. Unit',cb,cbf,tg,'&Number + Meas. Unit',dis{:});

cm_6     = uicontextmenu;
uimenu(cm_6,la,'Rename',       cb,cbf,tg,'renmodlab')
uimenu(cm_6,la,'Default names',cb,cbf,tg,'defmodlab')

Modes   = Content.modenames;
Vars  = Content.labels{1};
Dims    = [sprintf('%i ',Content.dims(1)),sprintf('x %i ',Content.dims(2:end))];
HelpStr = {'Select labels and','right-click on the','list to modify them'};
uicontrol(ty,fr,                 pos,[167  82 140  60],bg,frc)
uicontrol(ty,fr,                 pos,[167 230 140 110],bg,frc)
uicontrol(ty,fr,                 pos,[167 152 140  68],bg,frc)

uicontrol(ty,tx,st,'Labels',     pos,[ 10 339 150  25],bg,WIC,ari{:},bd{:})
Han.ls = uicontrol(ty,lb,st,Vars,pos,[ 10  10 150 334],cu{:},cb,cbf,bg,lbg,tg,'varlab',ucm,cm2,ms{:});

uicontrol(ty,tx,          st,'Data set:',  pos,[172 310 130  25],bg,frc,ha,'left',  ari{:},bd{:})
Han.nam = uicontrol(ty,tx,st,Content.name, pos,[172 285 130  25],bg,frc,ha,'left',ari{:});
uicontrol(ty,tx,          st,'Dimensions:',pos,[172 260 130  25],bg,frc,ha,'left',  ari{:},bd{:})
uicontrol(ty,tx,          st,Dims,         pos,[172 235 130  25],bg,frc,ha,'left',  ari{:})

uicontrol(ty,tx,st,HelpStr,pos,[172 156 130  56],bg,frc,ha,'center',ari{:});

Han.txt  = uicontrol(ty,tx,st,'Mode',pos,[172 105 130  30],ari{:},       bg,frc,bd{:});
Han.mod  = uicontrol(ty,pu,st,Modes, pos,[174  86 126  30],ari{:},cb,cbf,bg,'w',tg,'modlab');
uicontrol(            st,'Cancel',pos,[167  46 140  30],ari{:},cb,cbf,tg,'cancel');
Han.ok   = uicontrol( st,'Ok',    pos,[167  10 140  30],ari{:},cb,cbf,tg,'ok');


%----------------------------------------------------------------------------------------