function AxH = DisplayInfo(MainFig,X)
% function AxH = DisplayInfo (MainFig,X);
% 
% Description:
% If X is empty display initial window (with information about Authors in the InfoBox and about the
% help) If X is the data structure X, it displays the corresponding information in the InfoBox If X is
% a handle, this function handles the events linked to 'click here for more' text in the InfoBox by
% opening a new figure displaying the Description and the Author of the corresponding set (if any).
% 
% 
% Inputs: 
% MainFig: handle to CuBatch main window
% X: either the X data structure or handle to  'click here for more' object
% 
% 
% Outputs:
% AxH: Handle to the initial help axes (Optional)
% 
% 
% Called by:
% CuBatch, DisplayModel, ResizeCuBatch
% 
% Subroutines:
% Internal: none
% External: guinames, screensize, *Apply (not PARAFACApply or nPLS1Apply) and *DisplayInfo for all the
%           implemented models.
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 27-Oct-2002 09:02:28
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

GuiNames
if ~isempty(X) & ~ishandle(X) & ~(isa(X,'cell') & isempty(X{1}))  
   Batch = 0;
   delete(findobj('type','axes','tag','CBInfoFrame'))
   Type = {'Single set','Multiple Set'};
   S1a = {'\fontsize{10}Name';'Size';'Type';'Missing data'};
   delete(findobj(MainFig,tg,'textfig'))
   NaNPerc = isnan(X{1});
   if strcmp(X{1}.type,'Batch')
      Dims = [int2str(length(X{1}.userdata)) ' --- ',int2str(X{1}.dims(2:end))];
      Batch = 1;
   else
      Dims = int2str(X{1}.dims);
   end
   S1b = {[': ',X{1}.name]
      [': [',Dims,']']
      [': ',Type{find(strcmp({'Data','Batch'},X{1}.type))}]
      num2str(100 * sum(NaNPerc(:)) / prod(size(NaNPerc)),': %3.2f %%')};
   axes('position',[0.0112 0.0377 0.2240 0.9127],'xtick',[],'ytick',[],'box','on','color',[0.3529 0.4314 0.4901],tg,'CBInfoFrame');
   fnor = {'fontunits','normalized'};
   vert = {'verticalalignment','cap'};
   a    = text(.5,0.99,'\bf\fontsize{12}Data X',ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
   apos = get(a,'extent');
   text(.05,apos(2)-0.02,S1a,ha,'left',vert{:},fnor{:},tg,'textfig','units','normalized')
   b    = text(.5,apos(2)-0.02,S1b,ha,'left',vert{:},fnor{:},tg,'textfig','units','normalized','interpreter','none');
   bpos = get(b,'extent');
   if ~isempty(X{1}.description) | ~isempty(X{1}.author) | Batch
      c    = text(.5,bpos(2)-0.015,'\itClick here for more','verticalalignment','top',tg,'textfig',ha,'center','buttondownfcn','DisplayInfo(gcbf,gcbo);',ud,{X{1}.description,X{1}.author,X{1}.userdata});
      bpos = get(c,'extent');
   end
   
   if length(X) > 1
      if strcmp(X{2}.type,'Batch')
         Dims = [int2str(length(X{1}.userdata)) ' --- ',int2str(X{2}.dims(2:end))];
      else
         Dims = int2str(X{2}.dims);
      end
      NaNPerc = isnan(X{2});
      S1b  = {[': ',X{2}.name];...
            [': [',Dims,']'];...
            [': ',Type{find(strcmp({'Data','Batch'},X{2}.type))}];...
            num2str(100 * sum(NaNPerc(:)) / prod(size(NaNPerc)),': %3.2f %%')};
      d    = text(.5,bpos(2)-0.03,'\bf\fontsize{12}Data Y',ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
      dpos = get(d,'extent');
      text(.05,dpos(2)-0.02,S1a,ha,'left',vert{:},fnor{:},tg,'textfig','units','normalized')
      e    = text(.5,dpos(2)-0.02,S1b,ha,'left',vert{:},fnor{:},tg,'textfig','units','normalized','interpreter','none');
      epos = get(e,'extent');
      if ~isempty(X{2}.description) | ~isempty(X{2}.author) | Batch
         text(.5,epos(2)-0.015,'\itClick here for more','verticalalignment','top',tg,'textfig',ha,'center','buttondownfcn','DisplayInfo(gcbf,gcbo);',ud,{X{2}.description,X{2}.author,X{2}.userdata});
      end
      
   end  
   
elseif ~isempty(X) & ishandle(X)
   
   h  = figure('menubar','none','name','Data Set info','units','pixels','numbertitle','off');
   uimenu(h,la,'Close',cb,'delete(gcbf)')
   UD                           = get(X,ud);
   [Description,Author,Lengths] = deal(UD{:});
   axes(pos,[0 0 1 1],'box','on','xtick',[],'ytick',[],'color',WIC,'units','normalized');
   if isempty(Description)
      Description = {'Not available';''};
   end
   if isempty(Author)
      Author = {};
   end
   if ~isempty(Lengths)
      Description{end + 2} = ['\bfBatch lengths: \rm' int2str(Lengths(:)'),'  '];
   end
   DTW  = textwrap(Description,120);
   ATW  = textwrap(Author,120);
   DTW  = {'\fontsize{12}\bfDescription\rm\fontsize{9}','',DTW{:}};
   ATW  = {'\fontsize{12}\bfAuthor\rm\fontsize{9}','',ATW{:}};
   a    = text(.5,0.96,DTW,'verticalalignment','cap',ha,'center','units','normalized',tg,'textfig');
   apos = get(a,'extent');
   b    = text(.5,0.96 - apos(4)-0.05,ATW,'verticalalignment','cap',ha,'center','units','normalized',tg,'textfig');
   set([a,b],'units','pixels');
   txpos = get([a,b],'extent');
   set([a,b],'units','normalized');
   txsize     = cat(1,txpos{:});
   figdims    = sum(txsize) + 60;
   figdims(3) = max([160;txsize(:,3)]);
   t          = screensize;
   figdims([1:2]) = fix(.5*(t(3:4)-figdims(3:4)));
   if any(figdims(1:2)<0)
      figdims(1:2) = [0 t(4)];
   end
   set(h,pos,figdims,'resize','off')
   apos = get(a,'extent');
   set(b,pos,[.5,0.96-apos(4)-0.05,0])
   
else
   
   delete(findobj('type','axes','tag','CBInfoFrame'))
   axes('position',[0.0112 0.0377 0.2240 0.9127],'xtick',[],'ytick',[],'box','on','color',[0.3529 0.4314 0.4901],tg,'CBInfoFrame');%,'handlevisibility','off'
   Str1 = {['\fontsize{12}\bf',vers,'\rm\fontsize{9}']
      ''
      '\rm\itA program realised under'
      'the NWAYQUAL EU-project.'
      ''
      ''
      '\rm\fontsize{10}\bfDesigned by:\rm\fontsize{9}'
      ''
      '\bfTotalFinaElf (CReS)\rm';
      '15 Chemin du Canal'
      'B.P.22'
      '69360 - Solaize'
      'France'
      ''
      '\bfVrije Universiteit'
      'Brussel (VUB)\rm'
      'Laarbeeklaan 103'
      '1090 - Brussels'
      'Belgium'
      ''
      '\bfRoyal Agricultural and'
      'Veterinary University (KVL)\rm'
      'MLI,LMT,Chemometrics Group'
      'Rolighedsvej 30'
      '1958 - Frederiksberg C'
      'Denmark'};
   text(0.5,0.5,Str1,'verticalalignment','middle','horiz','center','fontunits','normalized','tag','textfig');
   AxH = axes(pos,[0.2464,0.0377,0.7312,0.9127]);
%   imagesc(imread('cubedali.jpg'))
    Str2 = {['\fontsize{12}\bf','CuBatch (v2.0) is originally developed for Matlab 6.5 ','\rm\fontsize{9}']
        'v2.1 - release including several minor changes and fixes for Matlab 7.12 (R2011a)'
       ''
       ''
       '\rm\fontsize{10}\bfBefore starting to work with CuBatch, please go to the Help menu to find:\rm\fontsize{9}'
       ''
       ''
       '- a Programmer guide (with details about all functions of CuBatch)'
       ''
       '- a User guide (to handle the data and to use them)'
       ''
       '- About Cubatch'
       ''
       ''
       ''
       ''
       ''
       ''
       ''
       ''
       ''
       ''
       ''
       '\rm\fontsize{8}\bfThis software is the property of TOTALFINAELF-FRANCE, of the VRIJE UNIVERSITEIT BRUSSEL (Belgium)\rm\fontsize{9}',
       '\rm\fontsize{8}\bfand of ROYAL AGRICULTURAL AND VETERINARY UNIVERSITY (Danmark).\rm\fontsize{9} '
       ''
       '\rm\fontsize{8}\bfIt is protected by copyright law and international treaties. Unauthorized reproduction or distribution \rm\fontsize{9}'
       '\rm\fontsize{8}\bfof this program or any portion of it, may result in severe civil and criminal penalties and will be \rm\fontsize{9}', 
       '\rm\fontsize{8}\bfprosecuted to the maximum extent possible under the law.\rm\fontsize{9}'};

    text(0.03,0.95,Str2,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized')
    set(AxH,'xtick',[],'ytick',[],tg,'cbaxes','box','on')
    
end
set(findobj(tg,'textfig','type','text'),'fontunits','normalized');
