function CreaProgGuide(Dir,StFlag)
if ~exist(Dir,'dir')
   error(['The specified directory is not in the path!',char(10),...
         'Retry from CuBatch directory',char(10),'GT'])
   return
end
OrDir = cd;
if strcmp(Dir,OrDir(max(find(OrDir == '\')) + 1:end))
   cd ..
end
if nargin < 1
   StFlag = '''';
else
   StFlag = '';
end
cd(Dir)
a = what;
a = strrep(a.m,'.m','');
a = strrep(a,'.M','');
for i = 1:length(a)

   [e,f] = FindCallFun(a{i});
   f_id  = fopen(['prog_',a{i},'.html'],'w');
   b     = dir([a{i} '.m']);
   b     = b.date;
   f_id2 = fopen([a{i},'.m'],'r');
   c     = [];
   while isempty(c) | c(1) == '%'
      c     = fgetl(f_id2);
   end
   F_c    = fread(f_id2,inf,'char');
   F_c    = lower(char(F_c'));
   f(:,1) = lower(f(:,1));
   F_fl   = zeros(length(f),1);
   for j  = 1:length(f)
      if f{j,3}
         pattern = '[^\.a-z_A-Z0-9]';
      else
         pattern = '[^\.a-z_A-Z0-9'']';
      end
      pres = regexp(F_c,['[^',StFlag,'\.a-z_A-Z0-9]',f{j,1},pattern]);
      cr   = regexp(F_c,char([13 10]));
      for k = 1:length(pres)
         lin_in = cr(max(find(cr < pres(k))));
         if ~any(F_c(lin_in:pres(k)) == '%')
            F_fl(j) = ~isempty(pres);
            break
         end
      end
      %F_fl(j) = ~isempty(findstr(F_c',f{j,1}));
   end
   g     = f(find(F_fl),:);
   isinf = length(findstr(F_c,'function ')) > 1;
   if ~isempty(g)
      for j = 1:size(g,1)
         g{j,2} = g{j,2}(findstr(lower(g{j,2}),'\cubatch\') + 9 : end - 2);
      end
      g(:,2)    = strrep(g(:,2),'\','_');
      g(:,2)    = strrep(g(:,2),'Common_','');
      g(:,2)    = strrep(g(:,2),'private_','');
      g(:,2)    = strrep(g(:,2),'private_','');
      [nil,ord] = unique(g(:,1));
      g         = g(ord,:);
      disp('Calling')
      disp(char(g(:,2)))
   end
   disp(' ')
   fclose(f_id2);
   isf   = ~isempty(findstr(c,'function '));         
   anyo  = any(c == '=') & isf;
   anyi  = any(c == '(') & isf;
   I_P   = {};
   O_P   = {};
   if anyi
      InputPars = c(find(c=='(')+1:find(c==')')-1);
      comas     = find(InputPars == ',');
      ni        = length(comas) + 1;
      if ~ni
         I_P = {InputPars};
      else
         comas = [0,comas(:)',length(InputPars) + 1];
         for j = 1:ni
            I_P{j} = InputPars(comas(j) + 1:comas(j+1) - 1);
         end
      end
   end
   if anyo
      OutPars                                  = c(findstr(c,'function ')+9:find(c == '=')-1);
      OutPars(OutPars == 32)                   = [];
      OutPars(OutPars == '[' | OutPars == ']') = []; 
      comas                                    = find(OutPars == ',');
      ni                                       = length(comas) + 1;
      if ~ni
         O_P = {OutPars};
      else
         comas = [0,comas(:)',length(OutPars)];
         for j = 1:ni
            O_P{j} = OutPars(comas(j) + 1:comas(j+1) - 1);
         end
      end
   end
   fwrite(f_id,['<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">' 10 ],'char');
   fwrite(f_id,['<html>' 10 ],'char');
   fwrite(f_id,['<head>' 10 ],'char');
   fwrite(f_id,['' 10 ],'char');
   fwrite(f_id,['  <meta http-equiv="Content-Language" content="en-gb">' 10 ],'char');
   fwrite(f_id,['  <meta name="GENERATOR" content="Microsoft FrontPage 5.0">' 10 ],'char');
   fwrite(f_id,['  <meta name="ProgId" content="FrontPage.Editor.Document">' 10 ],'char');
   fwrite(f_id,['  <meta http-equiv="Content-Type" content="text/html; charset=windows-1252">' 10 ],'char');
   fwrite(f_id,['  <title>',Dir,'\',a{i},'.m</title>' 10 ],'char');
   fwrite(f_id,['' 10 ],'char');
   fwrite(f_id,['</head>' 10 ],'char');
   fwrite(f_id,['' 10 ],'char');
   fwrite(f_id,['<body bgcolor="#ffffff" text="#000000" link="#000000" vlink="#000000" alink="#000000">' 10 ],'char');
   fwrite(f_id,['' 10 ],'char');
   fwrite(f_id,['<p>' 10 ],'char');
   fwrite(f_id,['<font face="Verdana" size="5"><u><b>',a{i},'</b></u></font><br>' 10 ],'char');
   fwrite(f_id,['<br>' 10 ],'char');
   fwrite(f_id,['<font face="Verdana"><u>Location</u>: ','CuBatch\',Dir,'\',a{i},'.m</font>' 10 ],'char');
   fwrite(f_id,['</p>' 10 ],'char');
   fwrite(f_id,['' 10 ],'char');
   fwrite(f_id,['<p>' 10 ],'char');
   if isf
      fwrite(f_id,['<font face="Verdana,Helvetica,Arial" color="#0000ff">function</font>' 10 ],'char');
   else
      fwrite(f_id,['<font face="Verdana,Helvetica,Arial" color="#0000ff">batch</font>' 10 ],'char');
   end
   fwrite(f_id,['<font face="Verdana,Helvetica,Arial" color="#000000">' 10 ],'char');
   if anyo
      if length(O_P) > 1
         fwrite(f_id,' [','char');
      end
      for j = 1:length(O_P)
         fwrite(f_id,['<i>',O_P{j},'</i>'],'char');
         if j < length(O_P)
            fwrite(f_id,',','char');
         end
      end
      if length(O_P) > 1
         fwrite(f_id,']','char');
      end
      fwrite(f_id,' = ','char');
   else
      fwrite(f_id,' ','char');
   end
   fwrite(f_id,a{i},'char');
   if anyi
      fwrite(f_id,' (','char');
      for j = 1:length(I_P)
         fwrite(f_id,['<i>',I_P{j},'</i>'],'char');
         if j < length(I_P)
            fwrite(f_id,',','char');
         end
      end
      fwrite(f_id,');','char');
   else
      fwrite(f_id,';','char');
   end
   fwrite(f_id,['<br>' 10],'char');
   fwrite(f_id,['<br>' 10],'char');
   fwrite(f_id,['<u>Description</u>:<br>' 10],'char');
   fwrite(f_id,['  Insert description here</font>' 10],'char');
   fwrite(f_id,['<font face="Verdana,Helvetica,Arial" color="#800000">''Color code: marroon''</font>' 10],'char');
   fwrite(f_id,['<font face="Verdana,Helvetica,Arial" color="#000000"><br>' 10 ],'char');
   fwrite(f_id,['<br>' 10 ],'char');
   fwrite(f_id,['<u>Inputs</u>: <br>' 10 ],'char');
   if isf
      if anyi
         for j = 1:length(I_P)
            fwrite(f_id,['<i>',I_P{j},'</i>: '],'char');
            fwrite(f_id,['Insert description<br>' 10],'char');
         end
      else
         fwrite(f_id,['None<br>' 10],'char');
      end
   else
      fwrite(f_id,'None<br>','char');
   end
   fwrite(f_id,['</font>' 10 ],'char');
   fwrite(f_id,['</p>' 10 ],'char');
   fwrite(f_id,['' 10 ],'char');
   fwrite(f_id,['<p>' 10 ],'char');
   fwrite(f_id,['<font face="Verdana,Helvetica,Arial" color="#000000">' 10 ],'char');
   fwrite(f_id,['<u>Outputs</u>:<br>' 10 ],'char');
   if isf
      if anyo
         for j = 1:length(O_P)
            fwrite(f_id,['<i>',O_P{j},'</i>: '],'char');
            fwrite(f_id,['Insert description<br>' 10],'char');
         end
      else
         fwrite(f_id,['None<br>' 10],'char');
      end
   else
      fwrite(f_id,'None<br>','char');
   end   
   fwrite(f_id,['</font>' 10 ],'char');
   fwrite(f_id,['</p>' 10 ],'char');
   fwrite(f_id,['' 10 ],'char');
   fwrite(f_id,['<p>' 10 ],'char');
   fwrite(f_id,['<font face="Verdana,Helvetica,Arial" color="#000000">' 10 ],'char');
   fwrite(f_id,['<u>Called by</u>:<br>' 10 ],'char');
   if ~isempty(e)
      e  = unique(e);
      e2 = strrep(e,'\','_');
      e2 = strrep(e2,'Common_','');
      e2 = strrep(e2,'private_','');
      e2 = strrep(e2,'private_','');
      e  = strrep(e,'Common\','');
      e  = strrep(e,'private\','');
      e  = strrep(e,'private\','');
      for j = 1:length(e)
         if j < length(e)
            fwrite(f_id,['<a href="prog_',e2{j},'.html">',e{j},'</a>,' 10],'char');
         else
            fwrite(f_id,['<a href="prog_',e2{j},'.html">',e{j},'</a><br>' 10],'char');
         end
      end
   else
      fwrite(f_id,['None<br>' 10 ],'char');
   end
   fwrite(f_id,['<br>' 10 ],'char');
   fwrite(f_id,['<u>Subroutines</u>:<br>' 10 ],'char');
   if isinf
      fwrite(f_id,['<i>Internal</i>:Names and hyperlinks<br>' 10 ],'char');
   else
      fwrite(f_id,['<i>Internal</i>:None<br>' 10 ],'char');
   end
   fwrite(f_id,['<i>External</i>: ' 10 ],'char');
   if ~isempty(g)
      for j = 1:size(g,1)
         if j < size(g,1)
            fwrite(f_id,['<a href="prog_',g{j,2},'.html">',g{j,1},'</a>,' 10],'char');
         else
            fwrite(f_id,['<a href="prog_',g{j,2},'.html">',g{j,1},'</a><br>' 10],'char');
         end
      end
   else
      fwrite(f_id,['None<br>' 10 ],'char');
   end
   fwrite(f_id,['</font>' 10 ],'char');
   fwrite(f_id,['</p>' 10 ],'char');
   fwrite(f_id,['' 10 ],'char');
   fwrite(f_id,['<p>' 10 ],'char');
   fwrite(f_id,['<font face="Verdana,Helvetica,Arial" color="#000000">' 10 ],'char');
   fwrite(f_id,['<u>Author</u>: <br>' 10 ],'char');
   fwrite(f_id,['Giorgio Tomasi <br>' 10 ],'char');
   fwrite(f_id,['Royal Agricultural and Veterinary University <br>' 10 ],'char');
   fwrite(f_id,['MLI, LMT, Chemometrics group <br>' 10 ],'char');
   fwrite(f_id,['Rolighedsvej 30 <br>' 10 ],'char');
   fwrite(f_id,['DK-1958 Frederiksberg C <br>' 10 ],'char');
   fwrite(f_id,['Danmark <br>' 10 ],'char');
   fwrite(f_id,['<br>' 10 ],'char');
   fwrite(f_id,['<u>Last modified</u>: ',b,'<br>' 10 ],'char');
   fwrite(f_id,['<br>' 10 ],'char');
   fwrite(f_id,['<u>Contact</u>: Giorgio Tomasi, <a href="mailto:gt@kvl.dk?subject=Cubatch"> gt@kvl.dk</a> <br>' 10 ],'char');
   fwrite(f_id,['<br>' 10 ],'char');
   fwrite(f_id,['<u>References</u><br>' 10 ],'char');
   fwrite(f_id,['</font>' 10 ],'char');
   fwrite(f_id,['</p>' 10 ],'char');
   fwrite(f_id,['</body>' 10 ],'char');
   fwrite(f_id,['</html>' 10 ],'char');
   fclose(f_id);
end
cd(OrDir)

function [Ref,Files_in_path] = FindCallFun(File);
MainDir = which('CuBatch.m');
MainDir = MainDir(1:max(find(MainDir == '\')));
disp(File)
Dir = cd;
cd(Dir)
conv = 0;
Ref = {};
if exist('private','dir') == 7 
   if isempty(findstr(lower(cd),'private'))
      cd private
   end
   conv = 2;
else
   conv = 3;
end
Files_in_path = {};
while conv
   a = what(cd);
   b = strrep(a(1).m,'.m','');
   a = a(1).m;
   for i = 1:length(a)
      if ~strcmpi(a{i},File)
         f_id = fopen(a{i},'r');
         r    = 'x';
         pres = 0;
         cou  = 1;
         while ischar(r)
            r = lower(fgetl(f_id));
            if cou == 1
               anyo  = any(r == '=') & ~isempty(findstr(r,'function '));
            end
            cou = cou + 1;
            %pos = min(findstr(r,lower(File)));
            if ischar(r)
               pos = regexp(r,['[^a-z_A-Z0-9]',lower(File),'[^a-z_A-Z0-9]']);
               if ~isempty(pos)
                  comment = min(find(r == '%'));
                  if (isempty(comment) | comment > pos) & ~strcmpi(File,b{i})
                     pres = 1;
                     r    = -1;
                  end
               end
            end
         end
         if pres
            t    = which(a{i});
            indt = findstr(lower(t),'\cubatch\');
            Ref{end + 1,1} = t(indt + 9:end-2);
         end
         Files_in_path{end + 1,1} = b{i};
         Files_in_path{end,2} = which(a{i});
         Files_in_path{end,3} = anyo;
         fclose(f_id);
      end
   end 
   if conv == 2
      cd ..
      disp(cd)
      conv = 3;
   elseif conv == 3 & isempty(findstr(lower(cd),'\common'))
      cd([MainDir 'Common'])
      disp(cd)
      conv = 4;
   elseif conv == 4
      cd([MainDir 'Nway'])
      disp(cd)
      conv = 5;
   elseif conv == 5 & ~strcmp(cd,MainDir)
      cd(MainDir)
      disp(cd)
      conv = 6;
   elseif conv == 6 & ~strcmpi(cd,[MainDir,'\private'])
      cd([MainDir,'\private'])
      disp(cd)
      conv = 7;
   else
      conv = 0;
   end
end
disp('Called by')
disp(char(unique(Ref)))
disp(' ')
cd(Dir)
