function DS = unfoldcbdataset(DS);
% function Labs = unfoldlabels (Data);
% 
% Description:
% Unfold the labels of the cbdataset Data. The only possible unfolding is of the type IxJK...
% 
% 
% Inputs: 
% Data: cbdataset whose labels need be unfolded
% 
% 
% Outputs:
% Labs: two elements cell vector, the labels in mode 1 of Data remain the same. For the following modes they become:
% 'Lab Mode n/Lab Mode n-1/.../Lab Mode 2'
% 
% 
% Called by:
% Model_PCA/acpplot
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 12-Aug-2002 11:07:50
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
% 
 
Labs    = DS.labobj(1);
Size    = size(DS);
T       = prod(Size(2:end));
L       = DS.labels;
CombLab = [];
for i = length(Size):-1:2
   L2 = reshape(repmat(L{i},T/Size(i),1),Size([i 2:i-1 i+1:end]));
   L2 = ipermute(L2,[i-1 1:i-2 i:length(Size)-1]);
   L2 = char(L2(:)); 
   if i == length(Size)
      CombLab = L2;
   else
      CombLab(:,end + 1:end + size(L2,2) + 1) = ['/'*ones(size(L2,1),1),L2];
   end
end
Labs{2} = label(CombLab,'Var.',[],'Combined modes','Combined modes','');
DS      = cbdataset(nshape(DS.data,1),'name',DS.name,'labels',Labs,'description',DS.description,'author',DS.author,'userdata',DS.userdata);
