function [PxY,B]=regression2(Y,Fx,k);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% regression                                         %
% [PxY,B]=regression2(Y,Fx,k);                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     Y N-way data
%     Fx loadings of tucker(X) (cell array)
%     k common modes
% OUTPUTS
%     PxY
%     B   Regression Coefficient
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  regression of a tensor onto another tensor        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   03/02/2002   version 1.1                         %
%   Christophe Durville           TOTALFINAELF       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%





Ry=size(Y);
Ny=length(Ry);
if isequal(min(size(Y)),1) & isequal(Ny,2), %Yvecteur
   Ny=1;
   Y=Y(:);
   [PxY,B]=regression2D(Y,Fx{1});
   return;
end;


PxY=Y;
for i=1:k,
   Yp=permute(PxY,[i,1:i-1,i+1:Ny]);
   Yu=reshape(Yp,Ry(i),prod(Ry([1:i-1,i+1:Ny])));
   Ryu=size(Yu);
   %[PxYu,B]=regression(Yu,Fx{i},1);
   [PxYu,B]=regression2D(Yu,Fx{i});
   PxYp=reshape(PxYu,[Ry(i),Ry([1:i-1,i+1:Ny])]);
   PxY=ipermute(PxYp,[i,1:i-1,i+1:Ny]);
end;


if k>1,
   B=[];
end;


