function [PxY,B]=regression(Y,X,k);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% regression                                         %
% [PxY,B]=regression(Y,X,k);                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     Y  tensor which will be projected onto X.
%     X  tensor on to X will be projected
%     k  common modes.
% OUTPUTS
%     PxY  
%     B    Regression Coefficient
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  regression of a tensor onto another tensor        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   25/05/2002   version 1.2                         %
%   Christophe Durville           TOTALFINAELF       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%X=rand(5,3,4);
%Y=rand(5,3,2);


Rx=size(X);
Nx=length(Rx);
Ry=size(Y);
Ny=length(Ry);
if isequal(min(size(X)),1) & isequal(Nx,2),
   Nx=1;
   X=X(:);
end;
if isequal(min(size(Y)),1) & isequal(Ny,2),
   Ny=1;
   Y=Y(:);
end;
if prod(Rx(1:k))<prod(Rx(k+1:Nx)),
   warning('dim(espace des variables)>dim(espace des objets)');
   warning('Risques de problmes d''inversion ');
   warning('et probablement inutilit de la projection');
end;


if length(size(X))<3 & length(size(Y))<3,
   pin=pinv(X);
   B=pin*Y;
   PxY=X*B;
else
   pinv=pseudoinverse(X,k);
   pinv=ipermute(pinv,[k+1:Nx 1:k]);
	B=produitgeneral(pinv,Y,k);
   Xf=permute(X,[k+1:Nx 1:k]);
   PxY=produitgeneral(Xf,B,Nx-k);
end;


%test d'efficacit
QxY=Y-PxY;
%disp('Vrification de l''orthogonalit de la rgression');
%disp(psc(PxY,QxY))




