function [quality,expvar,hotelling]=qualitecubepredic(Xd,Xp,F,Fp);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% qualitecubepredic                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  calucalates the 3 qualities of the projected points
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%    Xd new data
%    Xp new predicted data
%    F loading 1
%    Fp predicted loading 1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   17/10/2002   version 1.0                         %
%   Christophe Durville              TOTALFINAELF    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if ~isequal(size(Xd),size(Xp)),
    uiwait(errordlg({'No good sizes'}));
    return;
end;


Rp=size(Xp);
Np=ndims(Xp);
quality=cell(1,1);
expvar=cell(1,1);
hotelling=cell(1,1);
Xdu=reshape(Xd,[Rp(1),prod(Rp(2:Np))]);
Xpu=reshape(Xp,Rp(1),prod(Rp(2:Np)));
Xdu-Xpu
for i=1:Rp(1),
    u1=Xdu(i,:);
    u2=Xpu(i,:);
    a=(u1*u2')^2;
    b=(norm(u1)*norm(u2))^2;
    quality{1}(i)=norm(u2-u1)^2;
    expvar{1}(i)=a/b; 
end;
quality{1}=quality{1}';
expvar{1}=expvar{1}';
hotelling{1}=mahal(Fp,F);

