function [quality,expvar,hotelling]=qualitecube(X,Xm,F);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% qualitecube                                        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  calucalates the 3 qualities of the projected points
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%    X new data
%    Xm new predicted data
%    F loading 1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   17/11/2002   version 1.1                         %
%   Christophe Durville              TOTALFINAELF    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% utilise la fonction psc  (se trouve notamment ds nwayvi)
% Xm peut se calculer via nmodel
if ~isequal(size(X),size(Xm)),
    uiwait(errdlg({'Error in the estimation of the qualities',' of the cube:not good sizes!'}));
    return;
end;
R=size(X);
N=ndims(X);
quality=cell(1,N);
expvar=cell(1,N);
hotelling=cell(1,N);
for n=1:N,
    expvar{n}=zeros(R(n),1);
    quality{n}=zeros(R(n),1);
    Xn=permute(X,[n,1:n-1,n+1:N]);
    Xmn=permute(Xm,[n,1:n-1,n+1:N]);
    Rn=size(Xn);
    Xnu=reshape(Xn,[Rn(1),prod(Rn(2:N))]);
    Xmnu=reshape(Xmn,Rn(1),prod(Rn(2:N)));
    for i=1:R(n),
        quality{n}(i)=norm(Xmnu(i,:)-Xnu(i,:))^2;
        expvar{n}(i)=norm(Xmnu(i,:))^2/(norm(Xnu(i,:)))^2; %=(psc(Xnu(i,:),Xmnu(i,:))/(norm(Xnu(i,:))*norm(Xmnu(i,:))))^2;
    end;
    if nargin>2
        hotelling{n}=mahal(F{n},F{n});
    else
        hotelling=0;
    end;
end;
