function Z=produitgeneral(X,Y,j);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUT
%  X tenseur de taille mnpq
%  Y tenseur de taille mnrst
%  j number of common dimensions between X and Y
% OUTPUT
%  Z tenseur de taille pqrst
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE
%    psc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   generalisation of product matrix-matrix
%  NB:inner product is a particular case of 
%  general product
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Christophe Durville            TOTALFINAELF
%   22/01/2002
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Sx=size(X);
Sy=size(Y);

 
Nx=length(Sx);
Ny=length(Sy);

if isequal(Nx,2) & ( isequal(Sx(1),1) | isequal(Sx(2),1)),
   Nx=1;
   X=X(:);
   Sx=length(X);
end;
if isequal(Ny,2) & ( isequal(Sy(1),1) | isequal(Sy(2),1)),
   Ny=1;
   Y=Y(:);
   Sy=length(Y);
end;
if isequal(Nx,2) &  isequal(Sx(1),1) & isequal(Sx(2),1),
   Nx=0;
end;
if isequal(Ny,2) &  isequal(Sy(1),1) & isequal(Sy(2),1),
   Ny=0;
end;

Nz=Nx+Ny-2*j;
Sz=[Sx(j+1:Nx),Sy(j+1:Ny)];


if isequal(j,0),
	Z=produittensoriel(X,Y);
elseif Ny<=2 & Nx<=2 & isequal(j,1),
   Z=X'*Y;
elseif Ny==Nx & isequal(j,Nx),
   Z=psc(X,Y);
elseif Nx==j & Ny>Nx
   % preparation of key-words
	ifor=cell(1,Ny);
	iend=cell(1,Ny);
	yexp=[];
   xexp=[];
   poexp=[];
	for n=1:Nz,
   	ifor{n}=sprintf('for i%d=1:Sz(%d),',n,n);
   	iend{n}=sprintf('end;');
	end;
	for n=2:Nx-j,
   	xexp=[xexp,',i',num2str(n)];
   end;
	for n=Nx-j+1:Nz,
   	yexp=[yexp,',i',num2str(n)];
   end;
	for n=2:j,
   	poexp=[poexp,',:'];
   end;
   totexp=['Z(',yexp(2:length(yexp)),')=psc(squeeze(X(:',poexp,')),squeeze(Y(:',poexp,yexp,')));'];
	%execution de la sequence
	[ifor{1:Nz} ,totexp,iend{1:Nz}];
	eval([ifor{1:Nz} ,totexp,iend{1:Nz}]);
	Sz=size(Z);
	if isequal(Sz(1),1),
   	Z=Z';
	end;

else,
   % preparation of key-words
	ifor=cell(1,Ny);
	iend=cell(1,Ny);
	yexp=[];
   xexp=[];
   poexp=[];
	for n=1:Nz,
   	ifor{n}=sprintf('for i%d=1:Sz(%d),',n,n);
   	iend{n}=sprintf('end;');
	end;
	for n=2:Nx-j,
   	xexp=[xexp,',i',num2str(n)];
   end;
	for n=Nx-j+1:Nz,
   	yexp=[yexp,',i',num2str(n)];
   end;
	for n=2:j,
   	poexp=[poexp,',:'];
   end;

   totexp=['Z(i1',xexp,yexp,')=psc(squeeze(X(:',poexp,',i1',xexp,')),squeeze(Y(:',poexp,yexp,')));'];
	%execution de la sequence
	[ifor{1:Nz} ,totexp,iend{1:Nz}];
	eval([ifor{1:Nz} ,totexp,iend{1:Nz}]);
	Sz=size(Z);
	if isequal(Sz(1),1),
   	Z=Z';
	end;
%else
   %error('the case is not possible');
end;


   