function potm=potentiel(mod,spl,A,axi);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% potentiel                                          %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% franais:                                          %
%trace la carte de potentiel d'un jeu de donnes nx2 %
% english:                                           %
%draws the potential contour of dataset nx2          %   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     A matrix with 2 columns
%     spl: PlotStr structure
%     axi:size of the current axes
%     mod:'win' or 'gra'
% OUTPUTS
%     potm
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   10/02/2003    version 1.2                       %
%   d'aprs Eric Bouveresse & Xavier Capron         %
% Christophe Durville U.Marne-La-Valle&TOTALFINAELF%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
guinames;
c=spl.additional.potential.liss;
d=spl.additional.potential.size;
h=findobj('tag','potentiel');
if strcmp(mod,'win'),
   h0 = figure('MenuBar','none', ...
      'Name','Potential functions', ...
      'MenuBar','none', ...
      'resize','off',...
      'NumberTitle','off', ...
      'Position',[300 250 160 160], ...
      'color',WIC,...
      'Tag','potentiel',...
      'toolbar','none');
      h1 = uimenu('Parent',h0, ...
      'Label','&Preferences', ...
      'Tag','prefp');
   h2 = uimenu('Parent',h1, ...
      'Label','&Plot');
   h3 = uimenu('Parent',h2, ...
      'callback','evalin(''caller'',''spl.additional.potential.plot=1;'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
      'tag','1',...
      'Label','&Contour');
   h3 = uimenu('Parent',h2, ...
      'callback','evalin(''caller'',''spl.additional.potential.plot=2;'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
      'tag','2',...
      'Label','&Filled contour');
   h3 = uimenu('Parent',h2, ...
      'callback','evalin(''caller'',''spl.additional.potential.plot=3;'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
      'tag','3',...
      'Label','&Meshed');
   set(findobj('tag',int2str(spl.additional.potential.plot)),'checked','on');
   h2 = uimenu('Parent',h1, ...
      'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.additional.potential.num=1;set(gcbo,''''checked'''',''''on'''');else spl.additional.potential.num=0;set(gcbo,''''checked'''',''''off'''');end;'')',...
      'tag','scaled',...
      'separator','on',...
      'Label','&Scaled');
   if isequal(spl.additional.potential.num,1),
      set(findobj('tag','scaled'),'checked','on');
   end;
   h1=uicontrol('parent', h0,...   % lissage
      'string', 'Constant ',...
      'fontweight','normal',...
      'horizontalalignment','left',...
      'fontsize',10,...
      'backgroundcolor',WIC,...
      'position',[0 100 70 20],...
      'style','text');
   h1=uicontrol('parent', h0,...     %lissage
      'string',c,...
      'callback','evalin(''caller'',''spl.additional.potential.liss=eval(get(gcbo,''''string''''));'');',...
      'fontweight','normal',...
      'fontsize',12,...
      'tag','npc',...
      'position',[80 100 70 20],...
      'style','edit');
    h1=uicontrol('parent', h0,...   % size
      'string', 'Size',...
      'fontweight','normal',...
      'horizontalalignment','left',...
      'fontsize',10,...
      'backgroundcolor',WIC,...
      'position',[0 70 80 20],...
      'style','text');
   h1=uicontrol('parent', h0,...     %size
      'string',d,...
      'callback','evalin(''caller'',''spl.additional.potential.size=eval(get(gcbo,''''string''''));'');',...
      'fontweight','normal',...
      'fontsize',12,...
      'tag','npc',...
      'position',[110 70 40 20],...
      'style','edit');
h1 = uicontrol('parent',h0, ...    %ok
   'Position',[105 15 40 20], ...
   'callback','evalin(''caller'',''spl.additional.potential.exist=1;'');set(findobj(''tag'',''pot''),''checked'',''on'');',...
   'string','OK',...
   'style','pushbutton');
h1 = uicontrol('parent',h0, ...    %cancel
   'Position',[05 15 40 20], ...
   'callback','evalin(''caller'',''spl.additional.potential.exist=0;'');set(findobj(''tag'',''pot''),''checked'',''off'');close gcf',...
   'string','Cancel',...
   'tooltipstring','No potential functions',...
   'style','pushbutton');
h1 = uicontrol('parent',h0, ...    %close
   'Position',[55 15 40 20], ...
   'callback','close gcf',...
   'string','Close',...
   'style','pushbutton');
elseif strcmp(mod,'gra'),
   A=A(:,[spl.factors(1),spl.factors(2)]);
   [m,n]=size(A);
   cste=1/(c*sqrt(2*pi));
   
   minx=axi(1);
   maxx=axi(2);
   rangex=maxx-minx;
   
   miny=axi(3);
   maxy=axi(4);
   rangey=maxy-miny;
      
   incx=rangex/d;
   incy=rangey/d;
   
   apt(:,:,1)=(ones(d,1)*(ones(1,d)*minx+incx*[1:d]))';
   apt(:,:,2)=(ones(d,1)*(ones(1,d)*maxy-incy*[1:d]));
   
   potentmat=zeros(d,d);
   for k=1:m
      score_x=ones(d,d).*A(k,1);
      score_y=ones(d,d).*A(k,2);
      distmatcar(:,:)=(apt(:,:,1)-score_x).^2+(apt(:,:,2)-score_y).^2;
      potentmat=potentmat+exp(-distmatcar(:,:)/(2*c^2)); %  *cste  ????
   end
   potentmat=potentmat/m;
   som=sum(potentmat(:));
   potentmat=potentmat;
   for i=1:d,
      u(i)=axi(1)+(axi(2)-axi(1))*(i)/d;
      v(i)=axi(3)+(axi(4)-axi(3))*(i-1)/d;
   end;
   u=ones(d,1)*u;
   v=v'*ones(1,d);
   switch spl.additional.potential.plot
   case 1
      [c,h]=contour(u,v,flipud(potentmat'));
   case 2
      [c,h]=contourf(u,v,flipud(potentmat'));
   case 3
      imagesc(flipud(potentmat'));
   end;
   if spl.additional.potential.num==1,
      clabel(c,h,'fontsize',7);
   end;
end;
