function   [pr,coord] = matprojec(A,fi)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% matprojec                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     A matrix
%     fi  scalar product
% OUTPUTS
%     pr  projection matrix for the scalar product 
%         fi.pr=A(A'fiA)^{-}A'fi
%     coord = (A'fiA)^{-}A'fi
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Projection matrix  
%  used with cannonique
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/12/2001   version 1.0                        %
%   Christophe Durville               TOTALFINAELF  %
%   Georges Oppenheim                       ORSAY   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%





%--------------------------------------
if nargin==1, pr=A*pinv(A'*A)*A';coord=pinv(A'*A)*A'; end
%--------------------------------------
if nargin==2 
% controles
	if (size(A,1)~=size(fi,1)) |  (size(fi,1)~=size(fi,2)),error('erreur de tailles dans matprojec'),end
	if norm(fi-fi')>0.0000001,error('erreur dans matprojec, la matrice de produit scalaire n est pas symetrique'),return,end
	if sum(eig(A)<=0)>=1, error('erreur dans matprojec, la matrice de produit scalaire n est pas positive'),return,end
%--------------------------------------
pr=A*pinv(A'*fi*A)*A'*fi;coord=pinv(A'*fi*A)*A'*fi;
end
%--------------------------------------

