function potm=hotel(mod,spl,A);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% hotel                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    franais:
% trace la region de confiance de hotelling pour un 
% jeu de donees a 1,2 ou 3 dimensions 
% (seul 12 oprationnel)
%    english
% draws the hotelling confidence for a data set
% with 2 dimensions (1 and 3 in the future)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     mod :'win' window,or  'gra' execution
%     spl structure PlotStr
%     A  matrix of work (nxp)
% OUTPUTS
%     potm
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   10/02/2003    version 1.2                       %
% Christophe Durville U.Marne-La-Valle&TOTALFINAELF%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

guinames;
confid=spl.additional.hotelling.confid;
Ndot=spl.additional.hotelling.size;
h=findobj('tag','hotel');
if strcmp(mod,'win'),
    h0 = figure('MenuBar','none', ...
        'Name','Hotelling''s ellipsoid', ...
        'MenuBar','none', ...
        'resize','off',...
        'NumberTitle','off', ...
        'Position',[450 450 200 200], ...
        'color',WIC,...
        'Tag','hotel',...
        'toolbar','none');
    h1 = uimenu('Parent',h0, ...
        'Label','&Preferences', ...
        'Tag','prefp');
    h2 = uimenu('Parent',h1, ...
        'Label','&Plot');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.additional.hotelling.plot=1;'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','1',...
        'Label','&Contour');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.additional.hotelling.plot=2;'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','2',...
        'Label','&Filled contour');
    h3 = uimenu('Parent',h2, ...
        'callback','evalin(''caller'',''spl.additional.hotelling.plot=3;'');h=get(gcbo,''parent'');h=get(h,''children'');set(h,''checked'',''off'');set(gcbo,''checked'',''on'');',...
        'tag','3',...
        'Label','&Meshed');
    set(findobj('tag',int2str(spl.additional.hotelling.plot)),'checked','on');
    h2 = uimenu('Parent',h1, ...
        'callback','evalin(''caller'',''prov=get(gcbo,''''checked'''');if strcmp(prov,''''off''''),spl.additional.hotelling.num=1;set(gcbo,''''checked'''',''''on'''');else spl.additional.hotelling.num=0;set(gcbo,''''checked'''',''''off'''');end;'')',...
        'tag','scaled',...
        'separator','on',...
        'Label','&Scaled');
    if isequal(spl.additional.hotelling.num,1),
        set(findobj('tag','scaled'),'checked','on');
    end;
    h1=uicontrol('parent', h0,...     % 1st confidence region
        'backgroundcolor',FRC,...
        'position',[5 140 190 50],...
        'style','frame');
    h1=uicontrol('parent', h0,...   % 1st confidence region
        'string', '1st Condidence Region',...
        'fontweight','normal',...
        'horizontalalignment','left',...
        'fontsize',10,...
        'fontweight','bold',...
        'backgroundcolor',FRC,...
        'position',[10 165 180 20],...
        'style','text');
    h1=uicontrol('parent', h0,...   % 1st confidence region
        'string', 'Condidence level:             % ',...
        'fontweight','normal',...
        'horizontalalignment','left',...
        'fontsize',10,...
        'backgroundcolor',FRC,...
        'position',[25 145 167 20],...
        'style','text');
    h1=uicontrol('parent', h0,...     %1st confidence region
        'string',int2str(confid(1)),...
        'callback','evalin(''caller'',''spl.additional.hotelling.confid(1)=eval(get(gcbo,''''string''''));'');',...
        'fontweight','normal',...
        'fontsize',12,...
        'tag','v1',...
        'position',[140 145 30 20],...
        'style','edit');
    h1=uicontrol('parent', h0,...     % 2nd confidence region
        'backgroundcolor',FRC,...
        'position',[5 70 190 50],...
        'style','frame');
    h1=uicontrol('parent', h0,...   % 2nd confidence region
        'string', '2nd Condidence Region',...
        'horizontalalignment','left',...
        'fontsize',10,...
        'fontweight','bold',...
        'backgroundcolor',FRC,...
        'position',[10 95 180 20],...
        'style','text');
    h1=uicontrol('parent', h0,...   % 2nd confidence region
        'string', 'Condidence level:             % ',...
        'fontweight','normal',...
        'horizontalalignment','left',...
        'fontsize',10,...
        'backgroundcolor',FRC,...
        'position',[25 75 167 20],...
        'style','text');
    h1=uicontrol('parent', h0,...     % 2nd confidence region
        'string',int2str(confid(2)),...
        'callback','evalin(''caller'',''spl.additional.hotelling.confid(2)=eval(get(gcbo,''''string''''));'');',...
        'fontweight','normal',...
        'fontsize',12,...
        'tag','v2',...
        'position',[140 75 30 20],...
        'style','edit');
    h1=uicontrol('parent', h0,...   % size
        'string', 'Dot points:',...
        'fontweight','normal',...
        'horizontalalignment','left',...
        'fontsize',10,...
        'backgroundcolor',WIC,...
        'position',[80 40 90 20],...
        'style','text');
    h1=uicontrol('parent', h0,...     %size
        'string',Ndot,...
        'callback','evalin(''caller'',''spl.additional.hotelling.size=eval(get(gcbo,''''string''''));'');',...
        'fontweight','normal',...
        'fontsize',12,...
        'tag','ndot',...
        'position',[150 40 40 20],...
        'style','edit');
    h1 = uicontrol('parent',h0, ...    %ok
        'Position',[145 5 40 20], ...
        'callback','evalin(''caller'',''spl.additional.hotelling.exist=1;'');set(findobj(''tag'',''pot''),''checked'',''on'');',...
        'string','OK',...
        'style','pushbutton');
    h1 = uicontrol('parent',h0, ...    %default
        'Position',[15 5 40 20], ...
        'callback','set(findobj(''tag'',''v1''),''string'',int2str(80));set(findobj(''tag'',''v2''),''string'',int2str(90));set(findobj(''tag'',''ndot''),''string'',int2str(30));evalin(''caller'',''spl.additional.hotelling.confid=[80 90];spl.additional.hotelling.size=30;'');',...
        'string','Default',...
        'tooltipstring','No hotelling functions',...
        'style','pushbutton');
    h1 = uicontrol('parent',h0, ...    %close
        'Position',[80 5 40 20], ...
        'callback','delete(gcbf);',...
        'string','Close',...
        'style','pushbutton');
elseif strcmp(mod,'gra'),
    n=size(A,1);
    p=spl.plotdims;
    if spl.plotdims==3,
        A=A(:,[spl.factors(1),spl.factors(2),spl.factors(3)]);
    elseif spl.plotdims==2,
        A=A(:,[spl.factors(1),spl.factors(2)]);
    end;
    xm=mean(A);
    S=cov(A);
    Sn=S*(n-1)/n;
    [E D]=eig(S);
    d=diag(D);
    prosta=p*finv(confid/100,p,n-p)/(n-p);
    pro=finv(confid/100,p,n-p);
    tt=pro*p*(n-1)/(n-p)        %n*(n-p)
    a=sqrt(d(1)*tt);
    b=sqrt(d(2)*tt);
    if length(d)==3, %p=3
        return;
        c=sqrt(d(3))*tt;
        h=ellipse(xm,[a(1),b(1),c(1)],E,Ndot,'-.r');
        legend(h,['Confidence level: ',int2str(confid(1)),'%'],0);
    else %p=2
        h(1)=ellipse(xm,[a(1),b(1)],E,Ndot,'-.r');
        h(2)=ellipse(xm,[a(2),b(2)],E,Ndot,'r');
        legend(h,['Confidence level: ',int2str(confid(1)),'%'],['Confidence level: ',int2str(confid(2)),'%'],0);
    end;
    
end;
