function varargout = getcvdata(MainFig,varargin)
% function [value1[,value2][,...]] = getcvdata(Handle,'name1'[,'name2'][,...])
% 
% Description:
% gets the value of the application-defined data with name specified by 'name' in the object 
% with handle Handle. If the application-defined data does not exist, an empty matrix will be returned 
% in value*.
% It differs from the standard getappdata because it allows to more than one assignment in a single call.
% value1 is assigned the content of 'name1', value2 is assigned the content of 'name2', and so forth.
% NB: the 'applicationdata' property is present for any object but it cannot be 
%     accessed straightforwardly via the standard set/get commands (see setappdata, getappdata, setcvdata)
% 
% Inputs: 
% Handle: handle to the object
% name  : string defining the application-defined data name
% 
% 
% Outputs:
% value: value of application-define data name
% 
% 
% Called by:
% ActivatePlots, CuBatch, DefaultPlot, DefineArray, EditLabels, nPLS1Model, nPLS1Plot, nPLS1PlotControls,
% nPLS1Report, Model_nPLS1\CheckPlotStruct, OPA, OPA3Report, PARAFACConstraints, PARAFACModel,
% PARAFACOptions, PARAFACPlotControls, PARAFACReport, Model_PARAFAC\CheckPlotStruct,
% PARAFAC2Constraints, PreProcess, TuckerConstraints, TuckerviPreProcess, ResizeCuBatch,
% SelectSamples, SelectVariables
% 
% Subroutines:
% Internal: None
% External: getappdata.m (internal MatLab function)
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 10-Sep-2001 12:10:52
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
%
for i = 1:nargin - 1
   varargout{i} =  getappdata(MainFig,varargin{i});
end