function h=ellipse(cent,ax,E,Ndot,style)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   ellipse 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    french:
% trace une ellipse (ou ellipsoide ds le futur)  partir 
% de ses caracteristiques (cf les entres)
%    english:
% draws an ellipse (or 3D ellipsoid in the future)from 
% its characteristics (see inputs).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     cent  :coordonates of the center
%     a, b  :large and small axis
%     E     :rotation's matrix
%     Ndot  :nb of pts used to trace the ellipse
%     style : as for plot ('-.b', etc...)
% OUTPUTS
%     h:handle
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 10/02/2003    version 1.2                         %
% Christophe Durville U.Marne-La-Valle&TOTALFINAELF%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
a=ax(1);
b=ax(2);
N=length(ax);
if isequal(N,3),
    c=ax(3);
else
    c=0;
end;
% ellipse data:
t=linspace(0,2*pi,Ndot);
if N==2,
    ellip=E*[a*cos(t); b*sin(t)] + repmat(cent',1,Ndot);
    ellip=ellip';
    h=plot(ellip(:,1),ellip(:,2),style);
elseif N==3,
    return;
    [X,Y,Z]=ellipsoid(cent(1),cent(2),cent(3),a,b,c,Ndot);
    h=surf(X,Y,Z);
    %ellip=E*[a*cos(t); b*sin(t);] + repmat(cent',1,Ndot);
    %  TO DO
end;



