function displayinfoproj(mainfig,mo,cpos);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% displayinfoproj                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%  mainfig: handle of CuBatch figure
%  mo:modelout structure
%  cpos: position of preceding text
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% display info for projected data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/12/2002   version 1.0                        %
%   Christophe Durville               TOTALFINAELF  %
%     adapted from Giorgio's code                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
guinames;

Xnew=mo.prediction.data;
Type = {'Single set','Multiple Set'};
S1a = {'\fontsize{10}Name';'Size';'Type';'Missing data'};
%delete(findobj(MainFig,tg,'textfig'))
%NaNPerc = isnan(Xnew{1});
NaNPerc = isnan(Xnew.data);
%if strcmp(Xnew{1}.type,'Batch')
if strcmp(Xnew.type,'Batch')
    %Dims = ['--- ',int2str(Xnew{1}.dims(2:end))];
    Dims = ['--- ',int2str(Xnew.dims(2:end))];
else
    %Dims = int2str(Xnew{1}.dims);     
    Dims = int2str(Xnew.dims);      
end
S1b = {[': ',Xnew.name]
    [': [',Dims,']']
    [': ',Type{find(strcmp({'Data','Batch'},Xnew.type))}]
    num2str(100 * sum(NaNPerc(:)) / prod(size(NaNPerc)),': %3.2f %%')};
%axes('position',[0.0112 0.0377 0.2240 0.9127],'xtick',[],'ytick',[],'box','on','color',[0.3529 0.4314 0.4901],tg,'CBInfoFrame');
fnor = {'fontunits','normalized'};
vert = {'verticalalignment','cap'};
%a    = text(.5,0.40,'\bf\fontsize{12}New Data Xnew',ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
%apos = get(a,'extent');
%text(.05,apos(2)-0.02,S1a,ha,'left',vert{:},fnor{:},tg,'textfig','units','normalized')
%b    = text(.5,apos(2)-0.02,S1b,ha,'left',vert{:},fnor{:},tg,'textfig','units','normalized');
%bpos = get(b,'extent');

d     = text(.5,cpos(2) - 0.05,['\bf\fontsize{12}New Data X'],ha,'center',vert{:},fnor{:},tg,'textfig','units','normalized');
dpos  = get(d,'extent');
text(.05,dpos(2)-0.02,S1a,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized')
e = text(.5,dpos(2)-0.02,S1b,ha,'left','verticalalignment','cap',tg,'textfig','units','normalized');
epos  = get(e,'extent');
if ~isempty(Xnew.description) | ~isempty(Xnew.author)
    f    = text(.5,epos(2)-0.015,'\itClick here for more','verticalalignment','top',tg,'textfig',ha,'center','buttondownfcn','DisplayInfo(gcbf,gcbo);',ud,{Xnew.description,Xnew.author});
    %bpos = get(c,'extent');
end

