function defaultplot(mi,mo,co);
mainfig=findobj('type','figure','userdata','Cubatch');
[spl,c]=getcvdata(mainfig,'PlotStr','Content');
if isempty(c)
   c = co;
end
try
   switch mo(1).modelname
      case 'Tucker'
         if (mi.nbfactors.min(spl.nummode)>spl.plotdims-1 & length(spl.nummode)==1)|length(spl.nummode)==2,
            tuckerplot(spl.type,spl,mi,mo,c);
         else
            uiwait(warndlg({'No default plot available:','to have some, enter in the menu "Results".'}));
         end;
      case 'IV-Tucker'
         if mi.nbfactors.min(spl.nummode)>spl.plotdims-1,
            tuckerviplot(spl.type,spl,mi,mo,getappdata(mainfig,'Content'));
         else
            uiwait(warndlg({'No default plot available:','to have some, enter in the menu "Results".'}));
         end;
      case 'PCA',
         if mi.nbfactors.min>spl.plotdims-1 & length(spl.nummode)<2 & spl.nummode<2,
            acpplot(spl.type,spl,mi,mo,getappdata(mainfig,'Content'));
         else
            uiwait(warndlg({'No default plot available:','to have some, enter in the menu "Results".'}));
         end;
      case 'IV-PCA',
         if mi.nbfactors.min>spl.plotdims-1,
            acpviplot(spl.type,spl,mi,mo,getappdata(1,'Content'));
         else
            uiwait(warndlg({'No default plot available:','to have some, enter in the menu "Results".'}));
         end;
      case 'OPA'
         if spl.plotdims==2
            spl.plotdims=1;
         end
         spl.type='mod';
         spl.format(1)=[3];
         spl.factors=[(mi.nbfactors.min(1)+1) (mi.nbfactors.min(1)) (mi.nbfactors.min(1)-1)];
         opasplot(spl.type,spl,mi,mo,c);
      case 'OPA3D'
         if spl.plotdims==2
            spl.plotdims=1;
         end
         spl.type='mod';
         spl.format(1)=[3];
         spl.factors=[(mi.nbfactors.min(1)+1) (mi.nbfactors.min(1)) (mi.nbfactors.min(1)-1)];
         opa3splot(spl.type,spl,mi,mo,c);
      case 'PARAFAC2'
         spl.format(1)=[3];
         spl.type='mod';
         spl.nummode=1;
         parafac2plot(spl.type,spl,mi,mo,c);
         
      case 'PARAFAC'
         [mo(1:length(mo)).plot] = deal(spl);
         PARAFACPlot('defaultplot',mo)
         set(findobj(mainfig,'tag','cbaxes'),'userdata','defaultplot')
         
      case {'nPLS','PLS'}
         [mo(1:length(mo)).plot] = deal(spl);
         nPLS1Plot('defaultplot',mo)
         set(findobj(mainfig,'tag','cbaxes'),'userdata','defaultplot')
         
      otherwise
         uiwait(warndlg({'No default plot available for the moment.'}));
   end;
   delete(findobj(0,'userdata','PARAFAC Plot Control'))
   delete(findobj(0,'userdata','nPLS1 Plot Control'))
   
catch
   uiwait(warndlg({'No default plot available:','to have some, enter in the menu "Results".'}));
   return
end;