function clearusemodel(mi,mo);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% clearusemodel                                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  clear the projected points (use model)
%  callback of the menu use model/clear projected points
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     mi  ModelIn structure of cubatch
%     mo  ModelOut structure of cubatch
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   17/10/2002   version 1.0                         %
%   Christophe Durville              TOTALFINAELF    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

switch mo(1).modelname
    case {'Tucker'}
        mo.prediction.xfactors={};
        mo.prediction.yfactors={};
        mo.prediction.xpred=[];
        mo.prediction.ypred=[];
        mo.prediction.data=[];
        %mo.prediction.xcumpress=[];
        mo.prediction.ycumpress=[];
        mo.prediction.stats.expvar=[];
        mo.prediction.stats.hotelling=[];
        mo.prediction.stats.quality=[];
    case {'IV-Tucker'}
        mo.prediction.yfactors={};
        mo.prediction.xpred=[];
        mo.prediction.ypred=[];
        mo.prediction.data=[];
    case {'IV-PCA'}
        mo.prediction.xfactors={};
        mo.prediction.yfactors={};
        mo.prediction.xpred=[];
        mo.prediction.ypred=[];
        mo.prediction.data=[];
        mo.prediction.xcumpress=[];
        mo.prediction.ycumpress=[];
        mo.prediction.stats.expvar=[];
        mo.prediction.stats.hotelling=[];
        mo.prediction.stats.quality=[];
    case {'PCA'}
        mo.prediction.xpred=[];
        mo.prediction.xfactors={};
        mo.prediction.data=[];
        mo.prediction.stats.expvar=[];
        mo.prediction.stats.hotelling=[];
        mo.prediction.stats.quality=[];
    case 'PARAFAC'
       mo.prediction = [];
       
    case {'nPLS','PLS'}
       [mo(1:length(mo)).prediction] = deal([]);
    
    otherwise
        uiwait(warndlg({'SG, op til dig! ;o)'}));
end;   
defaultplot(mi,mo);
setappdata(gcbf,'Results',mo);