function h = cenwindow(Color,Name,cbf,Width,Height)
% function h = cenwindow (Color,Name,cbf,Width,Height);
% 
% Description:
% Opens a figure centred in the screen, with no menus, not resizeable, having 'window' as 'tag' 
% and 'pixels' as 'units'
% 
% 
% Inputs: 
% Color       : figure's background colour
% Name        : figure's name
% cbf         : close request function, there is no default so it is at least necessary to specify it 
%               as 'delete(gcbf)'
% Width,Height: width and height (in pixel) of the window that one wants to open.
% 
% 
% Outputs:
% h: new figure's handle
% 
% 
% Called by:
% several m-files opening a GUI-window
% 
% Subroutines:
% Internal: None
% External: guinames, screensize
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 26-Jun-2002 12:59:18
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
% 
ScSize = screensize;
if nargin < 4
   Width  = .5 * ScSize(3);
   Height = .5 * ScSize(4);
end
if isempty(cbf)
   cbf = 'delete(gcbf)';
end

GuiNames
VPos   = fix(.5*(ScSize(3) - Width));
HPos   = fix(.5*(ScSize(4) - Height));
Pos    = [VPos HPos Width Height];
h      = figure(fip{:},'name',Name,'color',Color,crf,cbf,'toolbar','figure');
set(h,pos,Pos);
