function   [VA,VB,cosangles]=canonique(A,B);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% canonique                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     A,B matrices whith columns = basis of 
%             2 subspaces  [A] and [B]
% OUTPUTS
%     cosangles:canonical angles
%     VA , VB:  canonical vectors
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculates the canonical angles cosangles and     % 
% the corresponding couples of vectors (orthogonal) %
% VA and VB.                                        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calls:matprojec                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/12/2001   version 1.0                        %
%   Christophe Durville               TOTALFINAELF  %
%   Georges Oppenheim                       ORSAY   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



% les projecteurs
prA=matprojec(A);
prB=matprojec(B);

% les matrices a diagonaliser
qA=prA*prB; qB=prB*prA;
%----------------
% les diagonalisations
[vA,lA]=eig(qA);lA=real(lA);  % CHANGER LES NOMS vA<-vecCanoA canonique
[vB,lB]=eig(qB);lB=real(lB);
%----------------
% reperages des vecteurs
%maxdim=min(rank(A),rank(B));
maxdim=min(min(size(A)),min(size(B)));
lAvec=diag(-lA);[lAs,indA]=sort(lAvec);lAvec=-lAvec(indA);vA=vA(:,indA);
lBvec=diag(-lB);[lBs,indB]=sort(lBvec);lBvec=-lBvec(indB);vB=vB(:,indB);
cosangles=sqrt(lAvec(1:maxdim));
VA = vA(:,1:maxdim);  	% taille n,r
VB = vB(:,1:maxdim);	% taille n,r
%--------------------------------------


% coordonnees des variables initiales dans la base des variables canoniques 
hA = A'*VA; hB= B'*VB;

% Coordonnees des vecteurs canoniques dans les variables initiales
coorCAdansA = pinv(A)*VA;
coorCBdansB = pinv(B)*VB;

