function [bootstat, bootsam] = bootstrpregression(nboot,nsortie,bootfun,varargin)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% bootstrpregression                                 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     nboot       number of bootstrap resamplings
%     nsortie     number of outputs of bootfun
%     bootfun     function 
%     varargin    inputs of bootfun (cells)
% OUTPUTS
%     bootstat    cells of the outputs of bootfun
%     bootsam     matrix of the random positions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Resample the inputs of bootfun , and do bootfun    %
% with the resamples.                                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Modifiied from the m-file "bootstrp" of matlab 5.3 %
%   (statistics toolbox)                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINES                                        %
%   unidrnd  (statistic toolbox)                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   04/09/2002   version 1.0                         %
%   Christophe Durville              TOTALFINAELF    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% Initialize matrix to identify scalar arguments to bootfun.
la = length(varargin);
scalard = zeros(la,1);
db = cell(la,1);

% find out the size information in varargin.

for k = 3:la,
    scalard(k) = 1;
end;  %  scalard = [0 0 1 1 1 1  1]
R=size(varargin{1});
NN=[ndims(varargin{1}),ndims(varargin{2})];

% Create index matrix of bootstrap samples.
bootsam = unidrnd(R(1),R(1),nboot);


% Initialize a matrix to contain the results of all the bootstrap calculations.
% bootstat = zeros(nboot,ntheta*ptheta);
bootstat=cell(1,nsortie);
tmp=bootstat;


for bootiter = 1:nboot  % Do bootfun - nboot times.
    for k = 1:la,
        if scalard(k) == 0
            if NN(k)==2,
                db{k} = varargin{k}(bootsam(:,bootiter),:);
            elseif NN(k)==3,
                db{k} = varargin{k}(bootsam(:,bootiter),:,:);
            end;
        else
            db{k} = varargin{k};
        end;
    end;
    [tmp{1:nsortie}] = feval(bootfun, db{:});     % execution
    
    if nsortie==10,  %tuckerVI
       if NN(2)==3, %Y cube
          for n=1:NN(2),
             bootstat{1}{n}(:,:,bootiter)=(tmp{1}{n});
             bootstat{3}{n}(:,:,bootiter)=(tmp{3}{n});
             bootstat{5}{n}(:,:,bootiter)=(tmp{5}{n});
             bootstat{8}{n}(:,:,bootiter)=tmp{8}{n};  %loadix
             bootstat{9}{n}(:,:,bootiter)=tmp{9}{n};  %loadiy
          end;
          bootstat{2}(:,:,:,bootiter)=tmp{2}; %corey
          bootstat{4}(:,:,:,bootiter)=tmp{4}; %coreyvi
          bootstat{6}(:,:,:,bootiter)=tmp{6}; %coreyvio.
          bootstat{7}(:,:,bootiter)=tmp{7};  %bcoeff
          bootstat{10}(:,:,:,bootiter)=tmp{10}; %Ypred
       elseif NN(2)==2,   %Y matrix
            for n=1:NN(2),
                n
                tmp{1}{n}
                bootiter
                bootstat{1}{n}(:,:,bootiter)=(tmp{1}{n});
                bootstat{3}{n}(:,:,bootiter)=(tmp{3}{n});
                bootstat{5}{n}(:,:,bootiter)=(tmp{5}{n});
            end;
            bootstat{2}(:,:,bootiter)=tmp{2};
            bootstat{4}(:,:,bootiter)=tmp{4};
            bootstat{6}(:,:,bootiter)=tmp{6};
            bootstat{7}(:,:,bootiter)=tmp{7};  %bcoeff
           bootstat{10}(:,:,bootiter)=tmp{10}; %Ypred
        end;
    else 
        
    end; %end tuckerVI
end;


