function [bootstat, bootsam] = bootstrpanadon(nboot,nsortie,bootfun,varargin)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% bootstrpanadon                                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUTS
%     nboot      number of bootstrap resamplings
%     nsortie    number of outputs of bootfun
%     bootfun    function 
%     varargin   inputs of bootfun (cells)
% OUTPUTS
%     bootstat    cells of the outputs of bootfun
%     bootsam     matrix of the random positions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Resample the inputs of bootfun , and do bootfun    %
% with the resamples.                                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Modifiied from the m-file "bootstrp" of matlab 5.3 %
%   (statistics toolbox)                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   15/12/2001   version 1.0                         %
%   Christophe Durville              TOTALFINAELF    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% Initialize matrix to identify scalar arguments to bootfun.
la = length(varargin);
scalard = zeros(la,1); db = cell(la,1);

% find out the size information in varargin.

for k = 2:la
   scalard(k) = 1;
end;
R=size(varargin{1});
N=ndims(varargin{1});

% Create index matrix of bootstrap samples.
bootsam = unidrnd(R(1),R(1),nboot);


% Initialize a matrix to contain the results of all the bootstrap calculations.
% bootstat = zeros(nboot,ntheta*ptheta);
bootstat=cell(1,nsortie);
tmp=bootstat;

% Do bootfun - nboot times.
for bootiter = 1:nboot
   for k = 1:la
      if scalard(k) == 0
         if N==2,
            db{k} = varargin{k}(bootsam(:,bootiter),:);
         elseif N==3,
            db{k} = varargin{k}(bootsam(:,bootiter),:,:);
         end;
      else
         db{k} = varargin{k};
      end;
   end;
   [tmp{1:nsortie}] = feval(bootfun, db{:});
   if N==3,
      for n=1:N,
         bootstat{1}{n}(:,:,bootiter)=(tmp{1}{n});
         if nsortie>1,   %core matrix
            bootstat{2}(:,:,:,bootiter)=tmp{2};
         end;
      end;
   else,  % N==2,
      for i=1:nsortie,
         bootstat{i}(bootiter,:)=(tmp{i}(:))';
      end;
   end;
end;


