function SkipCell = SkCell(s,e,st)
% function SkipCell = SkCell (s,e,st);
% 
% Description:
% Creates a cell vector of chars with a list of the fashion: '1st ****', '2nd ****', ...
% >> skcell(1,3,'Var.')
%    ans = 
%    '1st Var.'    '2nd Var.'      '3rd Var.'
% 
% Inputs: 
% s: integer defining the first number in the list
% e: integer defining the last number in the list
% st: string to be added after the ordinal number.
% 
% Outputs:
% SkipCell: cell vector of chars with the desired labels.
% 
% Called by:
% nPLS1PlotControls, Model_nPLS1\Plot_XYLoadings, PARAFACPlotControls, Model_PARAFAC\Plot_Loadings, 
% SelectSamples, SelectVariables
% 
% Subroutines:
% Internal: None
% External: None
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 04-Jan-2002 20:23:52
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 


if nargin < 4
   flag = '';
end
a = strrep(cellstr(num2str([s:e]')),' ','');
b = ['st ' st;'nd ' st;'rd ' st;'th ' st];
for i = 1:e - s + 1
   if a{i}(end) == '1'
      c =  b(1,:);
      if size(a{i},2) > 1
         if a{i}(end-1) == '1'
            c = b(4,:);
         end
      end
   elseif a{i}(end) == '2'
      c =  b(2,:);
      if size(a{i},2) > 1
         if a{i}(end-1) == '1'
            c = b(4,:);
         end
      end
   elseif a{i}(end) == '3'
      c =  b(3,:);
      if size(a{i},2) > 1
         if a{i}(end-1) == '1'
            c = b(4,:);
         end
      end
   else
      c = b(4,:);
   end
   SkipCell{i} = [a{i},c];
end
