function X = ResamplingExtract(Array,Factor,Segments)
% function X = ResamplingExtract (Array,Factor,Segments);
% 
% Description:
% Extracts the scores or the parameters stored in a three-way array produced by a resampling 
% (validation) method such as Leave One Out (or jackknife) and Bootstrap.
% 
% Inputs: 
% Array   : three-way (I x J x K) array with the parameters in the first (i.e. sample/batch) mode or
%           the predictions
% Factor  : j index for Array
% Segments: composition of the segments (k-th column refers to the k-th vertical slab of Array)
% 
% Outputs:
% X: extracted parameters. Each row correspond to a sample in the original array. When the number of 
%    occurrences of a certain sample/batch is insufficient NaNs are used to fill in. 
% 
% Called by:
% Model_nPLS1\Plot_XYLoadings, Model_nPLS\Plot_TULoadings, Model_nPLS\Plot_Pred_Meas, 
% Model_PARAFAC\Plot_Loadings
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 13-Aug-2002 12:55:04
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 

u = {};
t_u  = squeeze(Array(:,Factor,1:size(Segments,2)));
t2_u = [];
for j = 1:size(t_u,2)
   u{j} = unique(Segments(:,j));
   t2_u(end+1:end+length(u{j}),1) = t_u(u{j},j);
end
u = cat(1,u{:});
X = repmat(NaN,size(t_u));
for j=1:size(X,1)
   X(j,1:length(find(u == j))) = t2_u(find(u == j))';
end

