function val=psc(A,B)

% psc    : Produit scalaire de deux tenseurs d'ordre p
%
% Syntaxe : val = psc(A,B)
%
% Entre
%      - A,B : Tenseurs
%
% Sortie
%      - val : Scalaire : Produit scalaire de A et de B


% Dimensions

N=size(A);
p=length(N);


% Calcul du produit scalaire

if p==2
  val=trace(B'*A);
else
  val=0;
  s=[];
  for i=1:p-1
    s=[s ':,'];
  end;
  ch=['val=val+psc(A(' s 'i),B(' s 'i));'];
  for i=1:N(p)
    eval(ch);
  end;
end;




